/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.record.measurement.panel.DescriptionPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.ZebraBarcodeScanner;

public class ScanBarcodeWizardStep
implements WizardStep {
    private boolean isCleaned = false;
    private final ZebraBarcodeScanner zebraScanner;
    private static final String titleText = "Scan Barcode";
    private static final String connectingText = "Connecting to barcode scanner... \nIf device connection fails, you may type the barcode in manually.";
    private static final String connectedText = "Please scan the sample's identifier barcode now. \nIf the barcode is damaged/unreadable then you may type it in manually.";
    private final BreezeInputField nameInputField = new BreezeInputField("Barcode", "", " ", BreezeInputFieldHelper.Format.TwoRows);
    private final ViewClass viewClass;
    private final BreezeFrame mainFrame;
    private final DescriptionPanel descriptionPanel = new DescriptionPanel("Connecting to barcode scanner... \nIf device connection fails, you may type the barcode in manually.", null, new Insets(0, 0, 0, 0));
    private final Runnable clickNext;
    private final OnBarcode onBarcode;

    public ScanBarcodeWizardStep(BreezeFrame breezeFrame, final Color color, OnBarcode onBarcode, Runnable runnable) {
        this.mainFrame = breezeFrame;
        this.onBarcode = onBarcode;
        this.clickNext = runnable;
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel("", true);
        this.nameInputField.setLabelWidth(120);
        this.nameInputField.setUnitLabelWidth(50);
        pPDescriptionPanel.addOption((JComponent)((Object)this.descriptionPanel), new Insets(0, 0, 0, 50));
        pPDescriptionPanel.addOption(this.nameInputField);
        this.viewClass = new ViewClass(titleText, "", pPDescriptionPanel);
        this.zebraScanner = new ZebraBarcodeScanner(new ZebraBarcodeScanner.BarcodeListener(){
            private final BreezeFrame _frame;
            final /* synthetic */ ScanBarcodeWizardStep this$0;
            {
                this.this$0 = scanBarcodeWizardStep;
                this._frame = this.this$0.mainFrame;
            }

            @Override
            public void onScannerConnected() {
                this.this$0.descriptionPanel.setDescription(ScanBarcodeWizardStep.connectedText);
            }

            @Override
            public void onBarcodeScanned(String string) {
                SwingUtilities.invokeLater(() -> {
                    this.this$0.nameInputField.setValue(string);
                    this.this$0.clickNext.run();
                });
            }

            @Override
            public void onError(String string) {
                BreezeOptionDialog.showDialog(this._frame, color, AbstractBreezeDialog.MessageType.ERROR_OPTION, "Barcode Scanner Error", string);
            }
        });
    }

    public boolean cleanUp() {
        if (!this.isCleaned) {
            try {
                this.zebraScanner.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isCleaned = true;
        return true;
    }

    public boolean isCleaned() {
        return this.isCleaned;
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        boolean bl2 = this.onBarcode.onBarcode(this.nameInputField.getValue());
        return bl2 ? WizardStep.LeaveResult.Ok : WizardStep.LeaveResult.Retry;
    }

    @Override
    public ViewClass getViewClass() {
        return this.viewClass;
    }

    public static interface OnBarcode {
        public boolean onBarcode(String var1);
    }
}

