/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog.card;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.ModelListHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeTogglePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.card.FunctionNodePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.card.NodeCard;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.main.play.GraphHelper;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.map.common.BrowserLauncher;
import se.prediktera.map.common.error.Logg;

public class BreezeNodePanel
extends JPanel
implements NodeCard.NodeClickCallback {
    private final JPanel centerPanel = new JPanel(new GridBagLayout());
    private final List<ItemListener> listeners = new ArrayList<ItemListener>();
    private final String selectedFromStart;
    private List<? extends AbstractCardInfo> functions;
    private AbstractCardInfo node;
    private String toggleName;
    private String filterString = "";
    private static final HashMap<String, ImageIcon> icons = new HashMap();

    public BreezeNodePanel(String string) {
        super(new GridBagLayout());
        this.selectedFromStart = string;
        this.setBackground(BreezeTheme.getInstance().getDialogBackground());
        this.centerPanel.setBackground(BreezeTheme.getInstance().getDialogBackground());
        final BreezeInputField breezeInputField = new BreezeInputField("Filter", "", "", BreezeInputFieldHelper.Format.OneRow);
        breezeInputField.getTextField().setCheckTextChanged(false);
        breezeInputField.setText("");
        breezeInputField.getTextField().addKeyListener(new KeyAdapter(this){
            final /* synthetic */ BreezeNodePanel this$0;
            {
                this.this$0 = breezeNodePanel;
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.this$0.populateCenterPanel(StringHelper.removeSpace(breezeInputField.getValue().toLowerCase()));
            }
        });
        breezeInputField.addChangeListener(textActionEvent -> {
            if (!textActionEvent.isFocusLost()) {
                this.populateCenterPanel(StringHelper.removeSpace(breezeInputField.getValue().toLowerCase()));
            }
        });
        breezeInputField.requestFocusAndSelectAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)breezeInputField, gridBagConstraints);
        Dimension dimension = new Dimension(100, 30);
        breezeInputField.setMinimumSize(dimension);
        breezeInputField.setPreferredSize(dimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)EntryMainHelper.createButton("", "help", () -> {
            String string = this.toggleName.equalsIgnoreCase("all") ? "documentation" : this.toggleName.toLowerCase() + "s";
            BrowserLauncher.open((String)("https://help.prediktera.com/breeze/" + string));
        }), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)new BreezeScrollPane(this.centerPanel), gridBagConstraints);
    }

    private void populateCenterPanel(String string) {
        Object object;
        this.filterString = string;
        boolean bl = this.toggleName.equalsIgnoreCase("all");
        this.centerPanel.removeAll();
        int n = 1;
        List list = this.functions.stream().filter(abstractCardInfo -> BreezeNodePanel.getGroup(abstractCardInfo) == null && this.filterBy(string, (AbstractCardInfo)abstractCardInfo)).collect(Collectors.toList());
        LinkedHashMap linkedHashMap = this.functions.stream().filter(abstractCardInfo -> BreezeNodePanel.getGroup(abstractCardInfo) != null && this.filterBy(string, (AbstractCardInfo)abstractCardInfo)).collect(Collectors.groupingBy(BreezeNodePanel::getGroup, LinkedHashMap::new, Collectors.toList()));
        FunctionNodePanel functionNodePanel = null;
        Object object2 = linkedHashMap.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            List list2 = (List)linkedHashMap.get(object);
            FunctionNodePanel functionNodePanel2 = new FunctionNodePanel((String)object + " (" + list2.size() + ")", list2, this, bl, this.selectedFromStart);
            if (((String)object).equals(AbstractCardInfo.GroupType.Geo.toString())) {
                functionNodePanel = functionNodePanel2;
                continue;
            }
            this.centerPanel.add((Component)functionNodePanel2, BreezeNodePanel.getNextSection(n++));
        }
        if (functionNodePanel != null) {
            this.centerPanel.add(functionNodePanel, BreezeNodePanel.getNextSection(n++));
        }
        if (!list.isEmpty()) {
            this.centerPanel.add((Component)new FunctionNodePanel("Other (" + list.size() + ")", list, this, bl, this.selectedFromStart), BreezeNodePanel.getNextSection(n++));
        }
        if (this.centerPanel.getComponentCount() == 0) {
            this.centerPanel.add((Component)new BreezeLabel("No matching results"), BreezeNodePanel.getNextSection(n++));
        }
        if ((object2 = this.getSelectedCard()) != null) {
            this.centerPanel.addComponentListener(new ComponentAdapter(this, (NodeCard)object2){
                final /* synthetic */ NodeCard val$selectedCard;
                final /* synthetic */ BreezeNodePanel this$0;
                {
                    this.val$selectedCard = nodeCard;
                    this.this$0 = breezeNodePanel;
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    this.this$0.centerPanel.scrollRectToVisible(GraphHelper.getBoundsRelativeToAncestor(this.val$selectedCard, this.this$0.centerPanel));
                }
            });
        }
        object = BreezeNodePanel.getNextSection(n);
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).weighty = 1.0;
        this.centerPanel.add((Component)new JLabel(""), object);
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    private boolean filterBy(String string, AbstractCardInfo abstractCardInfo) {
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>(abstractCardInfo.getKeywords());
            arrayList.add(StringHelper.removeSpace(abstractCardInfo.getShortDescription()));
            arrayList.add(StringHelper.removeSpace(abstractCardInfo.getDescription()));
            AbstractCardInfo.GroupType groupType = abstractCardInfo.getGroup();
            if (groupType != null) {
                arrayList.add(groupType.name());
            }
            for (String string2 : arrayList) {
                if (!string2.toLowerCase().contains(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static String getGroup(Object object) {
        AbstractCardInfo abstractCardInfo;
        AbstractCardInfo.GroupType groupType;
        if (object instanceof AbstractCardInfo && (groupType = (abstractCardInfo = (AbstractCardInfo)object).getGroup()) instanceof AbstractCardInfo.GroupType) {
            AbstractCardInfo.GroupType groupType2 = groupType;
            return groupType2.toString();
        }
        return null;
    }

    public static void clearCache() {
        icons.clear();
    }

    public static ImageIcon getIcon(Object object) {
        AbstractCardInfo abstractCardInfo;
        String string;
        if (object instanceof AbstractCardInfo && StringUtils.isNotEmpty((CharSequence)(string = (abstractCardInfo = (AbstractCardInfo)object).getImageIcon()))) {
            ImageIcon imageIcon = icons.get(string);
            if (imageIcon == null) {
                try {
                    imageIcon = ImageHelper.getResourceIcon("node_icons/" + string);
                    icons.put(string, imageIcon);
                }
                catch (Exception exception) {
                    Logg.error((String)("Cannot load icon for node name: " + string), (Throwable)exception);
                    icons.put(string, null);
                }
            }
            return imageIcon;
        }
        return null;
    }

    private static GridBagConstraints getNextSection(int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        return gridBagConstraints;
    }

    public NodeCard getSelectedCard() {
        for (int i = 0; i < this.centerPanel.getComponentCount(); ++i) {
            FunctionNodePanel functionNodePanel;
            Component component = this.centerPanel.getComponent(i);
            if (!(component instanceof FunctionNodePanel) || (component = (functionNodePanel = (FunctionNodePanel)component).getSelectedCard()) == null) continue;
            return component;
        }
        return null;
    }

    public AbstractCardInfo getSelectedItem() {
        return this.node;
    }

    public void setSelectedItem(BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo> toggleItem) {
        this.toggleName = toggleItem.getName();
        this.functions = toggleItem.getTypes();
        if (this.functions == null) {
            this.functions = new ArrayList<AbstractCardInfo>();
        }
        this.populateCenterPanel(this.filterString);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listeners.add(itemListener);
    }

    @Override
    public void onClick(AbstractCardInfo abstractCardInfo) {
        this.node = abstractCardInfo;
        for (ItemListener itemListener : this.listeners) {
            itemListener.itemStateChanged(new ItemEvent(new Choice(), 0, abstractCardInfo, 1));
        }
    }

    static void main() {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Add new node panel");
        jFrame.setDefaultCloseOperation(3);
        final List<AbstractCardInfo> list = ModelListHelper.getModelTypesSorted(new WorkflowWithoutIO());
        BreezeTheme.changeTheme("dark");
        BreezeTogglePanel.ToggleItem<AbstractCardInfo> toggleItem = new BreezeTogglePanel.ToggleItem<AbstractCardInfo>("Test", "Test"){

            @Override
            public List<AbstractCardInfo> getTypes() {
                return list;
            }
        };
        BreezeNodePanel breezeNodePanel = new BreezeNodePanel("PythonScript");
        breezeNodePanel.setSelectedItem((BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo>)toggleItem);
        jFrame.getContentPane().add((Component)breezeNodePanel, "Center");
        jFrame.setSize(1600, 1024);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

