/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog.card;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import lombok.Generated;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeButtonInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeTogglePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.card.BreezeNodePanel;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class BreezeNodeTogglePanel
extends AbstractBreezeCustomPanel {
    private final List<TogglePanel> togglePanelList = new ArrayList<TogglePanel>();
    private final BreezeNodePanel methodPanel;
    private TogglePanel togglePanel;

    public BreezeNodeTogglePanel(List<BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo>> list, BreezeType breezeType, String string) {
        this.methodPanel = new BreezeNodePanel(string);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(130, 80));
        jPanel.setPreferredSize(new Dimension(130, 80));
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel2.setOpaque(false);
        jPanel2.setBorder(BorderFactory.createLineBorder(breezeType.getColor(), 3));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        jPanel2.add((Component)this.methodPanel, gridBagConstraints2);
        this.methodPanel.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1 && this.togglePanel != null) {
                this.optionDialog.okButtonMouseClicked(null);
            }
        });
        if (list != null) {
            BreezeFrame.setRelativeSize(this, 0.8);
            for (BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo> toggleItem : list) {
                gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.insets = new Insets(20 + (this.togglePanelList.isEmpty() ? 20 : 0), 0, 0, 0);
                gridBagConstraints2.anchor = 18;
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.gridy = jPanel.getComponentCount();
                final TogglePanel togglePanel = new TogglePanel(toggleItem, breezeType);
                togglePanel.setPreferredSize(new Dimension(0, 60));
                togglePanel.setName(toggleItem.getName());
                jPanel.add((Component)togglePanel, gridBagConstraints2);
                togglePanel.addSelectListener(new MouseAdapter(this){
                    final /* synthetic */ BreezeNodeTogglePanel this$0;
                    {
                        this.this$0 = breezeNodeTogglePanel;
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        this.this$0.setSelectedItem(togglePanel);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        togglePanel.setHovering(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        togglePanel.setHovering(false);
                    }
                });
                this.togglePanelList.add(togglePanel);
            }
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(20, 0, 0, 0);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridy = jPanel.getComponentCount();
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            JPanel jPanel3 = new JPanel();
            jPanel3.setOpaque(false);
            jPanel.add((Component)jPanel3, gridBagConstraints2);
            if (!this.togglePanelList.isEmpty()) {
                this.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
        breezeButton2.setVisible(false);
        breezeButton3.setText("Close");
    }

    public void setSelectedIndex(int n) {
        this.setSelectedItem(this.togglePanelList.get(n));
    }

    private void setSelectedItem(TogglePanel togglePanel) {
        this.togglePanel = togglePanel;
        for (TogglePanel togglePanel2 : this.togglePanelList) {
            togglePanel2.setSelected(false);
        }
        togglePanel.setSelected(true);
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    public static ImageIcon createIcon(AbstractBreezeFunctionInfo.FunctionType functionType, int n, Color color) {
        Shape shape = BreezeNodeTogglePanel.createShape(functionType, n);
        if (shape != null) {
            return ImageHelper.shapeToImageIcon(shape, n, n, new Color(0, 0, 0, 0), color);
        }
        return null;
    }

    private static Shape createShape(AbstractBreezeFunctionInfo.FunctionType functionType, int n) {
        switch (functionType) {
            case Segmentation: {
                return new Ellipse2D.Double(0.0, 0.0, n, n);
            }
            case Descriptor: {
                return new Rectangle2D.Double(0.0, (double)n / 4.0, n, (double)n / 2.0);
            }
            case Action: {
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(0.0, (double)n / 2.0);
                generalPath.lineTo((double)n / 2.0, (double)n);
                generalPath.lineTo((double)n, (double)n / 2.0);
                generalPath.lineTo((double)n / 2.0, 0.0);
                return generalPath;
            }
        }
        return null;
    }

    @Override
    public BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo> getResult() {
        for (TogglePanel togglePanel : this.togglePanelList) {
            if (!togglePanel.isSelected()) continue;
            return togglePanel.getToggleItem();
        }
        return null;
    }

    public AbstractCardInfo getType() {
        return this.methodPanel.getSelectedItem();
    }

    public class TogglePanel
    extends BreezeGradientPanel
    implements BreezeButtonInterface {
        private final BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo> toggleItem;
        private final BreezeLabel headerLabel = new BreezeLabel();
        private final Color[] colorNormal;
        private final Color[] colorHover;
        private final Color[] colorSelected;
        private boolean selected = false;
        private boolean hovering = false;

        public TogglePanel(BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo> toggleItem, BreezeType breezeType) {
            this.toggleItem = toggleItem;
            Color color = breezeType.getColor();
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            Color color2 = breezeTheme.getPlotGridColor();
            this.colorNormal = new Color[]{color2, color2, color2};
            this.colorHover = new Color[]{color2, color2, color2};
            this.colorSelected = new Color[]{color, color, color};
            this.setCursor(Cursor.getPredefinedCursor(12));
            String string = toggleItem.getName();
            this.headerLabel.setText(string);
            this.headerLabel.setIcon(BreezeNodeTogglePanel.createIcon(AbstractBreezeFunctionInfo.FunctionType.parse(string), 14, breezeTheme.getLabelForeground()));
            this.headerLabel.setHorizontalTextPosition(0);
            this.headerLabel.setVerticalTextPosition(1);
            this.headerLabel.setFontSize(16);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.headerLabel, gridBagConstraints);
            this.updateColors();
        }

        public void setHovering(boolean bl) {
            this.hovering = bl;
            this.updateColors();
        }

        public synchronized void addSelectListener(MouseListener mouseListener) {
            super.addMouseListener(mouseListener);
            this.headerLabel.addMouseListener(mouseListener);
        }

        public void setSelected(boolean bl) {
            BreezeNodeTogglePanel.this.methodPanel.setSelectedItem(this.toggleItem);
            this.selected = bl;
            this.updateColors();
        }

        private void updateColors() {
            Color[] colorArray = this.selected ? this.colorSelected : (this.hovering ? this.colorHover : this.colorNormal);
            this.setForeground(colorArray[1]);
            this.setBackground(colorArray[2]);
            this.headerLabel.setForeground(this.selected ? Color.white : BreezeTheme.getInstance().getLabelForegroundDifuse());
            this.setBorder(BorderFactory.createLineBorder(colorArray[0]));
        }

        @Override
        public void doClick() {
            for (MouseListener mouseListener : this.getMouseListeners()) {
                mouseListener.mousePressed(null);
            }
        }

        @Generated
        public BreezeTogglePanel.ToggleItem<? extends AbstractCardInfo> getToggleItem() {
            return this.toggleItem;
        }

        @Generated
        public boolean isSelected() {
            return this.selected;
        }
    }
}

