/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.information;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.common.swing.information.InformationEntry;
import se.prediktera.breeze.frontend.common.swing.information.InformationGroups;
import se.prediktera.breeze.frontend.common.util.BreezeUser;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.Logg;

public class InformationFormat {
    private final HashMap<String, FormatText> formatByKey = new HashMap();

    public InformationFormat(InformationEntry informationEntry) {
        this.formatByKey.put("DoE", new FormatText("Group", ""));
        this.formatByKey.put("CreatedBy", new CreatedByText(informationEntry, "Created by"));
        this.formatByKey.put("CreatedDate", new FormatText("Created date", null));
        this.formatByKey.put("ModifiedDate", new FormatText("Modified date", null));
        this.formatByKey.put("FieldOfView", new FormatUnit(informationEntry, "Field of view", "%s"));
        this.formatByKey.put("DroppedFrames", new FormatText("Dropped", "frames"));
        this.formatByKey.put("Length", new FormatUnit(informationEntry, "%s"));
        this.formatByKey.put("Position", new FormatUnit(informationEntry, "%s"));
        this.formatByKey.put("Height", new FormatText("mm"));
        this.formatByKey.put("CameraHeight", new FormatText("Height", "pixels"));
        this.formatByKey.put("Resolution", new FormatUnit(informationEntry, "%s/pixels"));
        this.formatByKey.put("Speed", new FormatUnit(informationEntry, "%s/sec"));
        this.formatByKey.put("FrameRate", new FormatText("Frame rate", "frames/sec"));
        this.formatByKey.put("Frames", new FormatText("frames"));
        this.formatByKey.put("PixelsPerLine", new FormatText("Pixels per line", "pixels"));
        this.formatByKey.put("Temperature", new FormatDegree("Temperature"));
        this.formatByKey.put("IntegrationTime", new FormatText("Integration time", "\u00b5s"));
        this.formatByKey.put("Type", new FormatText("Type", ""));
        this.formatByKey.put("Serial no", new FormatText("Serial Number", ""));
        this.formatByKey.put("MeasurementId", new FormatText("Measurement Id", null));
        this.formatByKey.put("Time", new FormatTime("Time"));
        this.formatByKey.put("Wavelength", new FormatSpectralBands(informationEntry, "Spectral bands", "bands"));
        this.formatByKey.put("DualCameraMode", new FormatTextLabel("Dual camera mode"));
        this.formatByKey.put("MultiCameraMode", new FormatTextLabel("Multi camera mode"));
        this.formatByKey.put("ReflectanceTargetValue", new FormatText("Reflectance target average", ""));
        this.formatByKey.put("ReflectanceTarget", new FormatText("Reflectance target", ""));
        this.formatByKey.put("SampleMover", new FormatText("Name", ""));
        this.formatByKey.put("SampleMoverType", new FormatTextLabel("Type"));
        this.formatByKey.put("FileSize", new FormatText("File size", ""));
        this.formatByKey.put("OrigFile", new FormatText("Original file", ""));
        this.formatByKey.put("Version", new FormatText("Breeze version", ""));
        this.formatByKey.put("RealignMethod", new FormatTextLabel("Realign method"));
        this.formatByKey.put("DetectorJumpAdjustment", new FormatTextLabel("Detector jump adjustment"));
        this.formatByKey.put("RgbBands", new FormatBands(informationEntry, "Rgb bands"));
        this.formatByKey.put("HistogramRange", new FormatMinMaxBands("Histogram range"));
        this.formatByKey.put("ConvertedTo", new FormatMinMaxBands("Converted to"));
        this.formatByKey.put("DarkReferenceValidTime", new FormatSeconds("Dark reference valid"));
        this.formatByKey.put("WhiteReferenceValidTime", new FormatSeconds("White reference valid"));
        this.formatByKey.put("SystemTime", new FormatSystemTime("System Time"));
        this.formatByKey.put("WhiteOrigFile", new FormatText("Original file", ""));
        this.formatByKey.put("WhiteDate", new FormatTime("Date"));
        this.formatByKey.put("WhiteIntegrationTime", new FormatText("Integration time", "\u00b5s"));
        this.formatByKey.put("WhiteTemperature", new FormatDegree("Temperature"));
        this.formatByKey.put("DarkOrigFile", new FormatText("Original file", ""));
        this.formatByKey.put("DarkDate", new FormatTime("Date"));
        this.formatByKey.put("DarkIntegrationTime", new FormatText("Integration time", "\u00b5s"));
        this.formatByKey.put("DarkTemperature", new FormatDegree("Temperature"));
        this.formatByKey.put("ProjectId", new FormatNone("Project Id"));
        for (InformationGroups.InformationGroup informationGroup : InformationGroups.InformationGroup.values()) {
            this.formatByKey.put("_Group#" + informationGroup.name(), new FormatGroup(informationGroup));
        }
    }

    public FormatText get(String string) {
        FormatText formatText = this.formatByKey.get(string);
        if (formatText != null) {
            return formatText;
        }
        return new FormatUnknown(StringHelper.formatLabel(string));
    }

    public static class FormatText {
        private String name;
        private String unit;

        public FormatText() {
            this(null, null);
        }

        public FormatText(String string) {
            this(null, string);
        }

        public FormatText(String string, String string2) {
            this.name = string;
            this.unit = string2;
        }

        public String format(String string) {
            String string2;
            if (NiceDataFormat.isNumber((String)string) && !NiceDataFormat.isNumberScientific((String)string)) {
                string = NiceDataFormat.toString((double)NiceDataFormat.toNumber((String)string), (int)12, (boolean)false);
            }
            if (StringUtils.isNotEmpty((CharSequence)(string2 = this.getUnit()))) {
                return string + " " + string2;
            }
            return string;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getUnit() {
            return this.unit;
        }

        @Generated
        public void setName(String string) {
            this.name = string;
        }

        @Generated
        public void setUnit(String string) {
            this.unit = string;
        }
    }

    public static class CreatedByText
    extends FormatText {
        private final InformationEntry ie;

        public CreatedByText(InformationEntry informationEntry, String string) {
            super(string, "");
            this.ie = informationEntry;
        }

        @Override
        public String format(String string) {
            Object object = this.ie.entry;
            if (object instanceof Measurement) {
                Measurement measurement = (Measurement)object;
                object = measurement.getEntryData().getCreatedBy();
                BreezeUser breezeUser = BreezeUserManager.getInstance().findUser((String)object);
                if (breezeUser != null) {
                    return breezeUser.toString();
                }
                return object;
            }
            return StringHelper.formatLabel(string);
        }
    }

    public static class FormatUnit
    extends FormatText {
        private final InformationEntry ie;
        private final String unitFormat;

        public FormatUnit(InformationEntry informationEntry, String string) {
            this(informationEntry, null, string);
        }

        public FormatUnit(InformationEntry informationEntry, String string, String string2) {
            super(string, HardwareRegistry.getInstance().getSampleMoverUnit());
            this.ie = informationEntry;
            this.unitFormat = string2;
        }

        @Override
        public String getUnit() {
            Object object = this.ie.entry;
            if (object instanceof Measurement) {
                Measurement measurement = (Measurement)object;
                return String.format(this.unitFormat, measurement.getSampleMoverType().getUnit());
            }
            return super.getUnit();
        }
    }

    public static class FormatDegree
    extends FormatText {
        public FormatDegree(String string) {
            super(string, "\u00b0C");
        }

        @Override
        public String format(String string) {
            double d;
            if (NiceDataFormat.isNumber((String)string) && !NiceDataFormat.isNumberScientific((String)string) && (d = NiceDataFormat.toNumber((String)string)) < -10.0) {
                return NiceDataFormat.toString((double)FormatDegree.celsiusToKelvin(d)) + " K";
            }
            return super.format(string);
        }

        public static double celsiusToKelvin(double d) {
            return d + 273.15;
        }
    }

    public static class FormatTime
    extends FormatText {
        private final SimpleDateFormat inFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        private final SimpleDateFormat viewformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public FormatTime(String string) {
            super(string, "");
        }

        @Override
        public String format(String string) {
            if (string.matches("\\d{14}")) {
                try {
                    return this.viewformat.format(this.inFormat.parse(string));
                }
                catch (ParseException parseException) {
                    Logg.debug((String)("Cannot parse date: " + string), (Object[])new Object[0]);
                }
            }
            return string;
        }
    }

    public static class FormatSpectralBands
    extends FormatText {
        private final InformationEntry ie;

        public FormatSpectralBands(InformationEntry informationEntry, String string, String string2) {
            super(string, string2);
            this.ie = informationEntry;
        }

        @Override
        public String format(String string) {
            String string2 = super.format(string);
            Object object = this.ie.entry;
            if (object instanceof Measurement) {
                Measurement measurement = (Measurement)object;
                if ((object = measurement.rawFile()) != null) {
                    RawHeader rawHeader = object.header();
                    return string2 + " (" + rawHeader.bandNames().getFormatedRange() + ")";
                }
            } else {
                Camera camera;
                object = this.ie.entry;
                if (object instanceof Camera && (camera = (Camera)object).isConnected()) {
                    return string2 + " (" + camera.getBandNames().getFormatedRange() + ")";
                }
            }
            return string2;
        }
    }

    public static class FormatTextLabel
    extends FormatText {
        public FormatTextLabel(String string) {
            super(string, "");
        }

        @Override
        public String format(String string) {
            return StringHelper.formatLabel(string);
        }
    }

    public static class FormatBands
    extends FormatText {
        private final InformationEntry ie;

        public FormatBands(InformationEntry informationEntry, String string) {
            super(string, "");
            this.ie = informationEntry;
        }

        @Override
        public String format(String string) {
            String[] stringArray = string.split(";");
            if (stringArray.length == 3) {
                Object object = this.ie.entry;
                if (object instanceof Measurement) {
                    Measurement measurement = (Measurement)object;
                    if ((object = measurement.rawFile()) != null) {
                        RawHeader rawHeader = object.header();
                        return FormatBands.format(stringArray, rawHeader.bandNames());
                    }
                } else {
                    Camera camera;
                    object = this.ie.entry;
                    if (object instanceof Camera && (camera = (Camera)object).isConnected()) {
                        return FormatBands.format(stringArray, camera.getBandNames());
                    }
                }
                return stringArray[0] + ", " + stringArray[1] + ", " + stringArray[2];
            }
            return StringHelper.formatLabel(string);
        }

        private static String format(String[] stringArray, BandNames bandNames) {
            String string = bandNames.isNm() ? " nm" : "";
            return "R = " + bandNames.getFormated(RtDataFormat.toNumberInt(stringArray[0])) + string + ", G = " + bandNames.getFormated(RtDataFormat.toNumberInt(stringArray[1])) + string + ", B = " + bandNames.getFormated(RtDataFormat.toNumberInt(stringArray[2])) + string;
        }
    }

    public static class FormatMinMaxBands
    extends FormatText {
        public FormatMinMaxBands(String string) {
            super(string, "");
        }

        @Override
        public String format(String string) {
            String[] stringArray = string.split(";");
            if (stringArray.length == 6) {
                return stringArray[0] + "-" + stringArray[1] + ", " + stringArray[2] + "-" + stringArray[3] + ", " + stringArray[4] + "-" + stringArray[5];
            }
            return StringHelper.formatLabel(string);
        }
    }

    private static class FormatSeconds
    extends FormatText {
        public FormatSeconds(String string) {
            super(string, "");
        }

        @Override
        public String format(String string) {
            int n = RtDataFormat.toNumberInt(string);
            if (Double.isNaN(n)) {
                return "N/A";
            }
            return new Time.Seconds((double)n).toCompactNiceString();
        }
    }

    private static class FormatSystemTime
    extends FormatText {
        private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public FormatSystemTime(String string) {
            super(string, "");
        }

        @Override
        public String format(String string) {
            try {
                BufferedTcpStream.NanoTime nanoTime = new BufferedTcpStream.NanoTime(Long.parseLong(string));
                return this.sdf.format(nanoTime.toTimestamp());
            }
            catch (NumberFormatException numberFormatException) {
                return "N/A";
            }
        }
    }

    public static class FormatNone
    extends FormatText {
        public FormatNone(String string) {
            super(string, null);
        }

        @Override
        public String format(String string) {
            return string;
        }
    }

    public static class FormatGroup
    extends FormatText {
        public FormatGroup(InformationGroups.InformationGroup informationGroup) {
            super(informationGroup.toString(), "");
        }
    }

    public static class FormatUnknown
    extends FormatText {
        public FormatUnknown(String string) {
            super(string, null);
        }

        @Override
        public String format(String string) {
            return RtDataFormat.isNumber(string) ? NiceDataFormat.toString((double)NiceDataFormat.toNumber((String)string)) : string;
        }
    }
}

