/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.information;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.information.InformationEntry;
import se.prediktera.breeze.frontend.common.swing.information.InformationFormat;
import se.prediktera.breeze.frontend.common.swing.information.InformationGroups;

public class InformationPanel
extends JPanel {
    private final InformationEntry informationEntry;
    private final BreezeList informationList = new BreezeList();
    private BreezeLabel informationLabel;
    private InformationList list;

    public InformationPanel() {
        this("Information", true);
    }

    public static JPanel createWarningsPanel(String string) {
        if (!string.isEmpty()) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new BreezeLabel("Warnings"), GridBagHelper.createWithWeigthX1(0, new Insets(0, 0, 0, 0)));
            int n = 1;
            for (String string2 : string.split(";")) {
                String[] stringArray = string2.split("=");
                jPanel.add((Component)new BreezeInfoPanel(BreezeInfoPanel.InfoType.Warning, stringArray[1], stringArray[0]), GridBagHelper.createWithWeigthX1(n++, new Insets(2, 0, 2, 0)));
            }
            return jPanel;
        }
        return null;
    }

    public InformationPanel(String string, boolean bl) {
        GridBagConstraints gridBagConstraints;
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.setLayout(new GridBagLayout());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        if (string != null) {
            this.informationLabel = new BreezeLabel(string);
            this.informationLabel.setForeground(breezeTheme.getLabelForegroundDifuse());
            this.informationLabel.setFontSize(BreezeLabel.FontSize.H2);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 16;
            this.add((Component)this.informationLabel, gridBagConstraints);
        }
        this.informationList.setForeground(new Color(0, 0, 0));
        this.informationList.setEnabled(false);
        this.informationList.setVisibleRowCount(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)((Object)this.informationList), gridBagConstraints);
        this.informationEntry = new InformationEntry(bl);
        this.informationList.setCellRenderer(this.informationEntry);
        this.informationList.setForeground(breezeTheme.getLabelForeground());
    }

    public void setInformation(InformationList informationList) {
        this.list = informationList;
        this.informationList.setModel(informationList.model());
        this.informationEntry.setEntry(informationList.getEntry());
    }

    public void setInformationShowIfHasItems(InformationList informationList) {
        this.list = informationList;
        ArrayListModel arrayListModel = informationList.model();
        this.informationList.setModel(arrayListModel);
        this.informationEntry.setEntry(informationList.getEntry());
        this.setVisible(arrayListModel.getSize() > 0);
    }

    public InformationList getList() {
        return this.list;
    }

    public InformationEntry getInformationEntry() {
        return this.informationEntry;
    }

    public BreezeLabel getInformationLabel() {
        return this.informationLabel;
    }

    public void addValues(StringBuilder stringBuilder) {
        InformationFormat informationFormat = this.informationEntry.getInformationFormat();
        for (Map.Entry<String, String> entry : this.list.getList()) {
            String string;
            InformationFormat.FormatText formatText;
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append("\n");
            }
            if ((formatText = informationFormat.get(string = entry.getKey().toString())).getName() != null) {
                string = formatText.getName();
            }
            stringBuilder.append(string);
            stringBuilder.append("\t");
            stringBuilder.append(formatText.format(entry.getValue().toString()));
        }
    }

    public static class InformationList
    extends HashMap<String, String> {
        private final Object entry;
        private final List<String> orderedKeys = new ArrayList<String>();

        public InformationList() {
            this((Object)null);
        }

        public InformationList(Object object) {
            this.entry = object;
        }

        public ArrayListModel model() {
            return new ArrayListModel(this.getList());
        }

        public void add(String string, String string2) {
            this.put(string, string2);
            this.orderedKeys.add(string);
        }

        public void add(String string, Object object) {
            this.add(string, object.toString());
        }

        public void add(String string, double d) {
            this.add(string, RtDataFormat.toString(d));
        }

        public ArrayList<Map.Entry<String, String>> getList() {
            ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>();
            for (String string : this.orderedKeys) {
                arrayList.add(new AbstractMap.SimpleEntry<String, String>(string, (String)this.get(string)));
            }
            return arrayList;
        }

        public Object getEntry() {
            return this.entry;
        }

        public List<String> getOrderedKeys() {
            return this.orderedKeys;
        }

        public void sortKeys() {
            final InformationGroups informationGroups = InformationGroups.getInstance();
            this.orderedKeys.sort(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    InformationGroups.InformationGroup informationGroup;
                    InformationGroups.InformationGroup informationGroup2 = informationGroups.get(string);
                    if (informationGroup2 != (informationGroup = informationGroups.get(string2))) {
                        return Integer.compare(informationGroup2.ordinal(), informationGroup.ordinal());
                    }
                    return string.compareToIgnoreCase(string2);
                }
            });
        }
    }
}

