/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.notification;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResult;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class NotificationEntry
extends JPanel
implements ListCellRenderer {
    private final ImageIcon warningIcon;
    private final ImageIcon applychangesIcon;
    private final JLabel iconLabel = new JLabel();
    private final JPanel innerPanel = new JPanel();
    private final BreezeLabel nameLabel = new BreezeLabel("Name", false, 14);
    private final BreezeLabel separatorLabel = new BreezeLabel("=", false, 14);
    private final BreezeLabel valueLabel = new BreezeLabel("Value", false, 14);
    private final ImageIcon errorIcon;

    public NotificationEntry() {
        this.setLayout(new GridBagLayout());
        this.innerPanel.setBackground(new Color(255, 255, 255));
        this.innerPanel.setLayout(new GridBagLayout());
        this.iconLabel.setMinimumSize(new Dimension(36, 17));
        this.iconLabel.setPreferredSize(new Dimension(36, 17));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.innerPanel.add((Component)this.iconLabel, gridBagConstraints);
        this.nameLabel.setMinimumSize(new Dimension(150, 17));
        this.nameLabel.setPreferredSize(new Dimension(150, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.innerPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.separatorLabel.setMinimumSize(new Dimension(60, 17));
        this.separatorLabel.setPreferredSize(new Dimension(50, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.innerPanel.add((Component)this.separatorLabel, gridBagConstraints);
        this.valueLabel.setMinimumSize(new Dimension(150, 17));
        this.valueLabel.setPreferredSize(new Dimension(150, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.innerPanel.add((Component)this.valueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.innerPanel, gridBagConstraints);
        this.warningIcon = ImageHelper.getResourceIcon("warningSmall");
        this.errorIcon = ImageHelper.getResourceIcon("error");
        this.applychangesIcon = ImageHelper.getResourceIcon("applychanges");
        this.setPreferredSize(new Dimension(0, 40));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof EvaluateResult) {
            EvaluateResult evaluateResult = (EvaluateResult)object;
            this.nameLabel.setText(evaluateResult.getMessageId());
            boolean bl3 = evaluateResult.hasFail();
            if (bl3) {
                if (evaluateResult.getMessageId().startsWith("E")) {
                    this.iconLabel.setIcon(this.errorIcon);
                } else if ("WM0101".equals(evaluateResult.getMessageId())) {
                    this.iconLabel.setIcon(this.applychangesIcon);
                } else {
                    this.iconLabel.setIcon(this.warningIcon);
                }
            } else {
                this.iconLabel.setIcon(null);
            }
            this.valueLabel.setText(evaluateResult.getMessageDescription());
        } else {
            this.iconLabel.setIcon(null);
            this.nameLabel.setText("Message");
            this.valueLabel.setText(object.toString());
        }
        if (bl) {
            this.innerPanel.setBackground(jList.getSelectionBackground());
            this.nameLabel.setForeground(jList.getSelectionForeground());
            this.separatorLabel.setForeground(jList.getSelectionForeground());
            this.valueLabel.setForeground(jList.getSelectionForeground());
        } else {
            this.innerPanel.setBackground(jList.getBackground());
            this.nameLabel.setForeground(jList.getForeground());
            this.separatorLabel.setForeground(jList.getForeground());
            this.valueLabel.setForeground(jList.getForeground());
        }
        this.setBackground(jList.getBackground());
        return this;
    }
}

