/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.notification;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import se.prediktera.breeze.backend.tree.groupandmeasurementtree.GroupAndMeasurementDefaultFunctionTreeListMap;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractFunctionTree;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResult;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResultHolder;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryPanel;
import se.prediktera.breeze.frontend.common.graphcollection.FunctionTreePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.notification.NotificationEntry;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.map.common.error.Logg;

public class NotificationPanel
extends AbstractViewPanel {
    private final FunctionTreePanel graphPanel;
    private Object entrydata;
    private final BreezeList notificationdataList = new BreezeList();
    private final BreezeCheckBox notificationOnMeasurementCheckBox;

    public NotificationPanel(EntryMainPanel entryMainPanel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add(new BreezeLabel.BreezeLabelHeader("Notifications"), gridBagConstraints);
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane();
        breezeScrollPane.setBorder(null);
        this.notificationdataList.setVisibleRowCount(0);
        this.notificationdataList.addListSelectionListener(this::notificationdataListValueChanged);
        breezeScrollPane.setViewportView((Component)((Object)this.notificationdataList));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(breezeScrollPane, gridBagConstraints);
        this.notificationdataList.setCellRenderer(new NotificationEntry());
        this.graphPanel = new FunctionTreePanel(true, false);
        this.graphPanel.setMinimumSize(new Dimension(900, 0));
        this.graphPanel.setPreferredSize(new Dimension(900, 0));
        this.setRightSettingsPanel(this.graphPanel);
        this.notificationdataList.setForeground(BreezeTheme.getInstance().getLabelForeground());
        this.notificationdataList.setSelectionForeground(BreezeTheme.getInstance().getLabelForeground());
        this.notificationdataList.setSelectionBackground(BreezeTheme.getInstance().getSelectionBackground());
        this.notificationOnMeasurementCheckBox = new BreezeCheckBox("Show notification on measurements", true, bl -> {
            EntryPanel.measurementNotifications = bl;
            BreezeProperties.getInstance().setShowNotificationOnMeasurements(EntryPanel.measurementNotifications);
            entryMainPanel.repaintEntryList();
        });
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        breezeMainPanel.addRightButton(this.notificationOnMeasurementCheckBox);
    }

    @Override
    public String getType() {
        return "Notifications";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        Object[][] objectArrayArray;
        this.entrydata = object;
        Measurement measurement = Measurement.getMeasurement(object);
        ArrayList<EvaluateResult> arrayList = new ArrayList<EvaluateResult>();
        if (measurement != null && measurement.hasData()) {
            for (Object[] objectArray : objectArrayArray = new Object[][]{{"measurement", "Warning", measurement}, {"sample", "workflow", measurement.getRootSample()}}) {
                AbstractFunctionTree abstractFunctionTree = GroupAndMeasurementDefaultFunctionTreeListMap.getInstance().getFunctionTree(objectArray[0].toString(), objectArray[1].toString());
                DescriptorInterface descriptorInterface = (DescriptorInterface)objectArray[2];
                if (abstractFunctionTree == null || !descriptorInterface.getDescriptorHolder().hasResultForAllDescriptors((EvaluationTree)abstractFunctionTree)) continue;
                EvaluateResultHolder evaluateResultHolder = abstractFunctionTree.evaluateAll(descriptorInterface);
                evaluateResultHolder.addFailedWithMessage(arrayList);
            }
            SpectralReference.addWarnings(measurement.whiteReference(), arrayList);
            if (measurement.applyChangesNeeded()) {
                arrayList.add(new EvaluateResult("WM0101"));
            }
        }
        this.notificationdataList.clearSelection();
        if (arrayList.size() > 0) {
            this.notificationdataList.setModel(new ArrayListModel(arrayList));
            this.notificationdataList.setSelectedIndex(0);
        } else {
            objectArrayArray = new ArrayList();
            objectArrayArray.add("No notifications");
            this.notificationdataList.setModel(new ArrayListModel((List)objectArrayArray));
        }
        this.notificationOnMeasurementCheckBox.setSelected(BreezeProperties.getInstance().isShowNotificationOnMeasurements());
    }

    private void notificationdataListValueChanged(ListSelectionEvent listSelectionEvent) {
        EvaluationTree evaluationTree;
        EvaluateResult evaluateResult;
        Object object = this.notificationdataList.getSelectedValue();
        this.graphPanel.clear();
        if (object instanceof EvaluateResult && (evaluateResult = (EvaluateResult)object) != null && evaluateResult.getHolder() != null && (evaluationTree = evaluateResult.getHolder().getTree()) != null) {
            this.graphPanel.setEntry((DescriptorInterface)this.entrydata);
            this.graphPanel.addFunctionGraph(evaluationTree);
            try {
                this.graphPanel.updateGraph();
            }
            catch (Exception exception) {
                Logg.error((String)"Error updating graph", (Throwable)exception);
            }
        }
    }
}

