/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;

public class BreezeHeaderListener
extends MouseAdapter
implements MouseMotionListener,
KeyListener {
    private final BreezeTable table;
    private final JList rowHeader;
    private boolean keydown = false;
    private final ListSelectionModel selection;
    private final ListSelectionModel oppositeselection;
    private final boolean isrow;
    private TableModel headerModel = null;

    public BreezeHeaderListener(BreezeTable breezeTable, JList jList, boolean bl, ListSelectionModel listSelectionModel, ListSelectionModel listSelectionModel2) {
        this.table = breezeTable;
        this.rowHeader = jList;
        this.selection = listSelectionModel;
        this.oppositeselection = listSelectionModel2;
        this.isrow = bl;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.table.processEvent(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.keydown) {
            int n = this.getIndexFromPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            this.keydown = true;
            this.selectInterval(n, true, false);
            Rectangle rectangle = this.table.getCellRect(this.isrow ? n : 0, this.isrow ? 0 : n, true);
            this.table.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getIndexFromPoint(mouseEvent.getPoint());
        if (n == -1) {
            return;
        }
        this.keydown = true;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) || !this.selection.isSelectedIndex(n)) {
            this.selectInterval(n, mouseEvent.isShiftDown(), mouseEvent.isControlDown());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.keydown = false;
        }
    }

    public int selectInterval(int n, boolean bl, boolean bl2) {
        int n2;
        int n3;
        if (this.headerModel == null) {
            n3 = this.table.getColumnCount();
            n2 = this.table.getRowCount();
            if (!this.isrow) {
                n3 = this.table.getRowCount();
                n2 = this.table.getColumnCount();
            }
        } else {
            n3 = this.headerModel.getColumnCount();
            n2 = this.headerModel.getRowCount();
            if (!this.isrow) {
                n3 = this.headerModel.getRowCount();
                n2 = this.headerModel.getColumnCount();
            }
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= n2) {
            n = n2 - 1;
        }
        if (n3 != 0) {
            this.oppositeselection.setSelectionInterval(0, n3 - 1);
        }
        if (bl) {
            int n4 = this.selection.getAnchorSelectionIndex();
            int n5 = this.selection.getLeadSelectionIndex();
            if (n4 == -1) {
                this.selection.setSelectionInterval(n, n);
            } else {
                boolean bl3 = this.selection.getValueIsAdjusting();
                this.selection.setValueIsAdjusting(true);
                boolean bl4 = this.selection.isSelectedIndex(n4);
                if (n5 != -1) {
                    if (bl4) {
                        this.selection.removeSelectionInterval(n4, n5);
                    } else {
                        this.selection.addSelectionInterval(n4, n5);
                    }
                }
                if (bl4) {
                    this.selection.addSelectionInterval(n4, n);
                } else {
                    this.selection.removeSelectionInterval(n4, n);
                }
                this.selection.setValueIsAdjusting(bl3);
            }
        } else if (bl2) {
            if (this.selection.isSelectedIndex(n)) {
                this.selection.removeSelectionInterval(n, n);
            } else {
                this.selection.addSelectionInterval(n, n);
            }
        } else {
            this.selection.setSelectionInterval(n, n);
        }
        return n;
    }

    public void setHeaderModel(TableModel tableModel) {
        this.headerModel = tableModel;
    }

    private int getIndexFromPoint(Point point) {
        if (this.isrow) {
            if (!this.table.getRowSelectionAllowed()) {
                return -1;
            }
            return this.rowHeader.locationToIndex(point);
        }
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        if (!tableColumnModel.getColumnSelectionAllowed()) {
            return -1;
        }
        return jTableHeader.columnAtPoint(point);
    }
}

