/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.map.common.error.Logg;

public class BreezeHtmlPanel
extends AbstractBreezeCustomPanel {
    public BreezeHtmlPanel(String string) {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setBorder(BorderFactory.createEmptyBorder());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        jEditorPane.setBackground(breezeTheme.getDialogBackground());
        jEditorPane.setForeground(breezeTheme.getLabelForeground());
        jEditorPane.setCaretColor(this.getBackground());
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        jEditorPane.setEditorKit(hTMLEditorKit);
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        String string2 = RtPerfectSpread.getColorToString(breezeTheme.getLabelForeground());
        styleSheet.addRule("body {color:" + string2 + "; font-family: Arial; margin: 4px; font-size: 12px }");
        jEditorPane.setDocument(hTMLEditorKit.createDefaultDocument());
        jEditorPane.setText(string);
        jEditorPane.addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                }
                catch (IOException | URISyntaxException exception) {
                    Logg.warn((String)"Failed to open link", (Object[])new Object[]{exception});
                }
            }
        });
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane(jEditorPane);
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        breezeScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)breezeScrollPane, GridBagHelper.create(0, this.getComponentCount(), 1.0, 1.0, 1, new Insets(12, 12, 0, 12)));
        this.setPreferredSize(new Dimension(800, 600));
    }

    @Override
    public Object getResult() {
        return null;
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }
}

