/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListSelectionListener;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.datasource.AbstractBreezeDataSource;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.evince.datasource.SampleDataRow;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.dataimport.AbstractDataSource;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.datasetcontainer.DataTreeManager;
import se.prediktera.map.datasetcontainer.event.DataTreeEvent;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public abstract class BreezeInteractionTable
extends BreezeInnerTable {
    private AbstractBreezeDataSource dataSource;
    private final int interaction_tag;
    private boolean byVisible = false;
    private boolean scrollToVisible = true;

    public BreezeInteractionTable(DataInit dataInit, int n) {
        super(dataInit, true, true);
        this.interaction_tag = n;
        this.innerTable.getTable().getSelectionModel().setSelectionMode(2);
        this.innerTable.setInteractionTable(this);
        this.innerTable.addMouseListener((MouseListener)((Object)this));
        this.setInteractionFlag((byte)1);
    }

    @Override
    public boolean doInteraction(InteractionInterface interactionInterface) {
        if (this.project_GUI != null) {
            this.doInteractionLocal(this.getInteractionArray());
        }
        return true;
    }

    public String getGUI_Name() {
        return "BreezeInteractionTable";
    }

    public InteractionArray getInteractionArray() {
        if (this.project_GUI != null) {
            return this.project_GUI.getInteractionArray(this.interaction_tag, 0);
        }
        return null;
    }

    public int getInteractiveTag() {
        return this.interaction_tag;
    }

    public boolean hasInteractivity() {
        return true;
    }

    @Override
    public void nodeReplaced(DataTreeEvent dataTreeEvent) {
        this.reloadDataSource(dataTreeEvent.getReplaceDataTreeInterface());
        this.doInteraction(null);
    }

    @Override
    public void prepareInteraction() {
        int[] nArray;
        BreezeTable breezeTable = this.innerTable.getTable();
        BreezeTableModel breezeTableModel = (BreezeTableModel)((Object)breezeTable.getModel());
        AbstractBreezeDataSource abstractBreezeDataSource = this.dataSource;
        if (breezeTableModel.isSorting() || abstractBreezeDataSource == null) {
            return;
        }
        InteractionArray interactionArray = this.project_GUI.getInteractionArray((DataTreeInterface)abstractBreezeDataSource.getCase(), this.interaction_tag, abstractBreezeDataSource.getRowCount(), 0);
        for (int n : nArray = breezeTable.getSelectedRows()) {
            Sample sample = (Sample)breezeTableModel.getObjectAt(n);
            if (sample == null) continue;
            interactionArray.set(sample.getCachedInteractionTableIndex());
        }
    }

    public void reloadDataSource(DataTreeInterface dataTreeInterface) {
        this.dataSource = null;
        this.setData(dataTreeInterface, false);
    }

    public void setCreated(AbstractWindow_GUI abstractWindow_GUI, boolean bl) {
        super.setCreated(abstractWindow_GUI, bl);
        this.setData(this.dti, true);
    }

    @Override
    protected abstract BreezeTablePanelInterface createTableModel();

    public void setByVisible(boolean bl) {
        this.byVisible = bl;
    }

    public boolean isByVisible() {
        return this.byVisible;
    }

    protected void doInteractionLocal(InteractionArray interactionArray) {
        if (this.dataSource != null) {
            boolean bl;
            ListSelectionListener[] listSelectionListenerArray;
            ArrayList<Sample> arrayList = new ArrayList<Sample>();
            if (this.byVisible && interactionArray != null && interactionArray.getLastSet() >= 0) {
                int n = interactionArray.getLastSet();
                for (int i = interactionArray.getFirstSet(); i <= n; ++i) {
                    if (!interactionArray.get(i)) continue;
                    Sample object2 = this.dataSource.getEntryAt(i);
                    arrayList.add(object2);
                }
            } else {
                List<SampleDataRow> list = this.dataSource.getIncludedDataList();
                for (SampleDataRow sampleDataRow : list) {
                    arrayList.add(sampleDataRow.getEntry());
                }
            }
            BreezeTable breezeTable = this.innerTable.getTable();
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)breezeTable.getSelectionModel();
            for (ListSelectionListener listSelectionListener : listSelectionListenerArray = defaultListSelectionModel.getListSelectionListeners()) {
                defaultListSelectionModel.removeListSelectionListener(listSelectionListener);
            }
            this.innerTable.setTableList(arrayList, null);
            boolean bl2 = bl = !this.byVisible;
            if (bl && interactionArray != null) {
                int n = interactionArray.getLastSet();
                BreezeTableModel breezeTableModel = (BreezeTableModel)((Object)breezeTable.getModel());
                defaultListSelectionModel.clearSelection();
                boolean bl3 = true;
                for (int i = interactionArray.getFirstSet(); i <= n; ++i) {
                    if (!interactionArray.get(i)) continue;
                    for (int j = 0; j < breezeTableModel.getRowCount(); ++j) {
                        Sample sample;
                        Object object = breezeTableModel.getObjectAt(j);
                        if (!(object instanceof Sample) || (sample = (Sample)object) == null || i != sample.getCachedInteractionTableIndex()) continue;
                        if (bl3) {
                            defaultListSelectionModel.setSelectionInterval(j, j);
                            bl3 = false;
                            if (!this.scrollToVisible) continue;
                            breezeTable.scrollRectToVisible(breezeTable.getCellRect(j, this.innerTable.getThumbnailColumn(), true));
                            continue;
                        }
                        defaultListSelectionModel.addSelectionInterval(j, j);
                    }
                }
            }
            for (ListSelectionListener listSelectionListener : listSelectionListenerArray) {
                defaultListSelectionModel.addListSelectionListener(listSelectionListener);
            }
        }
        this.innerTable.getTablePanel().tableUpdated(this.innerTable.getTable());
    }

    public void setScrollToVisible(boolean bl) {
        this.scrollToVisible = bl;
    }

    protected String getDefaultTitle() {
        return null;
    }

    public AbstractBreezeDataSource getDataSource() {
        return this.dataSource;
    }

    public Workflow getRoot() {
        if (this.dataSource != null) {
            return this.dataSource.getRoot();
        }
        return null;
    }

    private void setData(DataTreeInterface dataTreeInterface, boolean bl) {
        if (this.dataSource == null || this.dataSource.isCleaned()) {
            Case case_ = (Case)DataTreeManager.getAncestorNull((DataTreeInterface)dataTreeInterface, Case.class);
            AbstractDataSource abstractDataSource = null;
            if (case_ != null) {
                abstractDataSource = case_.getDataSource();
            }
            if (dataTreeInterface instanceof AbstractDataSource) {
                abstractDataSource = (AbstractDataSource)dataTreeInterface;
            }
            if (abstractDataSource instanceof AbstractBreezeDataSource) {
                this.dataSource = (AbstractBreezeDataSource)abstractDataSource;
                DataInit dataInit = this.getDataInit();
                if (dataInit != null) {
                    dataInit.setDataTreeInterface(dataTreeInterface);
                    if (bl) {
                        this.doInteraction(null);
                    }
                }
            }
        }
    }

    public Sample getSelectedSample() {
        Case case_;
        int n;
        InteractionArray interactionArray = this.getInteractionArray();
        if (interactionArray != null && (n = interactionArray.getFirstSet()) >= 0 && (case_ = (Case)DataTreeManager.getAncestorNull((DataTreeInterface)this.getDataInit().filterRoot, Case.class)) != null) {
            MeasurementDataSource measurementDataSource = (MeasurementDataSource)case_.getDataSource();
            return measurementDataSource.getSampleAt(n);
        }
        return null;
    }

    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.innerTable != null) {
            this.innerTable.cleanUp();
        }
    }
}

