/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;

public class BreezeIntervalTableListener
extends MouseAdapter {
    private static final int LIMIT = 3;
    private final BreezeTablePanel intervalTable;
    private final BreezeTable table;
    private Point lastPoint = null;
    private boolean legalDrag = false;
    private boolean selectionChange = false;
    private final int[] intervalColumn;
    private final CallBack callBack;

    public BreezeIntervalTableListener(BreezeTablePanel breezeTablePanel, int[] nArray, CallBack callBack) {
        this.intervalTable = breezeTablePanel;
        this.intervalColumn = nArray;
        this.callBack = callBack;
        this.table = breezeTablePanel.getTable();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
            Point point = mouseEvent.getPoint();
            int n = this.table.rowAtPoint(point);
            int n2 = this.table.columnAtPoint(point);
            if (this.supportColumn(n2)) {
                BreezeIntervalClass breezeIntervalClass;
                breezeIntervalClass.setIncluded(!(breezeIntervalClass = (BreezeIntervalClass)this.table.getValueAt(n, n2)).isIncluded());
                this.intervalTable.repaint();
                this.callBack.intervalChanged();
                mouseEvent.consume();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.legalDrag && SwingUtilities.isLeftMouseButton(mouseEvent) && this.lastPoint != null && mouseEvent.getPoint() != null) {
            int n = this.table.rowAtPoint(this.lastPoint);
            int n2 = this.table.rowAtPoint(mouseEvent.getPoint());
            int n3 = this.table.columnAtPoint(mouseEvent.getPoint());
            if (n >= 0 || n2 >= 0) {
                if (n < 0) {
                    n = this.lastPoint.getY() < (double)mouseEvent.getY() ? 0 : this.table.getRowCount() - 1;
                }
                if (n2 < 0) {
                    n2 = this.lastPoint.getY() < (double)mouseEvent.getY() ? this.table.getRowCount() : -1;
                }
                if (n < n2) {
                    for (int i = n; i < n2; ++i) {
                        Object object = this.table.getValueAt(i, n3);
                        if (!(object instanceof BreezeIntervalClass)) continue;
                        ((BreezeIntervalClass)object).setIncluded(this.selectionChange);
                    }
                } else if (n2 < n) {
                    for (int i = n2 + 1; i <= n; ++i) {
                        Object object = this.table.getValueAt(i, n3);
                        if (!(object instanceof BreezeIntervalClass)) continue;
                        ((BreezeIntervalClass)object).setIncluded(!this.selectionChange);
                    }
                }
                this.callBack.intervalChanged();
                this.intervalTable.repaint();
                this.lastPoint.setLocation(this.lastPoint.getX(), mouseEvent.getPoint().getY());
            }
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.columnAtPoint(point);
        if (n < 0 || n2 < 0) {
            return;
        }
        if (!this.supportColumn(n2)) {
            this.intervalTable.setCursor(Cursor.getDefaultCursor());
            return;
        }
        boolean bl = ((BreezeIntervalClass)this.table.getValueAt(n, n2)).isIncluded();
        boolean bl2 = false;
        bl2 = n <= 0 ? !bl : ((BreezeIntervalClass)this.table.getValueAt(n - 1, n2)).isIncluded();
        boolean bl3 = false;
        bl3 = n >= this.table.getRowCount() - 1 ? !bl : ((BreezeIntervalClass)this.table.getValueAt(n + 1, n2)).isIncluded();
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        if (bl != bl2 && Math.abs(rectangle.getY() - point.getY()) < 3.0) {
            this.intervalTable.setCursor(Cursor.getPredefinedCursor(8));
            this.selectionChange = !bl;
            this.legalDrag = true;
        } else if (bl != bl3 && Math.abs(rectangle.getY() + rectangle.getHeight() - point.getY()) < 3.0) {
            this.intervalTable.setCursor(Cursor.getPredefinedCursor(8));
            this.selectionChange = bl;
            this.legalDrag = true;
        } else {
            this.intervalTable.setCursor(Cursor.getPredefinedCursor(0));
            this.legalDrag = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.lastPoint = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.legalDrag = false;
    }

    protected boolean supportColumn(int n) {
        for (int n2 : this.intervalColumn) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public static interface CallBack {
        public void intervalChanged();
    }
}

