/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SamplePredictionList;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.client.workflow.RuntimeWorkflowObject;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.editor.CategoryCellEditor;
import se.prediktera.breeze.frontend.common.swing.table.editor.DefaultComponentCellEditor;
import se.prediktera.breeze.frontend.common.swing.table.editor.IdentifierCellEditor;
import se.prediktera.breeze.frontend.common.swing.table.editor.PropertyCellEditor;
import se.prediktera.breeze.frontend.common.swing.table.editor.SampleCellEditor;
import se.prediktera.breeze.frontend.common.swing.table.editor.ValueCellEditor;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeIntervalTableCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeSortHeaderRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.CompareCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.DescriptorCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.FactorCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.FunctionTreeNodeCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.IdentifierCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.SampleCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.ThumbnailCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.WorkflowObjectCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailProperty;
import se.prediktera.breeze.frontend.main.model.table.BreezeModelCompareTableModel;
import se.prediktera.breeze.frontend.main.play.edit.EditLimitPanel;
import se.prediktera.map.common.cleanup.CleanUpTable;

public class BreezeTable
extends CleanUpTable {
    private TableCellRenderer defaultTableHeaderRenderer = null;
    private BreezeTableCellRenderer defaultTableRenderer = null;
    private LimitConfiguration limitNode;
    private Date limitUpdated = new Date();
    private boolean rowFocusEnabled = true;
    private boolean colFocusEnabled = false;
    private boolean selectOnFocus = true;
    private BreezeTablePanel breezeTablePanel;
    private final Map<Integer, Integer> columnWidthMap = new HashMap<Integer, Integer>();

    public BreezeTable() {
        this.setTableHeader(new ToolTipHeader(this.getColumnModel()));
        this.getTableHeader().setReorderingAllowed(false);
        this.defaultTableHeaderRenderer = this.getTableHeader().getDefaultRenderer();
        this.getTableHeader().setDefaultRenderer(new BreezeSortHeaderRenderer());
        this.defaultTableRenderer = new BreezeTableCellRenderer();
        this.setDefaultRenderer(Object.class, this.defaultTableRenderer);
        this.setDefaultRenderer(Number.class, this.defaultTableRenderer);
        this.setDefaultRenderer(Date.class, this.defaultTableRenderer);
        this.setDefaultRenderer(Float.class, this.defaultTableRenderer);
        this.setDefaultRenderer(Double.class, this.defaultTableRenderer);
        this.setDefaultRenderer(Boolean.class, this.defaultTableRenderer);
        this.setDefaultRenderer(Long.class, this.defaultTableRenderer);
        this.setDefaultRenderer(Sample.class, new SampleCellRenderer());
        this.setDefaultEditor(Sample.class, new SampleCellEditor());
        this.setDefaultRenderer(Identifier.class, new IdentifierCellRenderer());
        this.setDefaultEditor(Identifier.class, new IdentifierCellEditor());
        this.setDefaultRenderer(PropertyFactor.class, new FactorCellRenderer());
        this.setDefaultEditor(PropertyFactor.class, new PropertyCellEditor());
        this.setDefaultRenderer(CategoryFactor.class, new FactorCellRenderer());
        this.setDefaultEditor(CategoryFactor.class, new CategoryCellEditor());
        this.setDefaultRenderer(FunctionResult.class, new DescriptorCellRenderer());
        this.setDefaultRenderer(RuntimeWorkflowObject.class, new WorkflowObjectCellRenderer());
        this.setDefaultRenderer(Thumbnail.class, new ThumbnailCellRenderer());
        this.setDefaultEditor(EditLimitPanel.LimitValueCell.class, new ValueCellEditor());
        this.setDefaultRenderer(BreezeIntervalClass.class, new BreezeIntervalTableCellRenderer());
        this.setDefaultRenderer(SamplePredictionList.class, new SamplePredictionList.PredictionCellRenderer());
        this.setDefaultRenderer(FunctionTreeNode.class, new FunctionTreeNodeCellRenderer());
        this.setDefaultRenderer(BreezeModelCompareTableModel.ModelCompare.class, new CompareCellRenderer());
        this.setSelectionMode(0);
        this.setRowSelectionAllowed(true);
        this.setRowFocusEnabled(true);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ListSelectionModel listSelectionModel = BreezeTable.this.getSelectionModel();
                if (BreezeTable.this.getRowCount() > 0) {
                    if (BreezeTable.this.getCellSelectionEnabled()) {
                        if (listSelectionModel.isSelectionEmpty() && BreezeTable.this.getColumnModel().getSelectionModel().isSelectionEmpty()) {
                            listSelectionModel.setSelectionInterval(0, 0);
                            BreezeTable.this.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
                        }
                    } else if (BreezeTable.this.selectOnFocus && listSelectionModel.isSelectionEmpty()) {
                        listSelectionModel.setSelectionInterval(0, 0);
                    }
                }
                BreezeTable.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BreezeTable.this.repaint();
            }
        });
    }

    public void setSelectOnFocus(boolean bl) {
        this.selectOnFocus = bl;
    }

    public void setFontSize(int n) {
        for (Object v : this.defaultRenderersByColumnClass.values()) {
            if (!(v instanceof BreezeTableCellRenderer)) continue;
            ((BreezeTableCellRenderer)v).setFontSize(n);
        }
    }

    public void disableSortColumnArrow() {
        this.getTableHeader().setDefaultRenderer(this.defaultTableHeaderRenderer);
    }

    public void setCellFocusEnabled(boolean bl) {
        this.colFocusEnabled = bl;
        this.rowFocusEnabled = bl;
    }

    public void setColumnFocusEnabled(boolean bl) {
        this.colFocusEnabled = bl;
        this.rowFocusEnabled = !bl;
    }

    public void setRowFocusEnabled(boolean bl) {
        this.rowFocusEnabled = bl;
        this.colFocusEnabled = !bl;
    }

    public boolean isRowFocusEnabled() {
        return this.rowFocusEnabled;
    }

    public boolean isColFocusEnabled() {
        return this.colFocusEnabled;
    }

    public void setVerticalCellAlignment(int n) {
        this.defaultTableRenderer.setVerticalCellAlignment(n);
    }

    public void setHorizontalAlignment(int n) {
        this.defaultTableRenderer.setHorizontalAlignment(n);
    }

    protected void cleanUpChild() {
        BreezeTableCellRenderer breezeTableCellRenderer = (BreezeTableCellRenderer)this.getDefaultRenderer(Thumbnail.class);
        if (breezeTableCellRenderer != null) {
            breezeTableCellRenderer.cleanUp();
        }
    }

    public void setLimitNode(LimitConfiguration limitConfiguration, boolean bl) {
        this.limitNode = limitConfiguration;
        if (limitConfiguration != null && (bl || limitConfiguration.hasChanged(this.limitNode, this.limitUpdated))) {
            this.limitUpdated = new Date();
            this.clearThumbnailCache(null);
        }
    }

    public void clearThumbnailCache(PropertyFactor propertyFactor) {
        TableModel tableModel = this.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            for (int j = 0; j < tableModel.getColumnCount(); ++j) {
                Object object = tableModel.getValueAt(i, j);
                if (!(object instanceof ThumbnailProperty)) continue;
                ThumbnailProperty thumbnailProperty = (ThumbnailProperty)((Object)object);
                if (propertyFactor != null && !propertyFactor.equals(thumbnailProperty.getFactor())) continue;
                thumbnailProperty.clearCache();
            }
        }
        this.repaint();
    }

    public LimitConfiguration getLimitNode() {
        return this.limitNode;
    }

    public void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    public List getSelectedValues() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof BreezeTableModel) {
            BreezeTableModel breezeTableModel = (BreezeTableModel)((Object)tableModel);
            int[] nArray = this.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                ArrayList<Object> arrayList = new ArrayList<Object>(nArray.length);
                for (int n : nArray) {
                    Object object = breezeTableModel.getObjectAt(n);
                    if (object == null) continue;
                    arrayList.add(object);
                }
                return arrayList;
            }
        }
        return new ArrayList();
    }

    public void setSelectedRows(List<Integer> list) {
        this.clearSelection();
        if (list.size() > 0) {
            for (int n : list) {
                this.addRowSelectionInterval(n, n);
            }
            this.scrollRectToVisible(this.getCellRect(list.get(list.size() - 1), 0, true));
        }
    }

    public void keepSelectionAndScroll(Runnable runnable, int n) {
        int[] nArray = this.getSelectedRows();
        runnable.run();
        this.reselectedAndScroll(n, nArray);
    }

    public void reselectedAndScroll(int n, int[] nArray) {
        if (nArray.length > 0) {
            this.getSelectionModel().setSelectionInterval(nArray[0], nArray[0]);
            for (int i = 1; i < nArray.length; ++i) {
                this.getSelectionModel().addSelectionInterval(nArray[i], nArray[i]);
            }
            this.scrollRectToVisible(this.getCellRect(nArray[nArray.length - 1], n, true));
        }
    }

    public void setTablePanel(BreezeTablePanel breezeTablePanel) {
        this.breezeTablePanel = breezeTablePanel;
    }

    public BreezeTablePanel getTablePanel() {
        return this.breezeTablePanel;
    }

    public void setColumnVisible(int n, boolean bl) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n);
        if (bl) {
            Integer n2 = this.columnWidthMap.remove(n);
            if (n2 instanceof Integer) {
                Integer n3 = n2;
                tableColumn.setMinWidth(n3);
                tableColumn.setMaxWidth(Integer.MAX_VALUE);
                tableColumn.setPreferredWidth(n3);
            }
        } else {
            this.columnWidthMap.putIfAbsent(n, tableColumn.getWidth());
            tableColumn.setMinWidth(0);
            tableColumn.setMaxWidth(0);
            tableColumn.setPreferredWidth(0);
        }
        tableColumn.setResizable(bl);
    }

    public int getColumnIndexByName(String string) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (!tableColumnModel.getColumn(i).getHeaderValue().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static class ToolTipHeader
    extends JTableHeader {
        public ToolTipHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.getTable().convertColumnIndexToModel(n);
            return this.getTable().getColumnName(n2);
        }
    }

    public static class BreezeTextCellEditor
    extends DefaultComponentCellEditor {
        private final BreezeTextField textField = new BreezeTextField();
        private int row;

        public BreezeTextCellEditor(BreezeTextCellListener breezeTextCellListener) {
            this.textField.addChangeListener(textActionEvent -> {
                breezeTextCellListener.setValue(this.row, textActionEvent.getText());
                this.stopCellEditing();
            });
        }

        @Override
        public final Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            jTable.getSelectionModel().setSelectionInterval(n, n);
            this.textField.setText(object.toString());
            this.row = n;
            return super.getTableCellEditorComponent(jTable, this.textField, bl, n, n2);
        }

        public static interface BreezeTextCellListener {
            public void setValue(int var1, String var2);
        }
    }

    public static class TableColumnModelAdapter
    implements TableColumnModelListener {
        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }
}

