/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.report.ReportUtils;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.Main_GUI;

public class BreezeTableActions
implements ActionListener {
    private final Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final boolean cancopy;
    private final boolean canpaste;
    private final JTable table;

    public BreezeTableActions(JTable jTable, boolean bl, boolean bl2) {
        this.table = jTable;
        this.cancopy = bl;
        this.canpaste = bl2;
        if (bl) {
            this.table.registerKeyboardAction(this, "Copy", Main_GUI.getCtrlStroke((int)67), 0);
            this.table.registerKeyboardAction(this, "CopyColumn", Main_GUI.getCtrlStroke((int)67), 0);
        }
        if (bl2) {
            this.table.registerKeyboardAction(this, "Paste", Main_GUI.getCtrlStroke((int)86), 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.cancopy && actionEvent.getActionCommand().compareTo("Copy") == 0) {
            this.copySelectionToClipboard(false, -1);
        } else if (this.cancopy && actionEvent.getActionCommand().compareTo("CopyColumn") == 0) {
            this.copySelectionToClipboard(true, -1);
        } else if (this.canpaste && actionEvent.getActionCommand().compareTo("Paste") == 0) {
            this.copyFromClipboardIntoTable(-1);
        }
    }

    public void addToPopupMenu(BreezeContextMenu breezeContextMenu) {
        if ((this.cancopy || this.canpaste) && breezeContextMenu.getItems() > 0) {
            breezeContextMenu.addSeparator();
        }
        if (this.cancopy) {
            breezeContextMenu.addButtonCloseClick("Copy", () -> this.copySelectionToClipboard(false, breezeContextMenu.getSelectedColumn()));
            breezeContextMenu.addButtonCloseClick("Copy Column", () -> this.copySelectionToClipboard(true, breezeContextMenu.getSelectedColumn()));
        }
        if (this.canpaste) {
            breezeContextMenu.addButtonCloseClick("Paste", () -> this.copyFromClipboardIntoTable(breezeContextMenu.getSelectedColumn()));
        }
    }

    private void copyFromClipboardIntoTable(int n) {
        block7: {
            Transferable transferable;
            int n2;
            int n3 = this.table.getSelectedRow();
            int n4 = n2 = n >= 0 ? n : this.table.getSelectedColumn();
            if (n3 < 0 || n2 < 0) break block7;
            try {
                transferable = this.system.getContents(null);
            }
            catch (IllegalStateException illegalStateException) {
                ThreadUtil.sleep(50L);
                transferable = this.system.getContents(null);
            }
            if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                throw new ErrorHandler.InformationMessageException("Contents in clip board not applicable");
            }
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            String[] stringArray = string.split("\n");
            for (int i = n3; i < n3 + stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i - n3].split("[\t]");
                for (int j = n2; j < n2 + stringArray2.length; ++j) {
                    String string2 = stringArray2[j - n2].replace(",", ".");
                    if (i >= this.table.getRowCount() || j >= this.table.getColumnCount()) continue;
                    this.table.setValueAt(string2, i, j);
                }
            }
        }
    }

    private void copySelectionToClipboard(boolean bl, int n) {
        int[] nArray = this.table.getSelectedRows();
        int[] nArray2 = this.getColumnsToCopy(this.table, bl, n);
        if (nArray.length >= 0 && nArray2.length >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            BreezeTableActions.copySelectionToClipboard(stringBuilder, this.table, nArray, nArray2);
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.system.setContents(stringSelection, stringSelection);
        }
    }

    private int[] getColumnsToCopy(JTable jTable, boolean bl, int n) {
        if (bl) {
            if (n >= 0) {
                return new int[]{n};
            }
            int n2 = this.table.getSelectedColumn();
            if (n2 < 0) {
                return new int[0];
            }
            return new int[]{n2};
        }
        int[] nArray = new int[jTable.getColumnCount()];
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private static void copySelectionToClipboard(StringBuilder stringBuilder, JTable jTable, int[] nArray, int[] nArray2) {
        BreezeTableModel breezeTableModel = (BreezeTableModel)((Object)jTable.getModel());
        for (int i = 0; i < nArray.length; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append("\n");
            }
            if ((object = breezeTableModel.getObjectAt(nArray[i])) == null) continue;
            for (int j = 0; j < nArray2.length; ++j) {
                Sample sample;
                String string;
                Object object2;
                if (j > 0) {
                    stringBuilder.append("\t");
                }
                if ((object2 = jTable.getValueAt(nArray[i], nArray2[j])) == null || (string = (sample = Sample.getSample(object)) != null ? ReportUtils.getStringValue(object2, sample) : String.valueOf(object2)) == null || string.length() == 0) continue;
                stringBuilder.append(string);
            }
        }
    }
}

