/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.table.AbstractTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeHeaderListener;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalTableListener;
import se.prediktera.breeze.frontend.common.swing.table.BreezeRowHeaderRenderer;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePopup;
import se.prediktera.breeze.frontend.common.swing.table.DynamicTableModel;
import se.prediktera.breeze.frontend.common.swing.table.LimitInputField;
import se.prediktera.breeze.frontend.common.swing.table.SegmentationPanel;
import se.prediktera.breeze.frontend.common.swing.table.SortedTableModel;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeSortHeaderRenderer;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.MeasurementViewPanel;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;
import se.prediktera.breeze.frontend.main.model.table.BreezeInnerTable;
import se.prediktera.breeze.frontend.main.record.panel.MeasurementTableInteraction;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.interaction.InteractionInterface;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class BreezeTablePanel
extends AbstractTablePanel {
    private AbstractViewPanel abstractViewPanel;
    private BreezeInnerTable interactionTable;
    private JList rowHeader;
    protected BreezeHeaderListener rowHeaderListeners;
    private final SwingTimer interactionTimer;
    private int actualWidth;
    private int columnWidth = 200;
    private DynamicTableModel rootModel;
    private final BreezeScrollPane scrollPane1 = new BreezeScrollPane();
    private final JPanel settingsPanel = new JPanel();
    private final BreezeTable table = new BreezeTable();
    private final SegmentationPanel segmentationPanel = new SegmentationPanel();
    private final JPanel toolBarPanel = new JPanel(new FlowLayout(0, 10, 5));
    private final LimitInputField limitInputField = new LimitInputField(this.table);
    private Object entry;
    private Workflow.WorkflowType workflowType = Workflow.WorkflowType.None;
    private final boolean sortable;
    private VisualisationNode visualisationNode;
    private BasicPreviewPanel previewPanel;

    public BreezeTablePanel() {
        this(false, true);
    }

    public BreezeTablePanel(boolean bl, boolean bl2) {
        this.sortable = bl;
        this.initComponents();
        this.interactionTimer = new SwingTimer(10, actionEvent -> {
            if (this.interactionTable != null && this.interactionTable.getProject_GUI() != null) {
                this.interactionTable.getProject_GUI().doInteraction((InteractionInterface)this.interactionTable);
            }
        });
        this.interactionTimer.setRepeats(false);
        this.table.setRowHeight(40);
        this.table.setTablePanel(this);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.table.setBackground(breezeTheme.getPanelBackground());
        this.table.setForeground(breezeTheme.getLabelForeground());
        this.table.setSelectionForeground(breezeTheme.getLabelForeground());
        this.table.setSelectionBackground(breezeTheme.getSelectionBackground());
        this.table.setGridColor(breezeTheme.getTableGridColor());
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setFont(new Font("Tahoma", 0, 18));
        jTableHeader.setBackground(breezeTheme.getSettingPanelBackground());
        jTableHeader.setForeground(breezeTheme.getLabelForegroundDifuse());
        this.scrollPane1.getViewport().setBackground(breezeTheme.getSettingPanelBackground());
        this.scrollPane1.setBackground(breezeTheme.getPanelBackground());
        this.scrollPane1.setVerticalScrollBarPolicy(22);
        this.settingsPanel.setOpaque(false);
        this.setBackground(breezeTheme.getPanelBackground());
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionEvent -> {
            if (!this.isclearing && this.table.getRowCount() > 0 && this.table.getSelectedRowCount() > 0 && this.table.getSelectedRowCount() == 1 && !listSelectionEvent.getValueIsAdjusting()) {
                this.putVOInFields(null);
            }
            if (this.rowHeader != null) {
                this.rowHeader.repaint();
            }
            if (this.tablePanel != null && !listSelectionEvent.getValueIsAdjusting()) {
                this.tablePanel.valueChanged();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                BreezeTablePanel.this.updateColumnWidth();
            }
        });
        this.segmentationPanel.setVisible(false);
        this.toolBarPanel.setOpaque(false);
        this.toolBarPanel.setVisible(false);
        this.limitInputField.setVisible(false);
        this.table.setAutoResizeMode(0);
        this.setRootModel(new DynamicTableModel(this.headerVec, this.headerColor, bl2));
    }

    public void setRootModel(DynamicTableModel dynamicTableModel) {
        this.rootModel = dynamicTableModel;
        this.setSortable(this.sortable);
    }

    public void setSortable(boolean bl) {
        if (bl) {
            SortedTableModel sortedTableModel = new SortedTableModel(this.rootModel);
            this.table.setModel(sortedTableModel);
            sortedTableModel.addMouseListenerToHeaderInTable((JTable)((Object)this.table));
        } else {
            this.table.setModel(this.rootModel);
        }
    }

    public void setEditable(boolean bl) {
        this.rootModel.setEditable(bl);
    }

    private BreezeTableModel getModel() {
        return (BreezeTableModel)((Object)this.table.getModel());
    }

    public int getSelectedRowCount() {
        return this.table.getSelectedRowCount();
    }

    public BreezeTable getTable() {
        return this.table;
    }

    @Override
    public void initTable(BreezeTablePanelInterface breezeTablePanelInterface, JButton jButton, boolean bl) {
        super.initTable(breezeTablePanelInterface, jButton, bl);
        if (jButton != null) {
            this.updateNewButton(true);
        }
    }

    public void selectSamples(List<Sample> list) {
        TableModel tableModel;
        if (list.isEmpty()) {
            this.table.getSelectionModel().clearSelection();
        }
        if ((tableModel = this.table.getModel()) instanceof BreezeTableModel) {
            BreezeTableModel breezeTableModel = (BreezeTableModel)((Object)tableModel);
            int n = 0;
            for (int i = 0; i < list.size(); ++i) {
                n = breezeTableModel.indexOf(list.get(i));
                if (i == 0) {
                    this.table.getSelectionModel().setSelectionInterval(n, n);
                    continue;
                }
                this.table.getSelectionModel().addSelectionInterval(n, n);
            }
            this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(n, 0, true)));
        }
    }

    public void selectVO(Object object) {
        BreezeTableModel breezeTableModel = this.getModel();
        int n = breezeTableModel.indexOf(object);
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.table.scrollRectToVisible(this.table.getCellRect(n, this.getThumbnailColumn(), true));
    }

    public void addToToolbar(Component component) {
        if (component instanceof BreezeButton) {
            BreezeButton breezeButton = (BreezeButton)component;
            breezeButton.setToolTipText(breezeButton.getDesc());
            breezeButton.setDesc("");
        }
        this.toolBarPanel.add(component);
        this.toolBarPanel.setVisible(true);
    }

    public void setAbstractViewPanel(AbstractViewPanel abstractViewPanel) {
        this.abstractViewPanel = abstractViewPanel;
        boolean bl2 = abstractViewPanel instanceof MeasurementTableInteraction || abstractViewPanel instanceof MeasurementViewPanel;
        this.segmentationPanel.setVisible(bl2);
        this.segmentationPanel.setListener(bl -> abstractViewPanel.setData(bl));
        this.limitInputField.setVisible(bl2);
        this.limitInputField.setListener(limitConfiguration -> {
            Group group = Group.getGroup(this.entry);
            if (group != null) {
                group.setLimit(limitConfiguration);
            }
            this.table.setLimitNode(limitConfiguration, true);
            this.visualisationNode.setDefaultLimitNode(limitConfiguration);
            if (abstractViewPanel != null && abstractViewPanel.getLeftSettingsPanel() instanceof BasicPreviewPanel) {
                ((BasicPreviewPanel)abstractViewPanel.getLeftSettingsPanel()).reloadImage();
            }
        });
        if (abstractViewPanel != null) {
            this.table.getTableHeader().addMouseListener(new BreezeTablePopup.TableHeaderPopupAdapter(abstractViewPanel, this));
            this.table.addMouseListener(new BreezeTablePopup.TableCellPopupAdapter(abstractViewPanel.getMainPanel(), this, abstractViewPanel));
        }
    }

    public void setInteractionTable(BreezeInnerTable breezeInnerTable) {
        this.interactionTable = breezeInnerTable;
        this.getTable().getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.interactionTimer.restart();
            }
        });
    }

    public void addColumnSelectionListener() {
        this.table.getColumnModel().addColumnModelListener(new BreezeTable.TableColumnModelAdapter(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    BreezeTablePanel.this.interactionTimer.restart();
                }
            }
        });
    }

    public void setTableList(List list, Object object) {
        this.setTableList(list, object, this.hasStructureChanged(list));
    }

    public void setTableList(List list, Object object, boolean bl) {
        super.setTableList(list);
        if (bl) {
            this.rootModel.fireTableStructureChanged();
            BreezeTableModel breezeTableModel = this.getModel();
            if (breezeTableModel instanceof SortedTableModel) {
                SortedTableModel sortedTableModel = (SortedTableModel)breezeTableModel;
                sortedTableModel.sortByColumn(0, sortedTableModel.isAscending());
            }
        } else {
            this.updateTableHeaders();
        }
        this.voToChange = null;
        this.updateTable(object, bl);
        if (bl) {
            this.updateColumnWidth();
        } else {
            this.scrollPane1.setViewportView((Component)((Object)this.table));
        }
    }

    public void updateTableHeaders() {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
        Vector vector = this.headerVec;
        for (int i = 0; i < vector.size(); ++i) {
            if (i >= tableColumnModel.getColumnCount()) continue;
            tableColumnModel.getColumn(i).setHeaderValue(vector.get(i));
        }
    }

    private boolean hasStructureChanged(List list) {
        if (this.tableList == null || this.tableList.isEmpty() || list.isEmpty()) {
            return true;
        }
        List<Object> list2 = this.tablePanel.getTableHeader(list);
        TableColumnModel tableColumnModel = this.getTable().getColumnModel();
        if (list2 == null || tableColumnModel.getColumnCount() != list2.size()) {
            return true;
        }
        Vector vector = this.tablePanel.createVOVector(list.get(0));
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Object object = this.getTable().getValueAt(0, i);
            if (i >= vector.size()) {
                return true;
            }
            Object e = vector.get(i);
            if (e == null || object != null && object.getClass() == e.getClass()) continue;
            return true;
        }
        return false;
    }

    public void updateColumnWidth() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        if (n > 0) {
            int[] nArray = this.tablePanel.getColumnWidth();
            JScrollBar jScrollBar = this.scrollPane1.getVerticalScrollBar();
            int n2 = this.scrollPane1.getWidth() - jScrollBar.getWidth();
            if (this.rowHeader != null) {
                n2 -= this.rowHeader.getWidth() + 1;
            }
            this.actualWidth = Math.max(this.columnWidth, n2 / n);
            try {
                for (int i = 0; i < n; ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    if (nArray != null) {
                        tableColumn.setPreferredWidth((int)((double)(n2 * nArray[i]) / 100.0));
                        continue;
                    }
                    tableColumn.setPreferredWidth(this.actualWidth);
                }
            }
            catch (Exception exception) {
                System.err.println("Problem settings table column width: " + exception.getMessage());
            }
        } else {
            this.actualWidth = this.columnWidth;
        }
        this.adjustFont();
    }

    private void adjustFont() {
        int n = this.table.getRowHeight();
        if (this.actualWidth >= 100 && n >= 30) {
            this.setFontSize(14, 14);
        } else if (this.actualWidth >= 50 && n >= 20) {
            this.setFontSize(12, 12);
        } else {
            this.setFontSize(10, 10);
        }
        this.getTable().setShowGrid(n > 10);
    }

    public void updateTable() {
        this.updateTable(this.getSelectedVO(), false);
    }

    public void updateTable(Object object, boolean bl) {
        HashMap<Object, Vector> hashMap = this.getObjectVectorHashMap(bl);
        BreezeTableModel breezeTableModel = this.getModel();
        breezeTableModel.removeAllRows();
        if (this.tableList != null) {
            for (int i = 0; i < this.tableList.size(); ++i) {
                Object e = this.tableList.get(i);
                Vector vector = hashMap.get(e);
                if (vector != null) {
                    breezeTableModel.addRow(e, vector);
                    continue;
                }
                Vector vector2 = this.tablePanel.createVOVector(e);
                if (vector2 == null) continue;
                breezeTableModel.addRow(e, vector2);
            }
        }
        if (breezeTableModel instanceof SortedTableModel) {
            ((SortedTableModel)breezeTableModel).sort();
        }
        this.tableUpdated();
        if (object != null) {
            this.selectVO(object);
        }
    }

    private void tableUpdated() {
        this.tablePanel.tableUpdated(this.getTable());
    }

    private HashMap<Object, Vector> getObjectVectorHashMap(boolean bl) {
        if (!bl && this.table.getModel() instanceof SortedTableModel) {
            return this.getModel().getObjectVector();
        }
        return new HashMap<Object, Vector>();
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.scrollPane1.setOpaque(false);
        this.scrollPane1.setViewportView((Component)((Object)this.table));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.scrollPane1, gridBagConstraints);
        this.settingsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.settingsPanel.add((Component)this.segmentationPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.settingsPanel.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.toolBarPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 13;
        this.settingsPanel.add((Component)this.limitInputField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add(this.settingsPanel, gridBagConstraints);
    }

    private void putVOInFields(Object object) {
        if (object == null) {
            BreezeTableModel breezeTableModel = this.getModel();
            int n = this.table.getSelectedRow();
            object = this.voToChange = breezeTableModel.getObjectAt(n);
        }
        this.tablePanel.putVOIntoFields(object);
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.table.cleanUp();
    }

    public int getRowHeight() {
        return this.table.getRowHeight();
    }

    public void setRowHeight(int n) {
        this.table.setRowHeight(n);
        if (this.rowHeader != null) {
            this.rowHeader.setFixedCellHeight(n);
        }
        this.adjustFont();
    }

    public void setColumnWidth(int n) {
        this.columnWidth = n;
        this.updateColumnWidth();
        this.scrollPane1.setHorizontalScrollBarPolicy(n > 0 ? 30 : 31);
    }

    public void setFontSize(int n, int n2) {
        this.table.getTableHeader().setFont(new Font("Tahoma", 0, n));
        this.table.setFontSize(n2);
    }

    public void setVisualisationNode(Workflow workflow, Object object) {
        this.visualisationNode = workflow.getVisualisationNode();
        this.entry = object;
        this.workflowType = workflow.getType();
        this.limitInputField.updateLimits(this.table, workflow, Group.getGroup(object));
        this.segmentationPanel.updateSegmentations(workflow);
    }

    public void addRowHeader() {
        this.addRowHeader(80);
    }

    public void addRowHeader(int n) {
        this.addRowHeader(n, 14);
    }

    public void addRowHeader(int n, int n2) {
        AbstractListModel abstractListModel = new AbstractListModel(){

            @Override
            public Object getElementAt(int n) {
                return String.valueOf(n + 1);
            }

            @Override
            public int getSize() {
                return BreezeTablePanel.this.table.getRowCount();
            }
        };
        this.rowHeader = new JList(abstractListModel);
        this.rowHeader.setFixedCellWidth(n);
        this.rowHeader.setFixedCellHeight(this.getRowHeight());
        this.rowHeader.setCellRenderer(new BreezeRowHeaderRenderer((JTable)((Object)this.table), n2));
        this.rowHeaderListeners = new BreezeHeaderListener(this.table, this.rowHeader, true, this.table.getSelectionModel(), this.table.getColumnModel().getSelectionModel());
        this.rowHeader.addMouseListener(this.rowHeaderListeners);
        this.rowHeader.addMouseMotionListener(this.rowHeaderListeners);
        this.rowHeader.addKeyListener(this.rowHeaderListeners);
        this.rowHeader.setBackground(this.table.getTableHeader().getBackground());
        this.scrollPane1.setRowHeaderView(this.rowHeader);
    }

    public void addIntervalListener(int[] nArray, BreezeIntervalTableListener.CallBack callBack) {
        BreezeIntervalTableListener breezeIntervalTableListener = new BreezeIntervalTableListener(this, nArray, callBack);
        this.table.addMouseListener(breezeIntervalTableListener);
        this.table.addMouseMotionListener(breezeIntervalTableListener);
    }

    public void showCellHeightDialog(EntryMainPanelInterface entryMainPanelInterface) {
        this.showCellHeightDialog(entryMainPanelInterface, true);
    }

    public void showCellHeightDialog(EntryMainPanelInterface entryMainPanelInterface, boolean bl) {
        BreezeOptionDialog.showDialog(entryMainPanelInterface.getFrame(), entryMainPanelInterface.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Cell height", bl ? "Set default table cell height" : "Set table cell height", String.valueOf(this.getRowHeight()), breezeActionEvent -> {
            int n = Integer.parseInt(breezeActionEvent.result().toString());
            this.setRowHeight(n);
            if (bl) {
                BreezeProperties.getInstance().setTableCellHeight(n);
            }
        });
    }

    public void showCellWidthDialog(EntryMainPanelInterface entryMainPanelInterface) {
        BreezeOptionDialog.showDialog(entryMainPanelInterface.getFrame(), entryMainPanelInterface.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Cell width", "Set default cell width\n\n(Set width to 0 for auto-fit of all columns)", String.valueOf(BreezeProperties.getInstance().getTableCellWidth()), breezeActionEvent -> {
            int n = Integer.parseInt(breezeActionEvent.result().toString());
            this.setColumnWidth(n);
            BreezeProperties.getInstance().setTableCellWidth(n);
        });
    }

    public Object add(boolean bl) {
        if (this.tablePanel.checkInputValues()) {
            int n = this.table.getSelectedRow();
            Object var3_3 = null;
            if (bl && this.tableList.size() > 0) {
                var3_3 = this.tableList.get(Math.max(0, n));
            }
            Object object = this.tablePanel.createVOFromFields(var3_3, false);
            boolean bl2 = false;
            for (Object e : this.tableList) {
                if (!object.equals(e)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.tableList.add(object);
            }
            this.updateTable(object, false);
            this.tablePanel.setChanged(true);
            return object;
        }
        return null;
    }

    public List delete() {
        Object object = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        BreezeTableModel breezeTableModel = (BreezeTableModel)((Object)this.table.getModel());
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length > 0) {
            int n = nArray[0];
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n2 = nArray[i];
                Object object2 = breezeTableModel.getObjectAt(n2);
                if (!this.tableList.remove(object2)) {
                    return null;
                }
                object = object2;
                arrayList.add(object);
            }
            this.tablePanel.setChanged(true);
            this.updateTable(null, false);
            if (n > 0) {
                --n;
            }
            if (breezeTableModel.getRowCount() == 0) {
                this.tablePanel.clearInputfields();
                this.tablePanel.selectFirstField();
            } else {
                listSelectionModel.setSelectionInterval(n, n);
                this.table.requestFocus();
            }
        }
        return arrayList;
    }

    public Workflow getWorkflow() {
        if (this.visualisationNode != null) {
            return this.visualisationNode.getWorkflow();
        }
        return null;
    }

    public Object getEntry() {
        return this.entry;
    }

    public Workflow.WorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void addPreviewColumnListener(final BasicPreviewPanel basicPreviewPanel) {
        this.previewPanel = basicPreviewPanel;
        final ThumbnailComboBox thumbnailComboBox = basicPreviewPanel.getThumbnailComboBox();
        this.table.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ BreezeTablePanel this$0;
            {
                this.this$0 = breezeTablePanel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = this.this$0.table.rowAtPoint(mouseEvent.getPoint());
                int n2 = this.this$0.table.columnAtPoint(mouseEvent.getPoint());
                if (basicPreviewPanel != null && n >= 0 && n2 >= 0) {
                    Sample sample = BreezeTableCellRenderer.getSampleAt((JTable)((Object)this.this$0.table), n);
                    thumbnailComboBox.changeThumbnail(sample, this.this$0.table.getValueAt(n, n2));
                }
            }
        });
        thumbnailComboBox.addItemListener(itemEvent -> {
            TableCellRenderer tableCellRenderer;
            if (itemEvent.getStateChange() == 1 && (tableCellRenderer = this.table.getTableHeader().getDefaultRenderer()) instanceof BreezeSortHeaderRenderer) {
                BreezeSortHeaderRenderer breezeSortHeaderRenderer = (BreezeSortHeaderRenderer)tableCellRenderer;
                int n = this.getThumbnailColumn();
                breezeSortHeaderRenderer.setThumbnailColumn(n);
                this.table.getTableHeader().repaint();
                if (n >= 0) {
                    this.table.scrollRectToVisible(this.table.getCellRect(this.table.rowAtPoint(this.scrollPane1.getViewport().getViewPosition()), n, true));
                    this.table.repaint();
                }
            }
        });
    }

    public int getThumbnailColumn() {
        if (this.previewPanel != null) {
            return this.previewPanel.getThumbnailComboBox().getTableColumn(this.table);
        }
        return 0;
    }

    public BreezeScrollPane getScrollPane() {
        return this.scrollPane1;
    }

    public JPanel getSettingsPanel() {
        return this.settingsPanel;
    }

    public AbstractViewPanel getAbstractViewPanel() {
        return this.abstractViewPanel;
    }

    public void save(String string) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Save", (Component)((Object)this));
        jopensaveDialog2.setFileName(string + ".txt");
        if (jopensaveDialog2.saveshow()) {
            this.save(jopensaveDialog2.getSelectedFile(), string);
        }
    }

    public void save(File file, String string) {
        try (PrintWriter printWriter = new PrintWriter(file);){
            int n;
            printWriter.println(string);
            printWriter.println();
            for (n = 0; n < this.table.getColumnCount(); ++n) {
                printWriter.print(this.table.getColumnName(n) + "\t");
            }
            printWriter.println();
            printWriter.println();
            for (n = 0; n < this.table.getRowCount(); ++n) {
                for (int i = 0; i < this.table.getColumnCount(); ++i) {
                    Object object = this.table.getValueAt(n, i);
                    printWriter.print((object != null ? object.toString() : "") + "\t");
                }
                printWriter.println();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public List getSelectedValues() {
        return this.table.getSelectedValues();
    }

    public static class FunctionCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        public FunctionCellRenderer() {
            super(0);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "";
            if (object instanceof BreezeComboBox.SeparatorClass) {
                return this.separator;
            }
            if (object instanceof SegmentationNodeList) {
                string = object.toString();
            } else if (object instanceof FunctionTreeNode) {
                FunctionTreeNode functionTreeNode = (FunctionTreeNode)object;
                if (functionTreeNode != null) {
                    string = functionTreeNode.getParent() instanceof FunctionTreeNode ? functionTreeNode.getAliasOrNodeString() : "Measurement";
                }
            } else if (object != null) {
                string = object.toString();
            }
            string = string.replaceAll("@@", " ");
            return super.getListCellRendererComponent(jList, (Object)string, n, bl, bl2);
        }
    }

    public static interface CallBack {
        public void deletedEntries(List var1);
    }
}

