/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.backend.measure.applychanges.ReferenceValueCopyer;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.SampleVariableOrIdentifier;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationAreaDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.spatial.ManualSegmentation;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SamplePath;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeHtmlPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableActions;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.SortedTableModel;
import se.prediktera.breeze.frontend.common.swing.table.ValueCellInterface;
import se.prediktera.breeze.frontend.common.swing.table.renderer.DescriptorCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailSample;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.common.view.preview.InteractionPreviewPanel;
import se.prediktera.breeze.frontend.main.model.table.ClassificationSummaryViewContainer;
import se.prediktera.breeze.frontend.main.model.table.PredictionSummaryViewContainer;
import se.prediktera.breeze.frontend.main.model.table.SummaryViewContainer;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.AbstractEditEntryMainPanel;
import se.prediktera.breeze.frontend.main.record.panel.EditMeasurementTableInteraction;
import se.prediktera.map.register.RegInfo;

public class BreezeTablePopup {
    public static void remove(Workflow workflow, Factor factor) {
        if (factor instanceof CategoryFactor) {
            workflow.getCategoryFactors().getList().remove(factor);
        } else {
            workflow.getPropertyFactors().getList().remove(factor);
        }
        WorkflowMainPanel.removeFactorFromSamples(workflow, factor);
    }

    public static class TableCellPopupAdapter
    extends MouseAdapter {
        private final BreezeMainPanel mainPanel;
        private final BreezeTablePanel tablePanel;
        private final BreezeTable table;
        private final BreezeTableActions actions;
        private final AbstractViewPanel abstractViewPanel;

        public TableCellPopupAdapter(BreezeMainPanel breezeMainPanel, BreezeTablePanel breezeTablePanel, AbstractViewPanel abstractViewPanel) {
            this.mainPanel = breezeMainPanel;
            this.tablePanel = breezeTablePanel;
            this.table = breezeTablePanel.getTable();
            this.abstractViewPanel = abstractViewPanel;
            this.actions = new BreezeTableActions((JTable)((Object)this.table), true, true);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void mousePressed(MouseEvent var1_1) {
            block15: {
                block17: {
                    block18: {
                        block16: {
                            var2_2 = this.mainPanel.getFrame();
                            if (!SwingUtilities.isRightMouseButton(var1_1)) break block15;
                            var3_3 = new BreezeContextMenu(var2_2, Color.red);
                            var4_4 = this.table.columnAtPoint(var1_1.getPoint());
                            var5_5 = this.table.getValueAt(0, var4_4);
                            var3_3.setColumn(var4_4);
                            if (!(var5_5 instanceof Identifier) && !(var5_5 instanceof Measurement) && !(var5_5 instanceof PropertyFactor) && !(var5_5 instanceof ValueCellInterface)) break block16;
                            var8_6 = var5_5.toString();
                            if (var5_5 instanceof Measurement) {
                                var8_6 = "Measurement";
                            }
                            if (var5_5 instanceof ValueCellInterface) {
                                var8_6 = "Value";
                            }
                            var3_3.addTitle(var8_6);
                            var9_11 = new BreezeTextField();
                            var9_11.setText(null);
                            if (var5_5 instanceof PropertyFactor || var5_5 instanceof ValueCellInterface) {
                                var9_11.setNumberField(true);
                            }
                            var9_11.addChangeListener((TextActionEvent.TextActionListener)LambdaMetafactory.metafactory(null, null, null, (Lse/prediktera/breeze/frontend/TextActionEvent;)V, lambda$mousePressed$0(se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu int se.prediktera.breeze.frontend.TextActionEvent ), (Lse/prediktera/breeze/frontend/TextActionEvent;)V)((TableCellPopupAdapter)this, (BreezeContextMenu)var3_3, (int)var4_4));
                            var9_11.requestFocus();
                            var9_11.setName("tableInput");
                            var3_3.addComponent(var9_11);
                            break block17;
                        }
                        if (!(var5_5 instanceof CategoryFactor) || !(var6_16 = (CategoryFactor)var5_5).isEditable()) break block18;
                        var3_3.addTitle(var5_5.toString());
                        var8_7 = new BreezeComboBox(true);
                        var8_7.setRenderer(new SelectMembersPanel.CatClassListCellRenderer());
                        var8_7.setModel(new DefaultComboBoxModel<Object>(var6_16.getClasses().toArray()));
                        var9_12 = this.getSelectedIndex(this.table.getSelectedValues(), var6_16);
                        if (var9_12 < var8_7.getItemCount()) {
                            var8_7.setSelectedIndex(var9_12);
                        }
                        var8_7.addActionListener((ActionListener)LambdaMetafactory.metafactory(null, null, null, (Ljava/awt/event/ActionEvent;)V, lambda$mousePressed$1(se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu int java.awt.event.ActionEvent ), (Ljava/awt/event/ActionEvent;)V)((TableCellPopupAdapter)this, (BreezeContextMenu)var3_3, (int)var4_4));
                        var8_7.requestFocus();
                        var8_7.setName("tableInput");
                        var3_3.addComponent(var8_7);
                        var3_3.addSeparator();
                        var3_3.addTitle("New class");
                        var10_17 = new BreezeTextField();
                        var10_17.setText("");
                        var10_17.addChangeListener((TextActionEvent.TextActionListener)LambdaMetafactory.metafactory(null, null, null, (Lse/prediktera/breeze/frontend/TextActionEvent;)V, lambda$mousePressed$0(se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu int se.prediktera.breeze.frontend.TextActionEvent ), (Lse/prediktera/breeze/frontend/TextActionEvent;)V)((TableCellPopupAdapter)this, (BreezeContextMenu)var3_3, (int)var4_4));
                        var3_3.addComponent(var10_17);
                        var3_3.addButtonCloseClick("Add", (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$3(int se.prediktera.breeze.frontend.common.swing.BreezeTextField ), ()V)((TableCellPopupAdapter)this, (int)var4_4, (BreezeTextField)var10_17));
                        break block17;
                    }
                    if (!(var5_5 instanceof FunctionResult)) ** GOTO lbl-1000
                    var7_20 = (FunctionResult)var5_5;
                    if (RegInfo.isApplicationFeature()) {
                        if (var7_20.getFunction() instanceof PlsPredDescriptor.TableRetrainDescriptor && this.tablePanel.getWorkflowType().equals((Object)Workflow.WorkflowType.Record) && (var9_13 = var7_20.getAnalyse()) instanceof Analyse) {
                            var8_8 = (Analyse)var9_13;
                            var3_3.addTitle(StringUtils.abbreviate((String)var8_8.getName(), (int)25));
                            var3_3.addButtonCloseClick("Train", (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$4(int ), ()V)((TableCellPopupAdapter)this, (int)var4_4));
                            var3_3.addButtonCloseClick("Test", (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$5(int ), ()V)((TableCellPopupAdapter)this, (int)var4_4));
                            var3_3.addButtonCloseClick("Exclude", (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$6(int ), ()V)((TableCellPopupAdapter)this, (int)var4_4));
                            var3_3.addSeparator();
                            var9_13 = new BreezeCheckBox("Balance data", false);
                            var3_3.addButtonCloseClick("Retrain", (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$7(se.prediktera.breeze.frontend.BreezeFrame se.prediktera.breeze.entry.analyse.Analyse se.prediktera.breeze.frontend.common.swing.BreezeCheckBox ), ()V)((TableCellPopupAdapter)this, (BreezeFrame)var2_2, (Analyse)var8_8, (BreezeCheckBox)var9_13));
                            var3_3.addComponent((JComponent)var9_13);
                            var3_3.addSeparator();
                            var3_3.addButtonCloseClick("Variable \u2190 Prediction", (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$8(se.prediktera.breeze.frontend.BreezeFrame se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult int ), ()V)((TableCellPopupAdapter)this, (BreezeFrame)var2_2, (FunctionResult)var7_20, (int)var4_4));
                        }
                    } else if (var5_5 instanceof Sample || var5_5 instanceof ThumbnailSample) {
                        var8_9 = this.table.getSelectedRows();
                        if (var8_9.length > 0) {
                            var9_14 = (Sample)this.table.getValueAt(var8_9[0], 0);
                            var3_3.addButtonCloseClick("Go to measurement", (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$10(se.prediktera.breeze.entry.sample.Sample ), ()V)((TableCellPopupAdapter)this, (Sample)var9_14));
                            var10_18 = var9_14.measurement().getWorkflow();
                            var11_21 = var10_18.getHighlighedSamples();
                            var12_23 = var11_21.contains(var9_14) == false;
                            var3_3.addButtonCloseClick(var12_23 != false ? "Pin" : "Unpin", (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$11(int[] se.prediktera.breeze.entry.workflow.Workflow$HighlighedSamples boolean ), ()V)((TableCellPopupAdapter)this, (int[])var8_9, (Workflow.HighlighedSamples)var11_21, (boolean)var12_23));
                            var3_3.addSeparator();
                            this.addSampleButtons(var2_2, var3_3, var10_18);
                        }
                    } else if (var5_5 instanceof SegmentationNode && !(var8_10 = this.table.getSelectedValues()).isEmpty()) {
                        var9_15 = (Sample)var8_10.getFirst();
                        var10_19 = var9_15.measurement().getWorkflow();
                        var11_22 = var10_19.getSegmentationNodes();
                        var12_24 = TableCellPopupAdapter.isOnlyManualSegmentations(var8_10, var11_22);
                        var13_25 = var11_22.getManualSegmentations();
                        if (!var13_25.isEmpty()) {
                            for (SegmentationNode var15_27 : var13_25) {
                                var16_28 = (ManualSegmentation)var15_27.getFunction();
                                var17_29 = var16_28.getCatClass();
                                var3_3.addButtonCloseClick((var12_24 != false ? "Move" : "Add") + " to " + var15_27.getAliasOrNodeString(), (EntryMainHelper.ClickCallBack)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$mousePressed$12(se.prediktera.breeze.frontend.BreezeFrame se.prediktera.breeze.entry.sample.Sample java.util.List se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode boolean se.prediktera.breeze.entry.workflow.Workflow se.prediktera.breeze.common.entry.factor.category.CatClass ), ()V)((TableCellPopupAdapter)this, (BreezeFrame)var2_2, (Sample)var9_15, (List)var8_10, (SegmentationNode)var15_27, (boolean)var12_24, (Workflow)var10_19, (CatClass)var17_29));
                            }
                            var3_3.addSeparator();
                        }
                        this.addSampleButtons(var2_2, var3_3, var10_19);
                    }
                }
                if (this.actions != null) {
                    this.actions.addToPopupMenu(var3_3);
                }
                if (var3_3.resize()) {
                    var2_2.addPage((JPanel)var3_3);
                    var3_3.setPositionLater(var1_1);
                }
            }
        }

        private static boolean isOnlyManualSegmentations(List list, SegmentationNodeList segmentationNodeList) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object : list) {
                hashSet.add(((Sample)object).getSegmentationHashId());
            }
            for (String string : hashSet) {
                SegmentationNode segmentationNode = segmentationNodeList.getSegmentation(string);
                if (segmentationNode == null || segmentationNode.getFunction() instanceof ManualSegmentation) continue;
                return false;
            }
            return true;
        }

        private void addSampleButtons(BreezeFrame breezeFrame, BreezeContextMenu breezeContextMenu, final Workflow workflow) {
            List list = this.tablePanel.getSelectedValues();
            if (TableCellPopupAdapter.isOnlyManualSegmentations(list, workflow.getSegmentationNodes())) {
                if (list.size() > 1) {
                    breezeContextMenu.addButtonCloseClick("Merge", () -> BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

                        @Override
                        public void runAction() {
                            EditMeasurementTableInteraction.TableSettingsPanel.withSamples(abstractViewPanel.getMainPanel(), tablePanel, list -> {
                                SamplePath samplePath = ((Sample)list.getFirst()).getSamplePath();
                                for (int i = 1; i < list.size(); ++i) {
                                    Sample sample = (Sample)list.get(i);
                                    samplePath.addSelectionPaths(sample.getSamplePath().getSelectionPaths());
                                    sample.getParent().removeChild(sample);
                                }
                            }, this.getProgressManager());
                        }
                    }, "Merging samples(s)"));
                }
                if (this.canSplit(list)) {
                    breezeContextMenu.addButtonCloseClick("Split", () -> BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                        final /* synthetic */ TableCellPopupAdapter this$0;
                        {
                            this.this$0 = tableCellPopupAdapter;
                        }

                        @Override
                        public void runAction() {
                            EditMeasurementTableInteraction.TableSettingsPanel.withSamples(this.this$0.abstractViewPanel.getMainPanel(), this.this$0.tablePanel, list -> {
                                for (Sample sample : list) {
                                    Sample sample2 = (Sample)sample.getParent();
                                    int n = sample2.getChildIndex(sample) + 1;
                                    List<SamplePath.SelectionPath> list2 = sample.getSamplePath().getSelectionPaths();
                                    if (list2.size() <= 1) continue;
                                    for (int i = list2.size() - 1; i >= 1; --i) {
                                        Sample sample3 = new Sample(sample2, sample.getSegmentationHashId());
                                        sample3.getSamplePath().setSelectionPaths(Collections.singletonList(list2.get(i)));
                                        ReferenceValueCopyer.updateSample(workflow, sample3, sample);
                                        sample2.addChild(n, sample3);
                                    }
                                    sample.getSamplePath().setSelectionPaths(Collections.singletonList(list2.getFirst()));
                                }
                            }, this.getProgressManager());
                        }
                    }, "Splitting samples(s)"));
                }
            }
            if (workflow.getSegmentationLevel() > 0) {
                breezeContextMenu.addButtonCloseClick("Delete Samples", () -> EditMeasurementTableInteraction.TableSettingsPanel.deleteSelectedSamples(this.abstractViewPanel.getMainPanel(), this.tablePanel));
            }
            breezeContextMenu.addButtonCloseClick("Delete Measurements", () -> EditMeasurementTableInteraction.TableSettingsPanel.deleteSelectedMeasurement(this.abstractViewPanel.getMainPanel(), this.tablePanel));
            breezeContextMenu.addButtonCloseClick("Move Measurements", () -> EntryMeasurementPanel.showMoveMeasurementsDialog(this.abstractViewPanel.getMainPanel(), EditMeasurementTableInteraction.TableSettingsPanel.getSelectedMeasurements(this.tablePanel)));
        }

        private boolean canSplit(List list) {
            for (Object e : list) {
                if (!(e instanceof Sample) || ((Sample)e).getSamplePath().getSelectionPaths().size() <= 1) continue;
                return true;
            }
            return false;
        }

        private int getSelectedIndex(List list, CategoryFactor categoryFactor) {
            int n = -1;
            for (Object e : list) {
                Float f;
                if (!(e instanceof Sample) || (f = ((Sample)e).getVariableValue(categoryFactor)) == null) continue;
                if (n == -1) {
                    n = f.intValue();
                    continue;
                }
                if (n == f.intValue()) continue;
                return 0;
            }
            return Math.max(n, 0);
        }

        private void onInputChange(BreezeContextMenu breezeContextMenu, JTable jTable, int n, ActionEvent actionEvent, boolean bl) {
            this.onInputChange(jTable, n, actionEvent, bl);
            breezeContextMenu.close();
        }

        private void onInputChange(JTable jTable, int n, ActionEvent actionEvent, boolean bl) {
            this.onInputChange(jTable, n, actionEvent.getSource().toString(), bl);
        }

        private void onInputChange(JTable jTable, int n, String string, boolean bl) {
            if (!bl) {
                ((BreezeTableModel)((Object)jTable.getModel())).setValuesAt(string, jTable.getSelectedRows(), n);
            }
        }

        private /* synthetic */ void lambda$mousePressed$12(BreezeFrame breezeFrame, final Sample sample, final List list, final SegmentationNode segmentationNode, final boolean bl, final Workflow workflow, final CatClass catClass) {
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                final /* synthetic */ TableCellPopupAdapter this$0;
                {
                    this.this$0 = tableCellPopupAdapter;
                }

                @Override
                public void runAction() {
                    HashSet<Measurement> hashSet = new HashSet<Measurement>();
                    Sample sample4 = (Sample)sample.getParent();
                    for (Object object : list) {
                        Sample sample2 = (Sample)object;
                        if (sample2.getSegmentationHashId().equals(segmentationNode.getUid())) continue;
                        Sample sample3 = sample2;
                        if (bl) {
                            sample2.setSegmentationHashId(segmentationNode.getUid());
                        } else {
                            sample3 = new Sample(sample4, segmentationNode.getUid());
                            sample3.getSamplePath().setSelectionPaths(sample2.getSamplePath().getSelectionPaths());
                            ReferenceValueCopyer.updateSample(workflow, sample3, sample2);
                            sample4.addChild(sample3);
                        }
                        if (catClass != null && !catClass.isNoClass()) {
                            sample3.getSampleValues().setValue(catClass.getFactor(), catClass.getClassIndex());
                        }
                        hashSet.add(sample2.measurement());
                    }
                    for (Measurement measurement : hashSet) {
                        measurement.save();
                    }
                    if (!hashSet.isEmpty()) {
                        ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), new ArrayList<Measurement>(hashSet));
                        this.this$0.abstractViewPanel.getMainPanel().setDirty(true);
                    }
                }
            }, "Adding sample(s)");
        }

        private /* synthetic */ void lambda$mousePressed$11(int[] nArray, Workflow.HighlighedSamples highlighedSamples, boolean bl) {
            for (int n : nArray) {
                Sample sample = (Sample)this.table.getValueAt(n, 0);
                highlighedSamples.update(sample, bl);
            }
            Object object = InteractionPreviewPanel.getSelectedInstance();
            if (object != null) {
                ((InteractionPreviewPanel)object).updateHighlightSamples();
            }
        }

        private /* synthetic */ void lambda$mousePressed$10(Sample sample) {
            EntryMainHelper.showMeasurementPanel(this.mainPanel, sample);
        }

        private /* synthetic */ void lambda$mousePressed$8(BreezeFrame breezeFrame, FunctionResult functionResult, int n) {
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Update variables", "Do you want to update the variable (" + String.valueOf(functionResult.getFactor()) + ") with the predicted values from the selected samples?", null, breezeActionEvent -> this.onInputChange((JTable)((Object)this.table), n, "update", false));
        }

        private /* synthetic */ void lambda$mousePressed$7(BreezeFrame breezeFrame, final Analyse analyse, final BreezeCheckBox breezeCheckBox) {
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
                final /* synthetic */ TableCellPopupAdapter this$0;
                {
                    this.this$0 = tableCellPopupAdapter;
                }

                @Override
                public void runAction() {
                    analyse.getWorkflow().setApplyChangesNeededOnAllMeasurements();
                    analyse.checkFullyParsed();
                    analyse.autoReTrain(this.getProgressManager(), true, breezeCheckBox.isSelected(), true);
                    this.this$0.abstractViewPanel.applyChangesOnPanel(this.getProgressManager());
                }
            }, "Retraining");
        }

        private /* synthetic */ void lambda$mousePressed$6(int n) {
            this.onInputChange((JTable)((Object)this.table), n, "exclude", false);
        }

        private /* synthetic */ void lambda$mousePressed$5(int n) {
            this.onInputChange((JTable)((Object)this.table), n, "test", false);
        }

        private /* synthetic */ void lambda$mousePressed$4(int n) {
            this.onInputChange((JTable)((Object)this.table), n, "train", false);
        }

        private /* synthetic */ void lambda$mousePressed$3(int n, BreezeTextField breezeTextField) {
            this.onInputChange((JTable)((Object)this.table), n, breezeTextField.getText(), false);
        }

        private /* synthetic */ void lambda$mousePressed$1(BreezeContextMenu breezeContextMenu, int n, ActionEvent actionEvent) {
            this.onInputChange(breezeContextMenu, (JTable)((Object)this.table), n, actionEvent, false);
        }

        private /* synthetic */ void lambda$mousePressed$0(BreezeContextMenu breezeContextMenu, int n, TextActionEvent textActionEvent) {
            this.onInputChange(breezeContextMenu, (JTable)((Object)this.table), n, textActionEvent, textActionEvent.isFocusLost());
        }
    }

    public static class TableHeaderPopupAdapter
    extends MouseAdapter {
        private final AbstractViewPanel viewPanel;
        private final BreezeTablePanel tablePanel;

        public TableHeaderPopupAdapter(AbstractViewPanel abstractViewPanel, BreezeTablePanel breezeTablePanel) {
            this.viewPanel = abstractViewPanel;
            this.tablePanel = breezeTablePanel;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Workflow workflow = this.tablePanel.getWorkflow();
            if (workflow != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
                Object object;
                BreezeFrame breezeFrame = this.viewPanel.getFrame();
                BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
                BreezeTable breezeTable = this.tablePanel.getTable();
                int n = breezeTable.columnAtPoint(mouseEvent.getPoint());
                Object object2 = breezeTable.getValueAt(0, n);
                Object object3 = breezeTable.getModel();
                if (object3 instanceof SortedTableModel) {
                    object = (SortedTableModel)object3;
                    breezeContextMenu.addSubMenu("Sort", arg_0 -> TableHeaderPopupAdapter.lambda$mousePressed$0((SortedTableModel)object, breezeTable, n, arg_0));
                }
                if (object2 instanceof SampleVariableOrIdentifier) {
                    object = (SampleVariableOrIdentifier)object2;
                    breezeContextMenu.addSeparator();
                    breezeContextMenu.addButtonCloseClick("Delete", () -> this.lambda$mousePressed$4(breezeFrame, (SampleVariableOrIdentifier)object, workflow));
                    breezeContextMenu.addButtonCloseClick("Rename", () -> this.lambda$mousePressed$6(breezeFrame, (SampleVariableOrIdentifier)object, workflow));
                    breezeContextMenu.addButtonCloseClick("Edit", () -> this.lambda$mousePressed$8((SampleVariableOrIdentifier)object));
                    if (object instanceof PropertyFactor) {
                        breezeContextMenu.addSeparator();
                        breezeContextMenu.addButtonCloseClick("Show summary", () -> BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Summary", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new SummaryViewContainer(this.viewPanel.getMainPanel(), object2, this.tablePanel.getEntry(), "Property"), this.tablePanel.getEntry(), 0.85), null, null));
                    }
                    if (object instanceof CategoryFactor) {
                        breezeContextMenu.addSeparator();
                        breezeContextMenu.addButtonCloseClick("Summary", () -> this.lambda$mousePressed$10((SampleVariableOrIdentifier)object, breezeTable, breezeFrame));
                    }
                }
                if (object2 instanceof FunctionResult) {
                    object = (FunctionResult)object2;
                    object3 = ((FunctionResult)object).getFunction();
                    if (object3 instanceof PlsPredClassificationDescriptor && ((FunctionResult)object).getFactor() != null) {
                        breezeContextMenu.addButtonCloseClick("Show classification summary", () -> this.lambda$mousePressed$11(breezeFrame, workflow, (FunctionResult)object));
                    } else if (object3 instanceof PlsPredQuantificationDescriptor && ((FunctionResult)object).getFactor() != null) {
                        breezeContextMenu.addButtonCloseClick("Show prediction summary", () -> this.lambda$mousePressed$12(breezeFrame, workflow, (FunctionResult)object));
                    } else {
                        breezeContextMenu.addSeparator();
                        if (object3 instanceof PlsPredClassificationAreaDescriptor) {
                            breezeContextMenu.addButtonCloseClick("Show summary image", () -> this.lambda$mousePressed$13(breezeFrame, (FunctionResult)object));
                        }
                        breezeContextMenu.addButtonCloseClick("Show summary", () -> this.lambda$mousePressed$14(breezeFrame, (FunctionResult)object));
                    }
                }
                if (object2 instanceof SegmentationNode && !((ArrayList)(object = workflow.getSegmentationNodes())).isEmpty()) {
                    breezeContextMenu.addButtonCloseClick("Summary", () -> this.lambda$mousePressed$15((SegmentationNodeList)object, breezeFrame));
                }
                if (breezeContextMenu.resize()) {
                    breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
                    breezeContextMenu.setPositionLater(mouseEvent);
                }
            }
        }

        private int[] getClassSummary(JTable jTable, CategoryFactor categoryFactor) {
            int[] nArray = new int[categoryFactor.getMaxIndex() + 1];
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                Sample sample = (Sample)jTable.getValueAt(i, 0);
                Float f = sample.getVariableValue(categoryFactor);
                if (f == null) continue;
                int n = f.intValue();
                nArray[n] = nArray[n] + 1;
            }
            return nArray;
        }

        private /* synthetic */ void lambda$mousePressed$15(SegmentationNodeList segmentationNodeList, BreezeFrame breezeFrame) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<table style=\"width:100%\"><tr>");
            stringBuilder.append("<th style=\"width:40%\" align=\"left\">Name</th><th align=\"right\">Samples</th>");
            for (int i = 1; i < segmentationNodeList.size(); ++i) {
                stringBuilder.append("<th align=\"right\">Overlap ").append(i).append("</th>");
            }
            stringBuilder.append("</tr>");
            ArrayList<SegmentationNodeList.SegmentationSamples> arrayList = new ArrayList<SegmentationNodeList.SegmentationSamples>();
            for (SegmentationNode object : segmentationNodeList) {
                arrayList.add(new SegmentationNodeList.SegmentationSamples(object, this.tablePanel.getTableList()));
            }
            for (SegmentationNodeList.SegmentationSamples segmentationSamples : arrayList) {
                for (SegmentationNodeList.SegmentationSamples segmentationSamples2 : arrayList) {
                    if (segmentationSamples == segmentationSamples2) continue;
                    segmentationSamples.addOverlap(segmentationSamples2);
                }
                stringBuilder.append("<tr><td>");
                stringBuilder.append(segmentationSamples.getNode().getAliasOrNodeString());
                stringBuilder.append("</td><td align=\"right\">");
                stringBuilder.append(segmentationSamples.getNumber());
                stringBuilder.append("</td>");
                for (SegmentationNodeList.SegmentationOverlap segmentationOverlap : segmentationSamples.getOverlaps()) {
                    stringBuilder.append("<td align=\"right\">");
                    stringBuilder.append(RtDataFormat.toString(segmentationOverlap.percent() * 100.0, 6, false)).append("%");
                    stringBuilder.append("</td>");
                }
                stringBuilder.append("</tr>");
            }
            stringBuilder.append("</table>");
            BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Segmentation summary", "", (AbstractBreezeCustomPanel)new BreezeHtmlPanel(stringBuilder.toString()), null, null);
        }

        private /* synthetic */ void lambda$mousePressed$14(BreezeFrame breezeFrame, FunctionResult functionResult) {
            BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Summary", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new SummaryViewContainer(this.viewPanel.getMainPanel(), functionResult, this.tablePanel.getEntry(), "Descriptor"), this.tablePanel.getEntry(), 0.85), null, null);
        }

        private /* synthetic */ void lambda$mousePressed$13(BreezeFrame breezeFrame, FunctionResult functionResult) {
            BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Summary image", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new PlsPredClassificationAreaDescriptor.SummaryImageViewContainer(this.viewPanel.getMainPanel(), functionResult, DescriptorCellRenderer.getSamples((JTable)((Object)this.tablePanel.getTable())), "Descriptor"), this.tablePanel.getEntry(), 0.85), null, null);
        }

        private /* synthetic */ void lambda$mousePressed$12(BreezeFrame breezeFrame, Workflow workflow, FunctionResult functionResult) {
            BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Prediction summary", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new PredictionSummaryViewContainer(this.viewPanel.getMainPanel(), workflow, functionResult, this.tablePanel.getEntry()), this.tablePanel.getEntry(), 0.85), null, null);
        }

        private /* synthetic */ void lambda$mousePressed$11(BreezeFrame breezeFrame, Workflow workflow, FunctionResult functionResult) {
            BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Classification summary", "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new ClassificationSummaryViewContainer(this.viewPanel.getMainPanel(), workflow, functionResult, this.tablePanel.getEntry()), workflow, 0.85), null, null);
        }

        private /* synthetic */ void lambda$mousePressed$10(SampleVariableOrIdentifier sampleVariableOrIdentifier, BreezeTable breezeTable, BreezeFrame breezeFrame) {
            CategoryFactor categoryFactor = (CategoryFactor)sampleVariableOrIdentifier;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<table style=\"width:100%\"><tr>");
            stringBuilder.append("<th style=\"width:40%\" align=\"left\">Name</th><th align=\"right\">Number</th>");
            stringBuilder.append("<th align=\"right\">Percent</th></tr>");
            int[] nArray = this.getClassSummary((JTable)((Object)breezeTable), categoryFactor);
            for (CatClass catClass : categoryFactor.getAllClasses()) {
                stringBuilder.append("<tr><td>");
                stringBuilder.append(catClass.getName());
                stringBuilder.append("</td><td align=\"right\">");
                int n = nArray[categoryFactor.getClassIndex(catClass)];
                stringBuilder.append(n);
                stringBuilder.append("</td ><td align=\"right\">");
                stringBuilder.append(RtDataFormat.toPercent((float)n / (float)breezeTable.getRowCount()));
                stringBuilder.append("</td></tr>");
            }
            stringBuilder.append("<tr></tr><tr><th align=\"left\">Total</th><th align=\"right\">");
            stringBuilder.append(breezeTable.getRowCount());
            stringBuilder.append("</th></tr></table>");
            BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, categoryFactor.getName() + " summary", "", (AbstractBreezeCustomPanel)new BreezeHtmlPanel(stringBuilder.toString()), null, null);
        }

        private /* synthetic */ void lambda$mousePressed$8(SampleVariableOrIdentifier sampleVariableOrIdentifier) {
            EntryMainHelper.showEditPanel(this.viewPanel.getMainPanel(), true, sampleVariableOrIdentifier);
        }

        private /* synthetic */ void lambda$mousePressed$6(BreezeFrame breezeFrame, SampleVariableOrIdentifier sampleVariableOrIdentifier, Workflow workflow) {
            BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Rename", "Enter new name:", sampleVariableOrIdentifier.getName(), breezeActionEvent -> {
                sampleVariableOrIdentifier.setName(breezeActionEvent.getInputText());
                workflow.save();
                this.viewPanel.setData(true);
            });
        }

        private /* synthetic */ void lambda$mousePressed$4(BreezeFrame breezeFrame, SampleVariableOrIdentifier sampleVariableOrIdentifier, Workflow workflow) {
            BreezeOptionDialog.showDialog(breezeFrame, this.viewPanel.getMainPanel().getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm delete", AbstractEditEntryMainPanel.getDeleteText(sampleVariableOrIdentifier.toString()), null, breezeActionEvent -> {
                if (sampleVariableOrIdentifier instanceof Factor) {
                    BreezeTablePopup.remove(workflow, (Factor)sampleVariableOrIdentifier);
                } else if (sampleVariableOrIdentifier instanceof Identifier) {
                    workflow.getIdentifiers().remove(workflow, (Identifier)sampleVariableOrIdentifier);
                }
                workflow.save();
                this.viewPanel.setData(true);
            });
        }

        private static /* synthetic */ void lambda$mousePressed$0(SortedTableModel sortedTableModel, BreezeTable breezeTable, int n, BreezeContextMenu breezeContextMenu) {
            breezeContextMenu.addButtonCloseClick("Ascending", () -> sortedTableModel.sortColumn((JTable)((Object)breezeTable), n, true));
            breezeContextMenu.addButtonCloseClick("Reset", () -> sortedTableModel.sortColumn((JTable)((Object)breezeTable), 0, true));
            breezeContextMenu.addButtonCloseClick("Descending", () -> sortedTableModel.sortColumn((JTable)((Object)breezeTable), n, false));
        }
    }
}

