/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.sql.Date;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.swing.table.DynamicTableModel;
import se.prediktera.breeze.frontend.common.swing.table.ITableSorter;
import se.prediktera.breeze.frontend.common.swing.table.TableMap;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.BreezeIndexIntervalClass;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectSamplePanelStep;
import se.prediktera.breeze.frontend.wizard.model.panel.selectstep.SelectWavelengthPanelStep;
import se.prediktera.map.common.error.Logg;

public class BreezeTableSorter
extends TableMap
implements ITableSorter {
    protected int[] indexes = new int[0];
    protected boolean ascending = true;
    protected int sortedColumnIndex = 0;
    protected int compares;
    protected Map comparatorMap = null;

    public void checkModel() {
        if (this.indexes.length != this.model.getRowCount()) {
            this.reallocateIndexes();
        }
    }

    public int compare(int n, int n2) {
        ++this.compares;
        if (this.isEmptyRow(n2)) {
            return -1;
        }
        if (this.isEmptyRow(n)) {
            return 1;
        }
        int n3 = this.compareRowsByColumn(n, n2, this.sortedColumnIndex);
        if (n3 != 0) {
            return this.ascending ? n3 : -n3;
        }
        return 0;
    }

    public int compareRowsByColumn(int n, int n2, int n3) {
        Object object;
        String string;
        DynamicTableModel dynamicTableModel = this.model;
        if (this.comparatorMap != null && this.comparatorMap.get(n3) != null) {
            Comparator comparator = (Comparator)this.comparatorMap.get(n3);
            return comparator.compare(dynamicTableModel.getValueAt(n, n3), dynamicTableModel.getValueAt(n2, n3));
        }
        Class clazz = this.model.getColumnClass(n3);
        Object object2 = dynamicTableModel.getValueAt(n, n3);
        Object object3 = dynamicTableModel.getValueAt(n2, n3);
        if (object2 == null && object3 == null) {
            return 0;
        }
        if (object2 == null) {
            return -1;
        }
        if (object3 == null) {
            return 1;
        }
        if (clazz.getSuperclass() == Number.class) {
            Number number = null;
            number = dynamicTableModel.getValueAt(n, n3) instanceof Number ? (Number)((Number)dynamicTableModel.getValueAt(n, n3)) : (Number)-1;
            double d = ((Number)number).doubleValue();
            Number number2 = null;
            number2 = dynamicTableModel.getValueAt(n2, n3) instanceof Number ? (Number)((Number)dynamicTableModel.getValueAt(n2, n3)) : (Number)-1;
            double d2 = ((Number)number2).doubleValue();
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
        if (clazz == java.util.Date.class || clazz == Date.class) {
            java.util.Date date;
            long l;
            java.util.Date date2 = (java.util.Date)dynamicTableModel.getValueAt(n, n3);
            long l2 = date2.getTime();
            if (l2 < (l = (date = (java.util.Date)dynamicTableModel.getValueAt(n2, n3)).getTime())) {
                return -1;
            }
            if (l2 > l) {
                return 1;
            }
            return 0;
        }
        if (clazz == SelectWavelengthPanelStep.WavelengthClass.class || clazz == SelectSamplePanelStep.SampleClass.class) {
            BreezeIndexIntervalClass breezeIndexIntervalClass = (BreezeIndexIntervalClass)dynamicTableModel.getValueAt(n, n3);
            BreezeIndexIntervalClass breezeIndexIntervalClass2 = (BreezeIndexIntervalClass)dynamicTableModel.getValueAt(n2, n3);
            return Integer.compare(breezeIndexIntervalClass.getIndex(), breezeIndexIntervalClass2.getIndex());
        }
        if (clazz == String.class) {
            String string2;
            String string3 = (String)dynamicTableModel.getValueAt(n, n3);
            int n4 = string3.compareToIgnoreCase(string2 = (String)dynamicTableModel.getValueAt(n2, n3));
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }
        if (clazz == Boolean.class) {
            Boolean bl;
            Boolean bl2;
            Boolean bl3 = (Boolean)dynamicTableModel.getValueAt(n, n3);
            Boolean bl4 = bl3;
            if (bl4 == (bl2 = (bl = (Boolean)dynamicTableModel.getValueAt(n2, n3)))) {
                return 0;
            }
            if (bl4.booleanValue()) {
                return 1;
            }
            return -1;
        }
        if (clazz == Sample.class || clazz == RootSample.class) {
            Sample sample = BreezeTableSorter.getSample(dynamicTableModel, n, n3);
            Sample sample2 = BreezeTableSorter.getSample(dynamicTableModel, n2, n3);
            return BreezeTableSorter.compareSamples(sample, sample2);
        }
        if (clazz == Identifier.class) {
            Identifier identifier = (Identifier)dynamicTableModel.getValueAt(n, n3);
            Sample sample = BreezeTableSorter.getSample(dynamicTableModel, n);
            Sample sample3 = BreezeTableSorter.getSample(dynamicTableModel, n2);
            String string4 = identifier.getTextValue(sample);
            String string5 = identifier.getTextValue(sample3);
            if (string4 != null && string5 != null) {
                return BreezeTableSorter.compareIdentifiers(string4, string5);
            }
            return 0;
        }
        if (Factor.class.isAssignableFrom(clazz)) {
            return ((Factor)dynamicTableModel.getValueAt(n, n3)).compare(BreezeTableSorter.getSample(dynamicTableModel, n), BreezeTableSorter.getSample(dynamicTableModel, n2));
        }
        if (clazz == SelectSamplePanelStep.ClassificationFactor.class) {
            return ((SelectSamplePanelStep.ClassificationFactor)dynamicTableModel.getValueAt(n, n3)).compare(BreezeTableSorter.getSample(dynamicTableModel, n), BreezeTableSorter.getSample(dynamicTableModel, n2));
        }
        if (FunctionResult.class.isAssignableFrom(clazz)) {
            return Float.compare(BreezeTableSorter.getValue(dynamicTableModel, n, n3), BreezeTableSorter.getValue(dynamicTableModel, n2, n3));
        }
        Object object4 = dynamicTableModel.getValueAt(n, n3);
        String string6 = object4.toString();
        int n5 = string6.compareToIgnoreCase(string = (object = dynamicTableModel.getValueAt(n2, n3)).toString());
        if (n5 < 0) {
            return -1;
        }
        if (n5 > 0) {
            return 1;
        }
        return 0;
    }

    public static int compareIdentifiers(String string, String string2) {
        if (RtDataFormat.isNumber(string) && RtDataFormat.isNumber(string2)) {
            return Double.compare(RtDataFormat.toNumber(string), RtDataFormat.toNumber(string2));
        }
        return string.compareToIgnoreCase(string2);
    }

    private static Sample getSample(BreezeTableModel breezeTableModel, int n) {
        return Sample.getSample(breezeTableModel.getObjectAt(n));
    }

    private static Sample getSample(BreezeTableModel breezeTableModel, int n, int n2) {
        return Sample.getSample(breezeTableModel.getValueAt(n, n2));
    }

    private static float getValue(BreezeTableModel breezeTableModel, int n, int n2) {
        return ((FunctionResult)breezeTableModel.getValueAt(n, n2)).getValue();
    }

    public static int compareSamples(Sample sample, Sample sample2) {
        Measurement measurement;
        Group group;
        Measurement measurement2 = sample.measurement();
        Group group2 = measurement2.getParent();
        if (group2 != (group = (measurement = sample2.measurement()).getParent())) {
            return group.getEntryData().compareTo(ListHelper.SortType.Created, group2.getEntryData());
        }
        if (measurement2 != measurement) {
            return measurement2.getEntryData().compareTo(ListHelper.SortType.Created, measurement.getEntryData());
        }
        return BreezeTableSorter.compareSamplesRecursive(sample, sample2);
    }

    private static int compareSamplesRecursive(BasicSample basicSample, BasicSample basicSample2) {
        BasicSample basicSample3 = basicSample.getParent();
        BasicSample basicSample4 = basicSample2.getParent();
        if (basicSample3 != null && basicSample4 != null) {
            if (basicSample3 != basicSample4) {
                return BreezeTableSorter.compareSamplesRecursive(basicSample3, basicSample4);
            }
            long l = basicSample.getIndex();
            long l2 = basicSample2.getIndex();
            return Double.compare(l, l2);
        }
        return 0;
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    @Override
    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            int[] nArray = this.indexes;
            if (n < nArray.length) {
                this.checkModel();
                return this.model.getValueAt(nArray[n], n2);
            }
        }
        catch (Exception exception) {
            Logg.warn((String)("Cannot get model value: " + exception.getMessage()), (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public boolean isSortedColumnAscending() {
        return this.ascending;
    }

    public void performSort() {
        this.sortByColumn(this.sortedColumnIndex, this.ascending);
    }

    public void performSort(JTable jTable) {
        this.saveSelectedIndices(jTable);
        this.performSort();
        this.reselectIndices(jTable);
    }

    public void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.indexes[i] = i;
        }
    }

    public void setComparatorForColumn(int n, Comparator comparator) {
        if (this.comparatorMap == null) {
            this.comparatorMap = new HashMap();
        }
        this.comparatorMap.put(n, comparator);
    }

    @Override
    public void setModel(DynamicTableModel dynamicTableModel) {
        super.setModel(dynamicTableModel);
        this.reallocateIndexes();
    }

    public void setValuesAt(Object object, int[] nArray, int n) {
        if (nArray.length > 0) {
            this.checkModel();
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.indexes[nArray[i]];
            }
            this.model.setValuesAt(object, nArray2, n);
            if (n == this.sortedColumnIndex) {
                this.sortByColumn(this.sortedColumnIndex, this.ascending);
            }
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n], n2);
        if (n2 == this.sortedColumnIndex) {
            this.sortByColumn(this.sortedColumnIndex, this.ascending);
        }
    }

    public void setValueAt(Object object, int n, int n2, boolean bl) {
        this.checkModel();
        this.model.setValueAt(object, this.indexes[n], n2, bl);
        this.sortByColumn(this.sortedColumnIndex, this.ascending);
    }

    public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            if (n2 - n >= 0) {
                System.arraycopy(nArray, n, nArray2, n, n2 - n);
            }
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    public void sort() {
        this.checkModel();
        this.compares = 0;
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    @Override
    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortedColumnIndex = n;
        this.sort();
        super.tableChanged(new TableModelEvent(this));
    }

    public boolean isAscending() {
        return this.ascending;
    }

    protected void reselectIndices(JTable jTable) {
    }

    protected void saveSelectedIndices(JTable jTable) {
    }

    private boolean isEmptyRow(int n) {
        block5: {
            try {
                if (n < 0 || n >= this.model.getRowCount()) {
                    return true;
                }
                for (int i = 0; i < this.model.getColumnCount(); ++i) {
                    Class clazz = this.model.getColumnClass(i);
                    Object object = this.model.getValueAt(n, i);
                    if (object == null) continue;
                    if (clazz == String.class) {
                        if (object.equals("")) continue;
                        return false;
                    }
                    return false;
                }
            }
            catch (Exception exception) {
                if (!WorkspaceManager.logError()) break block5;
                Logg.warn((String)("Exception on empty row: " + exception.getMessage()), (Object[])new Object[0]);
            }
        }
        return true;
    }
}

