/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableSorter;
import se.prediktera.breeze.test.MockBreezePropertiesAndMasterCache;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

public class BreezeTableSorterTest
extends MockBreezePropertiesAndMasterCache {
    @Test
    public void compareSamplesSameGroup() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        Measurement measurement = this.createMeasurement(workflowWithoutIO);
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
        measurement.getParent().addChild(measurementWithoutIO);
        measurementWithoutIO.replaceRootSample(new RootSample());
        measurement.getEntryData().setCreatedDate(new Date(100L));
        measurementWithoutIO.getEntryData().setCreatedDate(new Date(200L));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareSamples(measurement.getRootSample(), measurementWithoutIO.getRootSample()), (Matcher)Matchers.is((Object)-1));
        measurement.getEntryData().setCreatedDate(new Date(300L));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareSamples(measurement.getRootSample(), measurementWithoutIO.getRootSample()), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void compareSamplesDifferentGroups() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        Measurement measurement = this.createMeasurement(workflowWithoutIO);
        measurement.getParent().getEntryData().setCreatedDate(new Date(100L));
        Measurement measurement2 = this.createMeasurement(workflowWithoutIO);
        measurement2.getParent().getEntryData().setCreatedDate(new Date(200L));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareSamples(measurement.getRootSample(), measurement2.getRootSample()), (Matcher)Matchers.is((Object)1));
        measurement.getParent().getEntryData().setCreatedDate(new Date(300L));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareSamples(measurement.getRootSample(), measurement2.getRootSample()), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void compareIndentifiers() {
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareIdentifiers("A", "A"), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareIdentifiers("B", "A"), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareIdentifiers("A", "B"), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareIdentifiers("1", "2"), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareIdentifiers("9", "10"), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)BreezeTableSorter.compareIdentifiers("10", "9"), (Matcher)Matchers.is((Object)1));
    }

    private Measurement createMeasurement(Workflow workflow) {
        GroupWithoutIO groupWithoutIO = new GroupWithoutIO();
        workflow.addChild(groupWithoutIO);
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO();
        groupWithoutIO.addChild(measurementWithoutIO);
        measurementWithoutIO.replaceRootSample(new RootSample());
        return measurementWithoutIO;
    }
}

