/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.SampleVariableOrIdentifier;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.swing.table.ValueCellInterface;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.Logg;

public class DynamicTableModel
extends DefaultTableModel
implements BreezeTableModel {
    private boolean editable;
    private final List<Color> headerColor;

    public DynamicTableModel(Vector vector, List<Color> list, boolean bl) {
        super(new Vector(), vector);
        this.headerColor = list;
        this.editable = bl;
    }

    @Override
    public void addRow(Object object, Vector vector) {
        this.addRow(new ObjectVector(object, vector));
    }

    public Class getColumnClass(int n) {
        block4: {
            try {
                int n2 = this.getRowCount();
                if (n < this.getColumnCount()) {
                    for (int i = 0; n2 > i; ++i) {
                        Object object = this.getValueAt(i, n);
                        if (object == null) continue;
                        return object.getClass();
                    }
                }
            }
            catch (Exception exception) {
                if (!WorkspaceManager.logError()) break block4;
                Logg.error((String)"Exception when finding class", (Throwable)exception);
            }
        }
        return Object.class;
    }

    @Override
    public Object getObjectAt(int n) {
        Vector<Vector> vector = this.getDataVector();
        if (n < vector.size()) {
            Vector vector2 = vector.elementAt(n);
            if (vector2 instanceof ObjectVector) {
                return ((ObjectVector)vector2).object;
            }
            return vector2;
        }
        return null;
    }

    @Override
    public HashMap<Object, Vector> getObjectVector() {
        HashMap<Object, Vector> hashMap = new HashMap<Object, Vector>();
        try {
            Vector<Vector> vector = this.getDataVector();
            for (int i = 0; i < vector.size(); ++i) {
                ObjectVector objectVector = (ObjectVector)vector.get(i);
                hashMap.put(objectVector.object, objectVector);
            }
        }
        catch (Exception exception) {
            Logg.error((String)"Error getting object vector", (Throwable)exception);
        }
        return hashMap;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.editable;
    }

    @Override
    public void removeAllRows() {
        Vector<Vector> vector = this.getDataVector();
        int n = vector.size();
        vector.clear();
        this.fireTableRowsDeleted(0, n);
    }

    @Override
    public void removeRow(int n) {
        super.removeRow(n);
    }

    @Override
    public void setValuesAt(Object object, int[] nArray, int n) {
        block16: {
            Object object2;
            block14: {
                block17: {
                    block15: {
                        int n2 = nArray[0];
                        object2 = super.getValueAt(n2, n);
                        Object object3 = this.getObjectAt(n2);
                        if (!(object3 instanceof Sample)) break block14;
                        if (!(object2 instanceof SampleVariableOrIdentifier)) break block15;
                        HashSet<Measurement> hashSet = new HashSet<Measurement>();
                        for (int n3 : nArray) {
                            Sample sample = (Sample)this.getObjectAt(n3);
                            sample.setSampleVariableOrIdentifier((SampleVariableOrIdentifier)object2, object.toString());
                            hashSet.add(sample.measurement());
                        }
                        Object object4 = null;
                        for (Measurement measurement : hashSet) {
                            if (object4 == null) {
                                object4 = measurement.getWorkflow();
                                ((Workflow)object4).save();
                            }
                            measurement.save();
                        }
                        break block16;
                    }
                    if (!(object2 instanceof Sample)) break block17;
                    HashSet<Measurement> hashSet = new HashSet<Measurement>();
                    for (int n4 : nArray) {
                        Sample sample = (Sample)super.getValueAt(n4, n);
                        hashSet.add(sample.measurement());
                    }
                    Object object5 = hashSet.iterator();
                    while (object5.hasNext()) {
                        Measurement measurement = (Measurement)object5.next();
                        try {
                            measurement.rename(object.toString());
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                    }
                    break block16;
                }
                if (!(object2 instanceof FunctionResult)) break block16;
                if (object.equals("update")) {
                    HashSet<Measurement> hashSet = new HashSet<Measurement>();
                    for (int n5 : nArray) {
                        Sample sample = (Sample)this.getObjectAt(n5);
                        ((FunctionResult)super.getValueAt(n5, n)).setPredictionValueToFactor(sample);
                        hashSet.add(sample.measurement());
                    }
                    Object object6 = hashSet.iterator();
                    while (object6.hasNext()) {
                        Measurement measurement = (Measurement)object6.next();
                        measurement.save();
                    }
                } else {
                    boolean bl = object.equals("train");
                    boolean bl2 = bl || object.equals("test");
                    for (int n6 : nArray) {
                        Sample sample = (Sample)this.getObjectAt(n6);
                        ((FunctionResult)super.getValueAt(n6, n)).setValue(sample, bl2, bl);
                    }
                }
                break block16;
            }
            if (object2 instanceof ValueCellInterface) {
                double d = NiceDataFormat.toNumber((String)object.toString());
                for (int n7 : nArray) {
                    ((ValueCellInterface)super.getValueAt(n7, n)).setValue(d);
                }
            }
        }
    }

    @Override
    public final void setValueAt(Object object, int n, int n2) {
        Object object2 = super.getValueAt(n, n2);
        Object object3 = this.getObjectAt(n);
        if (object3 instanceof Sample) {
            Sample sample = (Sample)object3;
            if (object2 instanceof SampleVariableOrIdentifier) {
                sample.setSampleVariableOrIdentifier((SampleVariableOrIdentifier)object2, object.toString());
                sample.measurement().save();
                sample.measurement().getWorkflow().save();
            } else if (object2 instanceof Sample) {
                try {
                    ((Sample)object2).measurement().rename(object.toString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        } else if (object2 instanceof ValueCellInterface) {
            ((ValueCellInterface)object2).setValue(NiceDataFormat.toNumber((String)object.toString()));
        }
    }

    @Override
    public final void setValueAt(Object object, int n, int n2, boolean bl) {
        Object object2 = super.getValueAt(n, n2);
        Object object3 = this.getObjectAt(n);
        if (object3 instanceof Sample) {
            Sample sample = (Sample)object3;
            if (object2 instanceof Factor) {
                ((Factor)object2).setValue(object.toString(), sample);
            }
            if (object2 instanceof Identifier) {
                sample.setID((Identifier)object2, object.toString());
            }
            if (object2 instanceof Measurement) {
                try {
                    sample.measurement().rename(object.toString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            sample.measurement().save();
            sample.measurement().getWorkflow().save();
        }
    }

    @Override
    public int indexOf(Object object) {
        Vector<Vector> vector = this.getDataVector();
        for (int i = 0; i < vector.size(); ++i) {
            if (!((ObjectVector)vector.get((int)i)).object.equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isSorting() {
        return false;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public Color getHeaderColor(int n) {
        try {
            if (this.headerColor != null && n < this.headerColor.size()) {
                return this.headerColor.get(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static class ObjectVector
    extends Vector {
        public final Object object;

        public ObjectVector(Object object, Vector vector) {
            super(vector);
            this.object = object;
        }
    }
}

