/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Dimension;
import java.util.List;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;

public class LimitInputField
extends BreezeComboBoxInputField<LimitConfiguration> {
    private boolean updating = false;
    private LimitChanged listener;

    public LimitInputField(BreezeTable breezeTable) {
        super("Limit");
        this.getComboBox().setMinimumSize(new Dimension(50, 26));
        this.getComboBox().setPreferredSize(new Dimension(180, 26));
        this.setChangedListener(limitConfiguration -> {
            if (!this.updating) {
                LimitConfiguration limitConfiguration2 = (LimitConfiguration)this.getSelectedItem();
                if (this.listener != null) {
                    this.listener.onChange(limitConfiguration2);
                }
            }
        });
    }

    public void setListener(LimitChanged limitChanged) {
        this.listener = limitChanged;
    }

    public void updateLimits(BreezeTable breezeTable, Workflow workflow, Group group) {
        this.updating = true;
        this.removeAllItems();
        VisualisationNode visualisationNode = workflow.getVisualisationNode();
        if (visualisationNode != null) {
            List<LimitConfiguration> list = visualisationNode.getLimitList();
            for (LimitConfiguration limitConfiguration : list) {
                this.addItem(limitConfiguration);
            }
            LimitConfiguration limitConfiguration = visualisationNode.getDefaultLimitNode(group);
            if (limitConfiguration != null) {
                this.setSelectedItem(limitConfiguration);
            }
            if (!list.isEmpty()) {
                breezeTable.setLimitNode((LimitConfiguration)this.getSelectedItem(), false);
            } else {
                breezeTable.setLimitNode(null, false);
            }
            this.setEnabled(this.getItemCount() > 1);
        } else {
            this.setEnabled(false);
        }
        this.setVisible(this.getItemCount() > 0);
        this.updating = false;
    }

    public static interface LimitChanged {
        public void onChange(LimitConfiguration var1);
    }
}

