/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;

public class SegmentationPanel
extends JPanel {
    private boolean updating;
    private boolean updatingSegmentations = false;
    private final BreezeComboBoxInputField segmentationComboBox = new BreezeComboBoxInputField("Segmentation");
    private final BreezeComboBoxInputField segmentationIdComboBox = new BreezeComboBoxInputField(" ");
    private VisualisationNode visualisationNode;
    private SegmentationChanged listener;

    public SegmentationPanel() {
        this(BreezeInputFieldHelper.Format.OneRow, null);
    }

    public SegmentationPanel(BreezeInputFieldHelper.Format format, SegmentationChanged segmentationChanged) {
        super(new GridBagLayout());
        this.listener = segmentationChanged;
        this.setOpaque(false);
        this.segmentationComboBox.setFormat(format);
        this.segmentationComboBox.getComboBox().setMinimumSize(new Dimension(100, 26));
        this.segmentationComboBox.getComboBox().setPreferredSize(new Dimension(200, 26));
        this.segmentationComboBox.setRenderer(new BreezeTablePanel.FunctionCellRenderer());
        this.segmentationIdComboBox.setFormat(format);
        this.segmentationIdComboBox.getComboBox().setMinimumSize(new Dimension(50, 26));
        this.segmentationIdComboBox.getComboBox().setPreferredSize(new Dimension(150, 26));
        this.segmentationIdComboBox.setRenderer(new BreezeTablePanel.FunctionCellRenderer());
        this.segmentationComboBox.setChangedListener(object -> {
            if (!this.updating) {
                this.updateSegmentationHashIds();
                this.segmentationIdComboBoxItemStateChanged(object);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.segmentationComboBox, gridBagConstraints);
        this.segmentationIdComboBox.setChangedListener(object -> this.segmentationIdComboBoxItemStateChanged(object));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.segmentationIdComboBox, gridBagConstraints);
    }

    public void setListener(SegmentationChanged segmentationChanged) {
        this.listener = segmentationChanged;
    }

    public void updateSegmentations(Workflow workflow) {
        this.updating = true;
        this.segmentationComboBox.removeAllItems();
        if (workflow != null) {
            this.visualisationNode = workflow.getVisualisationNode();
            if (this.visualisationNode != null) {
                FunctionTreeNode functionTreeNode = workflow.getRoot();
                this.segmentationComboBox.addItem(functionTreeNode);
                for (SegmentationNodeList segmentationNodeList : SegmentationNode.getSegmentationLists(functionTreeNode)) {
                    this.segmentationComboBox.addItem(segmentationNodeList);
                }
                if (workflow.getSegmentationLevel() < this.segmentationComboBox.getItemCount()) {
                    this.setSegmentationLevel(workflow.getSegmentationLevel());
                }
                this.segmentationComboBox.setEnabled(this.segmentationComboBox.getItemCount() > 1);
            } else {
                this.segmentationComboBox.setEnabled(false);
            }
        } else {
            this.segmentationComboBox.setEnabled(false);
        }
        this.updateSegmentationHashIds();
        this.updating = false;
    }

    public void setSegmentationLevel(int n) {
        if (n < this.segmentationComboBox.getItemCount()) {
            this.segmentationComboBox.setSelectedIndex(n);
        }
    }

    public void setSegmentationHashId(String string) {
        Object object = "All";
        if (string != null) {
            for (int i = 1; i < this.segmentationIdComboBox.getItemCount(); ++i) {
                SegmentationNode segmentationNode;
                Object t = this.segmentationIdComboBox.getItemAt(i);
                if (!(t instanceof SegmentationNode) || !(segmentationNode = (SegmentationNode)t).getUid().equals(string)) continue;
                object = segmentationNode;
            }
        }
        this.segmentationIdComboBox.setSelectedItem(object);
    }

    private void updateSegmentationHashIds() {
        this.updatingSegmentations = true;
        this.segmentationIdComboBox.removeAllItems();
        Object t = this.segmentationComboBox.getSelectedItem();
        if (this.visualisationNode != null && t instanceof SegmentationNodeList) {
            SegmentationNodeList segmentationNodeList = (SegmentationNodeList)t;
            Workflow workflow = this.visualisationNode.getWorkflow();
            String string = workflow.getSegmentationHashId();
            Object object = "All";
            this.segmentationIdComboBox.addItem(object);
            if (segmentationNodeList.size() > 1) {
                for (SegmentationNode segmentationNode : segmentationNodeList) {
                    this.segmentationIdComboBox.addItem(segmentationNode);
                    if (!segmentationNode.getUid().equals(string)) continue;
                    object = segmentationNode;
                }
            }
            this.segmentationIdComboBox.setSelectedItem(object);
            if ("All".equals(object) && string != null) {
                this.visualisationNode.clearSegmentationHashId();
            }
        }
        this.segmentationIdComboBox.setVisible(this.segmentationIdComboBox.getItemCount() > 1);
        this.updatingSegmentations = false;
    }

    private void segmentationIdComboBoxItemStateChanged(Object object) {
        if (!this.updating && !this.updatingSegmentations) {
            int n = this.getSegmentationLevel();
            String string = this.getSegmentationHashId();
            boolean bl = this.visualisationNode.getSegmentationLevel() != n || this.visualisationNode.getSegmentationHashId() != string;
            this.visualisationNode.setSegmentationLevel(n, string);
            this.visualisationNode.save();
            if (this.listener != null) {
                this.listener.onChange(bl);
            }
        }
    }

    public int getSegmentationLevel() {
        FunctionTreeNode functionTreeNode;
        Object t = this.segmentationComboBox.getSelectedItem();
        if (t instanceof SegmentationNodeList) {
            SegmentationNodeList segmentationNodeList = (SegmentationNodeList)t;
            return segmentationNodeList.getSegmentationLevel();
        }
        if (t instanceof FunctionTreeNode && (functionTreeNode = (FunctionTreeNode)t) != null) {
            return SegmentationNode.getSegmentationLevel(functionTreeNode);
        }
        return 0;
    }

    public String getSegmentationHashId() {
        Object t = this.segmentationIdComboBox.getSelectedItem();
        if (t instanceof SegmentationNode) {
            return ((SegmentationNode)t).getUid();
        }
        return null;
    }

    public BreezeComboBoxInputField getSegmentationComboBox() {
        return this.segmentationComboBox;
    }

    public BreezeComboBoxInputField getSegmentationIdComboBox() {
        return this.segmentationIdComboBox;
    }

    public static interface SegmentationChanged {
        public void onChange(boolean var1);
    }
}

