/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableSorter;
import se.prediktera.breeze.frontend.common.swing.table.DynamicTableModel;

public class SortedTableModel
extends BreezeTableSorter
implements BreezeTableModel {
    private Object[] selectedIndices;
    private Object anchorObj = null;
    private boolean sorting = false;
    private HashMap<Object, Integer> indexHashMap;

    public SortedTableModel(DynamicTableModel dynamicTableModel) {
        this.setModel(dynamicTableModel);
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(this){
            final /* synthetic */ SortedTableModel this$0;
            {
                this.this$0 = sortedTableModel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (jTable2.getTableHeader().getResizingColumn() != null || jTable2.isEditing() && !jTable2.getCellEditor().stopCellEditing()) {
                        return;
                    }
                    TableColumnModel tableColumnModel = jTable2.getColumnModel();
                    int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                    int n2 = jTable2.convertColumnIndexToModel(n);
                    if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                        this.this$0.ascending = n2 != this.this$0.sortedColumnIndex ? true : !this.this$0.ascending;
                        this.this$0.sortColumn(jTable2, n2, this.this$0.ascending);
                    }
                }
            }
        };
        jTable.getTableHeader().addMouseListener(mouseAdapter);
    }

    public void sortColumn(JTable jTable, int n, boolean bl) {
        this.sorting = true;
        this.saveSelectedIndices(jTable);
        this.sortByColumn(n, bl);
        this.reselectIndices(jTable);
        jTable.getTableHeader().repaint();
        this.sorting = false;
    }

    @Override
    public void sort() {
        super.sort();
        this.indexSamples();
    }

    @Override
    public void addRow(Object object, Vector vector) {
        this.model.addRow(object, vector);
    }

    @Override
    public Object getObjectAt(int n) {
        this.checkModel();
        if (n >= 0 && n < this.indexes.length) {
            return this.model.getObjectAt(this.indexes[n]);
        }
        return null;
    }

    @Override
    public HashMap<Object, Vector> getObjectVector() {
        return this.model.getObjectVector();
    }

    @Override
    public int indexOf(Object object) {
        Integer n = this.indexHashMap.get(object);
        if (n != null) {
            return n;
        }
        return -1;
    }

    @Override
    public void removeAllRows() {
        this.checkModel();
        this.model.removeAllRows();
        this.reallocateIndexes();
    }

    @Override
    protected void reselectIndices(JTable jTable) {
        if (this.selectedIndices == null || this.selectedIndices.length == 0) {
            return;
        }
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        for (Object object : this.selectedIndices) {
            int n = this.indexOf(object);
            if (jTable.getRowCount() <= n) continue;
            listSelectionModel.addSelectionInterval(n, n);
        }
        if (this.anchorObj != null && jTable.getRowCount() > this.indexOf(this.anchorObj)) {
            listSelectionModel.setAnchorSelectionIndex(this.indexOf(this.anchorObj));
        }
    }

    private void indexSamples() {
        int[] nArray = this.indexes;
        this.indexHashMap = new HashMap();
        Vector<Vector> vector = this.model.getDataVector();
        int n = Math.min(nArray.length, vector.size());
        for (int i = 0; i < n; ++i) {
            this.indexHashMap.put(((DynamicTableModel.ObjectVector)vector.get((int)nArray[i])).object, i);
        }
    }

    @Override
    protected void saveSelectedIndices(JTable jTable) {
        int[] nArray = jTable.getSelectedRows();
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        int n = listSelectionModel.getAnchorSelectionIndex();
        if (n < 0) {
            return;
        }
        if (jTable.getRowCount() > n) {
            this.anchorObj = this.getObjectAt(n);
        }
        if (nArray == null || nArray.length == 0) {
            return;
        }
        this.selectedIndices = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.selectedIndices[i] = this.getObjectAt(nArray[i]);
        }
    }

    @Override
    public boolean isSorting() {
        return this.sorting;
    }

    @Override
    public Color getHeaderColor(int n) {
        return this.model.getHeaderColor(n);
    }
}

