/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.editor;

import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.realtime.unmixing.SelectMembersPanel;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.table.editor.DefaultComponentCellEditor;

public class CategoryCellEditor
extends DefaultComponentCellEditor {
    private final BreezeComboBox comboBox = new BreezeComboBox(false);
    private Sample sample;
    private CategoryFactor factor;

    public CategoryCellEditor() {
        this.comboBox.setName("categoryInput");
        this.comboBox.setRenderer(new SelectMembersPanel.CatClassListCellRenderer());
        this.comboBox.addActionListener(actionEvent -> {
            this.factor.setValue(this.comboBox.getSelectedItem().toString(), this.sample);
            this.stopCellEditing();
        });
    }

    @Override
    public final Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        jTable.getSelectionModel().setSelectionInterval(n, n);
        this.sample = this.getSampleAtRow(jTable, n);
        if (this.sample == null) {
            return null;
        }
        this.factor = (CategoryFactor)object;
        if (this.factor.isEditable()) {
            this.comboBox.setModel(new DefaultComboBoxModel<Object>(this.factor.getClasses().toArray()));
            Float f = this.sample.getVariableValue(this.factor);
            if (f != null && f.floatValue() > 0.0f) {
                this.comboBox.setSelectedIndex(f.intValue());
            } else {
                this.comboBox.setSelectedIndex(0);
            }
            return super.getTableCellEditorComponent(jTable, this.comboBox, bl, n, n2);
        }
        return super.getTableCellEditorComponent(jTable, null, bl, n, n2);
    }

    public BreezeComboBox getComboBox() {
        return this.comboBox;
    }
}

