/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.editor;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;

public class DefaultComponentCellEditor
implements TableCellEditor,
TreeCellEditor,
Serializable {
    private final EventListenerList listenerList = new EventListenerList();
    private transient ChangeEvent changeEvent = null;
    private int clickCountToStart = 2;
    private JComponent editorComponent = null;

    @Override
    public final void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public final void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public final Object getCellEditorValue() {
        return this.editorComponent;
    }

    public final Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int n) {
        this.clickCountToStart = n;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.editorComponent = (JComponent)object;
        return this.editorComponent;
    }

    @Override
    public final Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        jTree.convertValueToText(object, bl, bl2, bl3, n, false);
        this.editorComponent = (JComponent)object;
        return this.editorComponent;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public final void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public final boolean shouldSelectCell(EventObject eventObject) {
        if (this.editorComponent != null && eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (((MouseEvent)eventObject).getID() == 501) {
                Component component = SwingUtilities.getDeepestComponentAt(this.editorComponent, 3, 3);
                MouseEvent mouseEvent2 = new MouseEvent(component, 502, mouseEvent.getWhen() + 100000L, mouseEvent.getModifiersEx(), 3, 3, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                component.dispatchEvent(mouseEvent2);
                mouseEvent2 = new MouseEvent(component, 500, mouseEvent.getWhen() + 100001L, mouseEvent.getModifiersEx(), 3, 3, 1, mouseEvent.isPopupTrigger());
                component.dispatchEvent(mouseEvent2);
            }
        }
        return false;
    }

    @Override
    public final boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    private void fireEditingCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
        }
    }

    private void fireEditingStopped() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
    }

    protected Sample getSampleAtRow(JTable jTable, int n) {
        Object object = ((BreezeTableModel)((Object)jTable.getModel())).getObjectAt(n);
        if (object instanceof Sample) {
            return (Sample)object;
        }
        return null;
    }
}

