/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;

public class BreezeIntervalTableCellRenderer
extends BreezeTableCellRenderer
implements TableCellRenderer {
    private static final int insets = 20;
    private static final Color disabledColor = new Color(25, 25, 25, 100);
    private static final BasicStroke doubleStroke = new BasicStroke(2.0f, 2, 0, 10.0f);
    private Color intervalColor;
    protected boolean firstRow;
    protected boolean lastRow;
    protected boolean uinc;
    protected boolean inc;
    protected boolean linc;
    protected boolean paintBars = true;
    protected boolean isIncluded = true;

    public BreezeIntervalTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null) {
            this.setText(object.toString());
        }
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        BreezeIntervalClass breezeIntervalClass = (BreezeIntervalClass)object;
        if (breezeIntervalClass != null) {
            this.intervalColor = breezeIntervalClass.getIntervalColor();
            this.isIncluded = breezeIntervalClass.getParent() != null ? breezeIntervalClass.getParent().isIncluded() : true;
            this.inc = breezeIntervalClass.isIncluded();
            this.firstRow = n <= 0;
            this.uinc = this.firstRow ? false : ((BreezeIntervalClass)jTable.getValueAt(n - 1, n2)).isIncluded();
            this.lastRow = n >= jTable.getRowCount() - 1;
            this.linc = this.lastRow ? false : ((BreezeIntervalClass)jTable.getValueAt(n + 1, n2)).isIncluded();
        }
        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.paintBars) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth() - 20;
        int n2 = n - 20;
        int n3 = n2 / 2 + 20;
        int n4 = this.getHeight();
        Stroke stroke = graphics2D.getStroke();
        if (this.inc) {
            graphics2D.setColor(this.isIncluded ? this.intervalColor : disabledColor);
        }
        if (this.inc) {
            graphics2D.fillRect(20, 0, n2, n4);
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(20, 0, 20, n4);
            graphics2D.drawLine(n, 0, n, n4);
            graphics2D.setColor(Color.lightGray);
            graphics2D.drawLine(n + 1, 0, n + 1, n4);
            graphics2D.setStroke(doubleStroke);
            if (!this.uinc) {
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(21, 0, n - 1, 0);
                graphics2D.drawLine(n3 - 3, 1, n3, 3);
                graphics2D.drawLine(n3, 3, n3 + 3, 1);
            }
            if (!this.linc) {
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(n3 - 3, n4 - 1, n3, n4 - 4);
                graphics2D.drawLine(n3, n4 - 4, n3 + 3, n4 - 1);
                graphics2D.drawLine(21, n4 - 1, n - 1, n4 - 1);
            }
        }
        graphics2D.setStroke(stroke);
    }
}

