/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.table.BreezeCellBorder;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTableModel;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.cleanup.CleanUpInterface;
import se.prediktera.map.common.error.Logg;

public class BreezeTableCellRenderer
extends DefaultTableCellRenderer
implements CleanUpInterface {
    private int vertCellAlign = 0;
    private final JTextArea area = new JTextArea();
    private final SimpleDateFormat simpleDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss");
    private Font font;
    private boolean cleaned = false;

    public BreezeTableCellRenderer() {
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
        this.area.setOpaque(true);
        this.setFontSize(16);
        this.setHorizontalAlignment(0);
    }

    public void setFontSize(int n) {
        this.font = new Font("Tahoma", 0, n);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        boolean bl3 = true;
        boolean bl4 = false;
        if (jTable instanceof BreezeTable) {
            object3 = (BreezeTable)((Object)jTable);
            bl3 = ((BreezeTable)((Object)object3)).isRowFocusEnabled();
            bl4 = ((BreezeTable)((Object)object3)).isColFocusEnabled();
        }
        object3 = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, !bl3 && bl2, n, n2);
        ((JComponent)object3).setFont(this.font);
        Object object4 = jTable.getValueAt(n, 0);
        if (object4 instanceof BreezeIntervalClass) {
            object2 = (BreezeIntervalClass)object4;
            ((JComponent)object3).setForeground(((BreezeIntervalClass)object2).isIncluded() ? BreezeTheme.getInstance().getLabelForeground() : Color.gray);
        }
        if (jTable.hasFocus()) {
            if (bl3 && !bl4 && n == jTable.getSelectionModel().getAnchorSelectionIndex()) {
                if (n2 == 0) {
                    ((JComponent)object3).setBorder(new BreezeCellBorder(true, false, true, true));
                } else if (n2 == jTable.getColumnCount() - 1) {
                    ((JComponent)object3).setBorder(new BreezeCellBorder(false, true, true, true));
                } else {
                    ((JComponent)object3).setBorder(new BreezeCellBorder(false, false, true, true));
                }
            } else if (bl4 && !bl3 && n2 == jTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex()) {
                if (n == 0) {
                    ((JComponent)object3).setBorder(new BreezeCellBorder(true, true, true, false));
                } else if (n == jTable.getRowCount() - 1) {
                    ((JComponent)object3).setBorder(new BreezeCellBorder(true, true, false, true));
                } else {
                    ((JComponent)object3).setBorder(new BreezeCellBorder(true, true, false, false));
                }
            } else if (bl2 && bl4 && bl3) {
                ((JComponent)object3).setBorder(new BreezeCellBorder(true, true, true, true));
            } else {
                ((JComponent)object3).setBorder(new BreezeCellBorder(false, false, false, false));
            }
        }
        if (object instanceof Number) {
            if (object instanceof Double) {
                ((JLabel)object3).setText(NiceDataFormat.toString((double)((Double)object)));
            } else if (object instanceof Float) {
                ((JLabel)object3).setText(NiceDataFormat.toString((double)((Float)object).doubleValue()));
            }
        }
        if (object instanceof BigDecimal) {
            object2 = (BigDecimal)object;
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.setMinimumFractionDigits(((BigDecimal)object2).scale());
            ((JLabel)object3).setText(decimalFormat.format(object2));
        }
        ((JLabel)object3).setVerticalAlignment(this.vertCellAlign);
        if (object instanceof Date) {
            ((JLabel)object3).setText(this.simpleDateFormatter.format((Date)object));
        }
        if (object instanceof Timestamp) {
            ((JLabel)object3).setText(this.timestampFormatter.format((Timestamp)object));
        }
        if (object instanceof StringBuffer) {
            this.area.setText(((JLabel)object3).getText());
            this.area.setBackground(((Component)object3).getBackground());
            this.area.setForeground(((Component)object3).getForeground());
            this.area.setBorder(((JComponent)object3).getBorder());
            this.area.setSize(jTable.getColumnModel().getColumn(n2).getWidth() - 1, Integer.MAX_VALUE);
            int n3 = (int)this.area.getPreferredSize().getHeight();
            if (n3 != jTable.getRowHeight(n)) {
                jTable.setRowHeight(n, n3);
            }
            return this.area;
        }
        return object3;
    }

    public void setVerticalCellAlignment(int n) {
        this.vertCellAlign = n;
    }

    public boolean cleanUp() {
        this.cleaned = true;
        return false;
    }

    public boolean isCleaned() {
        return this.cleaned;
    }

    public static List<Sample> getSamples(JTable jTable) {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            arrayList.add(BreezeTableCellRenderer.getSampleAt(jTable, i));
        }
        return arrayList;
    }

    public static Sample getSampleAt(JTable jTable, int n) {
        try {
            Object object = ((BreezeTableModel)((Object)jTable.getModel())).getObjectAt(n);
            return Sample.getSample(object);
        }
        catch (Exception exception) {
            Logg.warn((String)"Exception finding object", (Object[])new Object[]{exception});
            return null;
        }
    }

    protected int getSegmentationLevel(JTable jTable) {
        AbstractViewPanel abstractViewPanel = ((BreezeTable)((Object)jTable)).getTablePanel().getAbstractViewPanel();
        if (abstractViewPanel != null) {
            return abstractViewPanel.getSegmentationLevel();
        }
        return 0;
    }
}

