/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import se.prediktera.breeze.common.util.thread.BreezeThread;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.ImageRenderPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.renderer.BreezeTableCellRenderer;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.error.Logg;

public class ThumbnailCellRenderer
extends BreezeTableCellRenderer {
    private final ThumbnailPanel panel = new ThumbnailPanel();
    private final RenderQueue renderQueue = new RenderQueue();
    private final ImageIcon applyChangesIcon = ImageHelper.getResourceIcon("applychanges");
    private JTable table;
    private LimitConfiguration limitNode;
    private Thumbnail thumbnail;
    private static int loadIndex = 0;
    private static boolean taskScheduled;
    private final SwingTimer repaintTimer = new SwingTimer(10, actionEvent -> {
        if (this.table != null) {
            this.table.repaint();
        }
    });

    public ThumbnailCellRenderer() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this, "Center");
        this.panel.setBackground(Color.white);
        this.setOpaque(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.table = jTable;
        BreezeTable breezeTable = (BreezeTable)((Object)jTable);
        this.limitNode = breezeTable.getLimitNode();
        this.thumbnail = null;
        if (object instanceof Thumbnail) {
            this.thumbnail = (Thumbnail)((Object)object);
        }
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this.panel.setBackground(this.getBackground());
        return this.panel;
    }

    protected class ThumbnailPanel
    extends JPanel {
        protected ThumbnailPanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            ThumbnailCellRenderer.this.setIcon(null);
            if (ThumbnailCellRenderer.this.thumbnail != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (!ThumbnailCellRenderer.this.thumbnail.hasRendered()) {
                    ThumbnailCellRenderer.this.renderQueue.push(ThumbnailCellRenderer.this.thumbnail);
                    if (ThumbnailCellRenderer.this.thumbnail.isApplyChangesNeeded()) {
                        ThumbnailCellRenderer.this.setIcon(ThumbnailCellRenderer.this.applyChangesIcon);
                    } else if (!ThumbnailCellRenderer.this.thumbnail.hasError()) {
                        this.renderWaitingIcon(graphics2D);
                    }
                } else {
                    try {
                        ThumbnailCellRenderer.this.thumbnail.draw(graphics2D, this.getWidth(), this.getHeight());
                    }
                    catch (Exception exception) {
                        Logg.warn((String)"Cannot render image", (Object[])new Object[]{exception.getMessage()});
                    }
                }
            }
        }

        private void renderWaitingIcon(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            double d = this.getWidth();
            double d2 = this.getHeight();
            double d3 = Math.min(d / 2.0, d2);
            int n = (int)(d3 / 3.0);
            int n2 = (int)(d3 / 5.0);
            int n3 = (int)(d / 2.0 - (double)n - (double)(n2 / 2));
            int n4 = (int)(d2 / 2.0 - (double)(n2 / 2));
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
            graphics2D.fillOval(n3 + loadIndex * n, n4, n2, n2);
            for (int i = 0; i < 3; ++i) {
                graphics2D.drawOval(n3 + i * n, n4, n2, n2);
            }
            if (!taskScheduled) {
                taskScheduled = true;
                if (++loadIndex == 3) {
                    loadIndex = 0;
                }
                ImageRenderPanel.loadTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (ThumbnailCellRenderer.this.table != null) {
                            ThumbnailCellRenderer.this.table.repaint();
                        }
                        taskScheduled = false;
                    }
                }, 300L);
            }
        }
    }

    public class RenderQueue {
        private final PriorityQueue<Thumbnail> queue = new PriorityQueue<Thumbnail>(new Comparator<Thumbnail>(this){

            @Override
            public int compare(Thumbnail thumbnail, Thumbnail thumbnail2) {
                if (thumbnail != null && thumbnail2 != null) {
                    return Integer.compare(thumbnail.getMeasurementIndex(), thumbnail2.getMeasurementIndex());
                }
                if (thumbnail != null) {
                    return 1;
                }
                if (thumbnail2 != null) {
                    return -1;
                }
                return 0;
            }
        });
        private BreezeThread thread;

        public synchronized void push(Thumbnail thumbnail) {
            if (this.queue.contains((Object)thumbnail)) {
                return;
            }
            this.queue.add(thumbnail);
            this.startThreadIfNotRunning();
        }

        public synchronized Thumbnail getNextThumbnail() {
            return this.queue.poll();
        }

        private void startThreadIfNotRunning() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new BreezeThread(this.getClass().getName(), () -> {
                    Thumbnail thumbnail = this.getNextThumbnail();
                    while (thumbnail != null) {
                        thumbnail.render(ThumbnailCellRenderer.this.limitNode);
                        ThumbnailCellRenderer.this.repaintTimer.restart();
                        thumbnail = this.getNextThumbnail();
                    }
                });
                this.thread.start();
            }
        }
    }
}

