/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.thumbnail;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailSample;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;

public abstract class Thumbnail
extends CleanUpClass {
    private BufferedImage origImage = null;
    private boolean applyChangesNeeded;
    private static long lastError = 0L;
    private final int measurementIndex;

    protected Thumbnail(int n) {
        this.measurementIndex = n;
    }

    public final BufferedImage render(LimitConfiguration limitConfiguration) {
        block5: {
            if (this.origImage == null) {
                try {
                    this.applyChangesNeeded = false;
                    this.origImage = this.parseImage(limitConfiguration);
                    lastError = 0L;
                }
                catch (ThumbnailSample.NoMeasurementDataException | ErrorHandler.InformationMessageException throwable) {
                    lastError = System.currentTimeMillis();
                }
                catch (ThumbnailHelper.ApplyChangesNeededException applyChangesNeededException) {
                    this.applyChangesNeeded = true;
                }
                catch (Exception exception) {
                    long l = System.currentTimeMillis() - lastError;
                    if (l <= 5000L) break block5;
                    Logg.error((String)"Image parse exception: ", (Throwable)exception);
                    lastError = System.currentTimeMillis();
                }
            }
        }
        return this.origImage;
    }

    public Factor getFactor() {
        return null;
    }

    public AbstractBreezeFunction getFunction() {
        return null;
    }

    protected abstract BufferedImage parseImage(LimitConfiguration var1);

    public abstract boolean equalTo(ThumbnailComboBox.ThumbnailWithDescriptor var1);

    public int getMeasurementIndex() {
        return this.measurementIndex;
    }

    protected final void cleanUpChild() {
        this.origImage = null;
    }

    public final void clearCache() {
        this.origImage = null;
    }

    public boolean hasRendered() {
        return this.origImage != null;
    }

    public boolean isApplyChangesNeeded() {
        return this.applyChangesNeeded;
    }

    public boolean hasError() {
        return lastError > 0L;
    }

    public final void draw(Graphics2D graphics2D, int n, int n2) {
        float f = (float)n / (float)this.origImage.getWidth(null);
        float f2 = (float)n2 / (float)this.origImage.getHeight(null);
        int n3 = n;
        int n4 = n2;
        if (f > f2) {
            n3 = (int)((float)n / f * f2);
        } else {
            n4 = (int)((float)n2 / f2 * f);
        }
        graphics2D.drawImage(this.origImage, n / 2 - n3 / 2, n2 / 2 - n4 / 2, n3, n4, null);
    }

    public final String toString() {
        return "";
    }
}

