/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.thumbnail;

import java.awt.image.BufferedImage;
import java.util.Optional;
import lombok.Generated;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailImage;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;

public class ThumbnailClassification
extends Thumbnail {
    private final Measurement measurement;
    private final Sample sample;
    private final BasicAnalyse analyse;
    private final CategoryFactor factor;
    private boolean blending = true;
    private final boolean object = false;
    private final boolean[] included;
    private final AbstractBreezeFunction function;
    private final boolean useSampleBounds;
    private final boolean showBackground;

    public ThumbnailClassification(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, CategoryFactor categoryFactor, boolean bl, boolean bl2, AbstractBreezeFunction abstractBreezeFunction) {
        super(measurement.getIndexWithinGroup());
        this.measurement = measurement;
        this.sample = sample;
        this.analyse = basicAnalyse;
        this.factor = categoryFactor;
        this.useSampleBounds = bl;
        this.showBackground = bl2;
        this.function = abstractBreezeFunction;
        this.included = new boolean[categoryFactor.getMaxSize()];
    }

    @Override
    public boolean equalTo(ThumbnailComboBox.ThumbnailWithDescriptor thumbnailWithDescriptor) {
        return thumbnailWithDescriptor.getNode().equalAnalyseAndFactor(this.analyse.getUid(), this.factor.getUid(), thumbnailWithDescriptor.getAdditionalFactor()) && StringHelper.equals((String)Optional.ofNullable(this.function).map(AbstractBreezeFunction::getNode).map(FunctionTreeNodeWithId::getUid).orElse(null), (String)thumbnailWithDescriptor.getNode().getUid()) && thumbnailWithDescriptor.isPixel();
    }

    @Override
    public CategoryFactor getFactor() {
        return this.factor;
    }

    @Override
    protected BufferedImage parseImage(LimitConfiguration limitConfiguration) {
        try (ThumbnailClassificationImage thumbnailClassificationImage = new ThumbnailClassificationImage(this.measurement, this.sample, this.analyse, this.factor, this.useSampleBounds, this.showBackground);){
            BufferedImage bufferedImage = thumbnailClassificationImage.render(limitConfiguration, this.blending, false);
            return bufferedImage;
        }
    }

    @Generated
    public void setBlending(boolean bl) {
        this.blending = bl;
    }

    @Generated
    public boolean[] getIncluded() {
        return this.included;
    }

    @Override
    @Generated
    public AbstractBreezeFunction getFunction() {
        return this.function;
    }

    private class ThumbnailClassificationImage
    extends ThumbnailImage {
        public ThumbnailClassificationImage(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, CategoryFactor categoryFactor, boolean bl, boolean bl2) {
            super(measurement, sample, basicAnalyse, categoryFactor, bl, bl2, null);
        }

        @Override
        protected int[] computeAllLayers() {
            this.factorLayer = ThumbnailClassificationImage.getBandLayer(this.header.bandNames(), this.analyse, this.factor);
            if (this.factorLayer < 0) {
                throw new ThumbnailHelper.ApplyChangesNeededException("No such prediction layer with analyse=" + this.analyse.getUid() + " and factor=" + (this.factor != null ? this.factor.getUid() : "-1"));
            }
            return new int[]{this.factorLayer};
        }

        protected BufferedImage render(LimitConfiguration limitConfiguration, boolean bl, boolean bl2) {
            if (this.multiSample && bl) {
                int[][][] nArray = ((CategoryFactor)this.factor).createClassColorIndexFromClassTypes(true, 0.0);
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < this.bounds.height; ++i) {
                    float[] fArray = this.predictionData.selectBand(this.factorLayer).getFrame(i + this.miny);
                    int n3 = 0;
                    while (n3 < this.bounds.width) {
                        if (this.maskData[n2] != 0) {
                            int n4 = this.byteArray != null ? ((this.byteArray[n + this.b1] & 0xFF) + (this.byteArray[n + this.b2] & 0xFF) + (this.byteArray[n + this.b3] & 0xFF)) / 3 : (this.intArray[n] >> 16 & 255 + this.intArray[n] >> 8 & 255 + this.intArray[n] & 0xFF) / 3;
                            int n5 = (int)fArray[n3 + this.minx];
                            int[] nArray2 = nArray[n4][n5];
                            if (this.byteArray != null) {
                                this.byteArray[n + this.b1] = (byte)nArray2[0];
                                this.byteArray[n + this.b2] = (byte)nArray2[1];
                                this.byteArray[n + this.b3] = (byte)nArray2[2];
                            } else {
                                this.intArray[n] = nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2] | nArray2[3] << 24;
                            }
                            ThumbnailClassification.this.included[n5] = true;
                        }
                        n += this.indexStepSize;
                        ++n3;
                        ++n2;
                    }
                }
            } else {
                int[][] nArray = ((CategoryFactor)this.factor).createColorArray();
                int n = 0;
                int n6 = 0;
                for (int i = 0; i < this.bounds.height; ++i) {
                    float[] fArray = this.predictionData.selectBand(this.factorLayer).getFrame(i + this.miny);
                    int n7 = 0;
                    while (n7 < this.bounds.width) {
                        if (this.maskData[n6] != 0) {
                            int n8 = (int)fArray[n7 + this.minx];
                            int[] nArray3 = nArray[n8];
                            if (this.byteArray != null) {
                                this.byteArray[n + this.b1] = (byte)nArray3[0];
                                this.byteArray[n + this.b2] = (byte)nArray3[1];
                                this.byteArray[n + this.b3] = (byte)nArray3[2];
                            } else {
                                this.intArray[n] = nArray3[0] << 16 | nArray3[1] << 8 | nArray3[2] | nArray3[3] << 24;
                            }
                            ThumbnailClassification.this.included[n8] = true;
                        }
                        n += this.indexStepSize;
                        ++n7;
                        ++n6;
                    }
                }
            }
            return this.image;
        }
    }
}

