/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.thumbnail;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.model.ModelExpressionSegmentation;
import se.prediktera.breeze.common.util.raw.PredictionData;
import se.prediktera.breeze.common.util.raw.PredictionDataCache;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailFile;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailRgb;

public class ThumbnailHelper {
    public static Thumbnail create(Measurement measurement, Sample sample, DescriptorTreeNode descriptorTreeNode) {
        return ThumbnailHelper.create(measurement, sample, descriptorTreeNode.getHierarchyNode(sample, true), null, true, true);
    }

    public static Thumbnail create(Measurement measurement, Sample sample, DescriptorTreeNode descriptorTreeNode, AdditionalFactor additionalFactor, boolean bl, boolean bl2) {
        if (descriptorTreeNode == null) {
            return null;
        }
        AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
        if (abstractBreezeFunction instanceof ThumbnailDescriptor) {
            ThumbnailDescriptor.ThumbType thumbType = ((ThumbnailDescriptor)((Object)abstractBreezeFunction)).getThumbType(descriptorTreeNode.getIndex());
            BasicAnalyse basicAnalyse = descriptorTreeNode.getAnalyse();
            if (basicAnalyse != null) {
                if (additionalFactor != null) {
                    return additionalFactor.getFactor().createThumbnail(measurement, sample, abstractBreezeFunction, basicAnalyse, bl, bl2);
                }
                switch (thumbType) {
                    case ThumbClassification: {
                        CategoryFactor categoryFactor = basicAnalyse.getCategoryFactors().getByUid(descriptorTreeNode.getFactorUid());
                        if (categoryFactor == null) {
                            return null;
                        }
                        return categoryFactor.createThumbnail(measurement, sample, abstractBreezeFunction, basicAnalyse, bl, bl2);
                    }
                    case ThumbQuantification: {
                        PropertyFactor propertyFactor = basicAnalyse.getPropertyFactors().getByUid(descriptorTreeNode.getFactorUid());
                        if (propertyFactor == null) {
                            return null;
                        }
                        return propertyFactor.createThumbnail(measurement, sample, abstractBreezeFunction, basicAnalyse, bl, bl2);
                    }
                    case ThumbPackedRgb: {
                        PropertyFactor propertyFactor = basicAnalyse.getPropertyFactors().getByUid(descriptorTreeNode.getFactorUid());
                        if (propertyFactor == null) {
                            return null;
                        }
                        return propertyFactor.createThumbnail(measurement, sample, abstractBreezeFunction, basicAnalyse, bl, bl2);
                    }
                    case ThumbFile: {
                        return new ThumbnailFile(((ThumbnailDescriptor.ThumbnailFileDescriptor)((Object)abstractBreezeFunction)).getFile(measurement), measurement);
                    }
                }
            }
            if (thumbType.equals((Object)ThumbnailDescriptor.ThumbType.ThumbPseudoRgb)) {
                return new ThumbnailRgb(measurement, sample, abstractBreezeFunction, ((ThumbnailDescriptor.ThumbnailQuantificationDescriptor)((Object)abstractBreezeFunction)).getSmooth(), bl, bl2);
            }
            return null;
        }
        return null;
    }

    public static int getBandLayer(BandNames bandNames, BasicAnalyse basicAnalyse, Factor factor) {
        CategoryFactor categoryFactor;
        if (basicAnalyse == null) {
            return -1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(basicAnalyse.getUid());
        if (factor != null) {
            stringBuilder.append("_");
            stringBuilder.append(factor.getUid());
        } else if (basicAnalyse.getModelMethod().isSample() && (categoryFactor = basicAnalyse.getCategoryFactor()) != null) {
            stringBuilder.append("_");
            stringBuilder.append(categoryFactor.getUid());
        }
        int n = bandNames.indexOf(stringBuilder.toString());
        if (n >= 0) {
            return n;
        }
        if (n < 0) {
            if (factor instanceof CategoryFactor) {
                return bandNames.indexOf(basicAnalyse.getUid());
            }
            if (factor != null) {
                String string = factor.getName();
                int n2 = bandNames.indexOf(basicAnalyse.getUid() + "_" + string);
                if (n2 >= 0) {
                    return n2;
                }
                n2 = bandNames.indexOf(string);
                if (n2 >= 0) {
                    return n2;
                }
                n2 = bandNames.indexOf(string.replaceAll(" ", "_"));
                if (n2 >= 0) {
                    return n2;
                }
            }
        }
        return -1;
    }

    public static BufferedImage createImageMask(Measurement measurement, List<Sample> list, Rectangle rectangle, List<SegmentationNode> list2) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 10);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setColor(Color.white);
        for (Sample object : list) {
            graphics2D.fill(object.getPath().getOrCreateGeneralPath());
        }
        graphics2D.dispose();
        File file = measurement.getPredictionHdrFile();
        if (file.exists()) {
            RawHeader rawHeader = new RawHeader(file);
            if (!list2.isEmpty()) {
                int[] nArray = ThumbnailHelper.getBandsForSegmentation(measurement, list2, rawHeader);
                PredictionData predictionData = PredictionDataCache.getPredictionDataLayers(measurement, nArray);
                LinkedHashSet<SegmentationNode> linkedHashSet = new LinkedHashSet<SegmentationNode>();
                HashSet<SegmentationNode> hashSet = new HashSet<SegmentationNode>(list2);
                ThumbnailHelper.findParents(measurement.getWorkflow().getRoot(), new LinkedHashSet<FunctionTreeNode>(), linkedHashSet, hashSet);
                byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                for (SegmentationNode segmentationNode : new ArrayList<SegmentationNode>(linkedHashSet)) {
                    int n;
                    int n2;
                    int n3 = ThumbnailHelper.getBandLayer(rawHeader.bandNames(), segmentationNode.getAnalyse(), segmentationNode.getFactor());
                    if (n3 < 0) continue;
                    Object n4 = segmentationNode.getFunction();
                    if (n4 instanceof ModelExpressionSegmentation) {
                        ModelExpressionSegmentation modelExpressionSegmentation = (ModelExpressionSegmentation)n4;
                        ModelExpressionSegmentation.ExpInsideList n5 = ((ModelExpressionSegmentation.ModelExpression)(n4 = modelExpressionSegmentation.getExpression().getModelExpression())).getSimpleExpressionValues(segmentationNode.getAnalyse());
                        if (n5.isEmpty()) continue;
                        n2 = 0;
                        for (int fArray = 0; fArray < rectangle.height; ++fArray) {
                            float[] n6 = predictionData.selectBand(n3).getFrame(fArray + rectangle.y);
                            n = 0;
                            while (n < rectangle.width) {
                                if (byArray[n2] != 0 && !n5.anyInside(n6[n + rectangle.x])) {
                                    byArray[n2] = 0;
                                }
                                ++n;
                                ++n2;
                            }
                        }
                        continue;
                    }
                    int n5 = segmentationNode.getFunction().isInverse() ? 1 : 0;
                    int n6 = 0;
                    for (n2 = 0; n2 < rectangle.height; ++n2) {
                        float[] fArray = predictionData.selectBand(n3).getFrame(n2 + rectangle.y);
                        int n7 = 0;
                        while (n7 < rectangle.width) {
                            if (byArray[n6] != 0 && (n = (int)fArray[n7 + rectangle.x]) == n5) {
                                byArray[n6] = 0;
                            }
                            ++n7;
                            ++n6;
                        }
                    }
                }
            }
        }
        return bufferedImage;
    }

    public static int[] getBandsForSegmentation(Measurement measurement, List<SegmentationNode> list, RawHeader rawHeader) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        LinkedHashSet<SegmentationNode> linkedHashSet = new LinkedHashSet<SegmentationNode>();
        HashSet<SegmentationNode> hashSet = new HashSet<SegmentationNode>(list);
        ThumbnailHelper.findParents(measurement.getWorkflow().getRoot(), new LinkedHashSet<FunctionTreeNode>(), linkedHashSet, hashSet);
        for (SegmentationNode segmentationNode : new ArrayList<SegmentationNode>(linkedHashSet)) {
            int n = ThumbnailHelper.getBandLayer(rawHeader.bandNames(), segmentationNode.getAnalyse(), segmentationNode.getFactor());
            if (n < 0) continue;
            arrayList.add(n);
        }
        return arrayList.stream().distinct().mapToInt(Integer::intValue).toArray();
    }

    private static void findParents(FunctionTreeNode functionTreeNode, Set<FunctionTreeNode> set, Set<SegmentationNode> set2, Set<SegmentationNode> set3) {
        if (functionTreeNode == null) {
            return;
        }
        set.add(functionTreeNode);
        if (set3.contains(functionTreeNode)) {
            for (FunctionTreeNode functionTreeNode2 : set) {
                if (!(functionTreeNode2 instanceof SegmentationNode)) continue;
                SegmentationNode segmentationNode = (SegmentationNode)functionTreeNode2;
                set2.add(segmentationNode);
            }
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            ThumbnailHelper.findParents(functionTreeNode2, set, set2, set3);
        }
        set.remove(functionTreeNode);
    }

    public static class ApplyChangesNeededException
    extends RuntimeException {
        public ApplyChangesNeededException(String string) {
            super(string);
        }
    }
}

