/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.thumbnail;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.io.Closeable;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.util.raw.PredictionData;
import se.prediktera.breeze.common.util.raw.PredictionDataCache;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;

public abstract class ThumbnailImage
extends ThumbnailHelper
implements Closeable {
    protected BufferedImage image;
    private BufferedImage maskImage;
    protected final Rectangle bounds;
    protected final int minx;
    protected final int miny;
    protected int factorLayer;
    protected boolean multiSample;
    protected final RawHeader header;
    protected PredictionData predictionData = new PredictionData();
    protected final SampleModel model;
    protected DataBuffer data;
    protected BasicAnalyse analyse;
    protected final DescriptorTreeNode node;
    protected Factor factor;
    protected byte[] maskData;
    protected final int indexStepSize;
    protected final int b1;
    protected final int b2;
    protected final int b3;
    protected byte[] byteArray;
    protected int[] intArray;

    public ThumbnailImage(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, Factor factor, boolean bl, boolean bl2, DescriptorTreeNode descriptorTreeNode) {
        this.analyse = basicAnalyse;
        this.node = descriptorTreeNode;
        this.factor = factor;
        if (!measurement.getPredictionHdrFile().exists()) {
            throw new ThumbnailHelper.ApplyChangesNeededException("No such prediction available");
        }
        this.header = new RawHeader(measurement.getPredictionHdrFile());
        this.predictionData.putAll(PredictionDataCache.getPredictionDataLayers(measurement, this.computeAllLayers()));
        SegmentationNodeList segmentationNodeList = measurement.getSegmentationsForCurrentLevel(sample);
        if (sample != null && bl) {
            Shape shape = sample.getPath().getOrCreateGeneralPath();
            if (shape == null) {
                throw new RuntimeException("Sample path is missing");
            }
            this.bounds = shape.getBounds();
            if (this.bounds.width == 0 || this.bounds.height == 0) {
                throw new RuntimeException("Sample path bounds are not valid (w=" + this.bounds.width + ", h=" + this.bounds.height + ")");
            }
            this.image = new BufferedImage(this.bounds.width, this.bounds.height, 2);
            this.maskImage = ThumbnailImage.createImageMask(measurement, List.of(sample), this.bounds, segmentationNodeList);
            this.multiSample = false;
        } else {
            this.image = (BufferedImage)ThumbnailManager.getInstance(0).getClonedImage(measurement.getThumbnailFile());
            this.bounds = new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight());
            this.maskImage = ThumbnailImage.createImageMask(measurement, measurement.getSamplesForCurrentLevel(), this.bounds, segmentationNodeList);
            this.multiSample = true;
        }
        this.minx = Math.max(0, this.bounds.x);
        this.miny = Math.max(0, this.bounds.y);
        this.maskData = ((DataBufferByte)this.maskImage.getRaster().getDataBuffer()).getData();
        this.model = this.image.getRaster().getSampleModel();
        this.data = this.image.getRaster().getDataBuffer();
        if (this.data instanceof DataBufferByte) {
            this.indexStepSize = this.model.getNumBands();
            this.b1 = this.indexStepSize == 3 ? 2 : 3;
            this.b2 = this.indexStepSize == 3 ? 1 : 2;
            this.b3 = this.indexStepSize == 3 ? 0 : 1;
            this.byteArray = ((DataBufferByte)this.data).getData();
            this.intArray = null;
        } else {
            this.indexStepSize = 1;
            this.intArray = ((DataBufferInt)this.data).getData();
            this.b3 = 0;
            this.b2 = 0;
            this.b1 = 0;
            this.byteArray = null;
        }
        if (this.multiSample && !bl2) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.bounds.height; ++i) {
                int n3 = 0;
                while (n3 < this.bounds.width) {
                    if (this.maskData[n] == 0) {
                        if (this.byteArray != null) {
                            this.byteArray[n2 + this.b1] = 0;
                            this.byteArray[n2 + this.b2] = 0;
                            this.byteArray[n2 + this.b3] = 0;
                        } else {
                            int n4 = n2;
                            this.intArray[n4] = this.intArray[n4] & 0;
                        }
                    }
                    n2 += this.indexStepSize;
                    ++n3;
                    ++n;
                }
            }
        }
    }

    protected abstract int[] computeAllLayers();

    @Override
    public void close() {
        this.predictionData = null;
        this.maskData = null;
        this.maskImage = null;
        this.byteArray = null;
        this.intArray = null;
    }
}

