/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.thumbnail;

import java.awt.image.BufferedImage;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.realtime.descriptor.function.RgbDescriptor;
import se.prediktera.breeze.common.util.raw.FrameListForBand;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailImage;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;

public class ThumbnailPackedRgb
extends Thumbnail {
    protected final Measurement measurement;
    protected final Sample sample;
    protected final BasicAnalyse analyse;
    protected final PropertyFactor factor;
    protected final boolean useSampleBounds;
    protected final boolean showBackground;
    private final AbstractBreezeFunction function;

    public ThumbnailPackedRgb(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, AbstractBreezeFunction abstractBreezeFunction, PropertyFactor propertyFactor, boolean bl, boolean bl2) {
        super(measurement.getIndexWithinGroup());
        this.measurement = measurement;
        this.sample = sample;
        this.analyse = basicAnalyse;
        this.function = abstractBreezeFunction;
        this.factor = propertyFactor;
        this.useSampleBounds = bl;
        this.showBackground = bl2;
    }

    @Override
    public AbstractBreezeFunction getFunction() {
        return this.function;
    }

    @Override
    public boolean equalTo(ThumbnailComboBox.ThumbnailWithDescriptor thumbnailWithDescriptor) {
        DescriptorTreeNode descriptorTreeNode = thumbnailWithDescriptor.getNode();
        AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
        if (abstractBreezeFunction instanceof RgbDescriptor) {
            return descriptorTreeNode.equalAnalyseAndFactor(this.analyse.getUid(), this.factor.getUid(), thumbnailWithDescriptor.getAdditionalFactor());
        }
        return false;
    }

    @Override
    protected BufferedImage parseImage(LimitConfiguration limitConfiguration) {
        try (ThumbnailPackedRgbImage thumbnailPackedRgbImage = this.createPropertyImage();){
            BufferedImage bufferedImage = thumbnailPackedRgbImage.render(limitConfiguration);
            return bufferedImage;
        }
    }

    protected ThumbnailPackedRgbImage createPropertyImage() {
        return new ThumbnailPackedRgbImage(this.measurement, this.sample, this.analyse, this.factor, this.useSampleBounds, this.showBackground, null);
    }

    @Override
    public PropertyFactor getFactor() {
        return this.factor;
    }

    public static class ThumbnailPackedRgbImage
    extends ThumbnailImage {
        public ThumbnailPackedRgbImage(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, PropertyFactor propertyFactor, boolean bl, boolean bl2, DescriptorTreeNode descriptorTreeNode) {
            super(measurement, sample, basicAnalyse, propertyFactor, bl, bl2, descriptorTreeNode);
        }

        @Override
        protected int[] computeAllLayers() {
            this.factorLayer = ThumbnailPackedRgbImage.getBandLayer(this.header.bandNames(), this.analyse, this.factor);
            if (this.factorLayer < 0) {
                throw new ThumbnailHelper.ApplyChangesNeededException("No such prediction layer with analyse=" + this.analyse.getUid() + " and factor=" + (this.factor != null ? this.factor.getUid() : "-1"));
            }
            return new int[]{this.factorLayer};
        }

        protected BufferedImage render(LimitConfiguration limitConfiguration) {
            int n = 0;
            int n2 = 0;
            FrameListForBand frameListForBand = this.predictionData.selectBand(this.factorLayer);
            for (int i = 0; i < this.bounds.height; ++i) {
                float[] fArray = frameListForBand.getFrame(i + this.miny);
                int n3 = 0;
                while (n3 < this.bounds.width) {
                    if (this.maskData[n2] != 0) {
                        int n4 = (int)fArray[n3 + this.minx];
                        if (this.byteArray != null) {
                            this.byteArray[n + this.b1] = (byte)(n4 >> 16 & 0xFF);
                            this.byteArray[n + this.b2] = (byte)(n4 >> 8 & 0xFF);
                            this.byteArray[n + this.b3] = (byte)(n4 & 0xFF);
                        } else {
                            this.intArray[n] = 0xFF000000 | n4;
                        }
                    }
                    n += this.indexStepSize;
                    ++n3;
                    ++n2;
                }
            }
            return this.image;
        }
    }
}

