/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.thumbnail;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.MwlDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.SaturationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.ConnectionDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.image.RtImageProcessHelper;
import se.prediktera.breeze.common.util.image.RtMatrixFloat;
import se.prediktera.breeze.common.util.raw.PredictionData;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.PropertyLimit;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailHelper;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailImage;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;

public class ThumbnailProperty
extends Thumbnail {
    protected final Measurement measurement;
    protected final Sample sample;
    protected final BasicAnalyse analyse;
    protected final PropertyFactor factor;
    protected final int smoothKernel;
    protected VisualisationNode.ColorScale currentColorScale;
    protected final boolean useSampleBounds;
    protected final boolean showBackground;
    private final AbstractBreezeFunction function;
    private static VisualisationNode.ColorScale cachedColorScale;
    protected static int[][] cachedColorIndex;
    private MinMax storedMinMax;

    public ThumbnailProperty(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, AbstractBreezeFunction abstractBreezeFunction, PropertyFactor propertyFactor, int n, boolean bl, boolean bl2) {
        super(measurement.getIndexWithinGroup());
        this.measurement = measurement;
        this.sample = sample;
        this.analyse = basicAnalyse;
        this.function = abstractBreezeFunction;
        this.factor = propertyFactor;
        this.smoothKernel = n;
        this.useSampleBounds = bl;
        this.showBackground = bl2;
        this.currentColorScale = measurement.getWorkflow().getColorScale();
        ThumbnailProperty.updateGlobalColorScale(propertyFactor, this.currentColorScale);
    }

    @Override
    public boolean hasRendered() {
        if (super.hasRendered()) {
            VisualisationNode.ColorScale colorScale = this.measurement.getWorkflow().getColorScale();
            if (colorScale.notEquals(this.currentColorScale)) {
                this.currentColorScale = colorScale;
                ThumbnailProperty.updateGlobalColorScale(this.factor, this.currentColorScale);
                this.clearCache();
            }
            return true;
        }
        return false;
    }

    @Override
    public AbstractBreezeFunction getFunction() {
        return this.function;
    }

    @Override
    public boolean equalTo(ThumbnailComboBox.ThumbnailWithDescriptor thumbnailWithDescriptor) {
        DescriptorTreeNode descriptorTreeNode = thumbnailWithDescriptor.getNode();
        AbstractBreezeFunction abstractBreezeFunction = descriptorTreeNode.getFunction();
        if (abstractBreezeFunction instanceof ThumbnailDescriptor.ThumbnailQuantificationDescriptor) {
            ThumbnailDescriptor.ThumbnailQuantificationDescriptor thumbnailQuantificationDescriptor = (ThumbnailDescriptor.ThumbnailQuantificationDescriptor)((Object)abstractBreezeFunction);
            return descriptorTreeNode.equalAnalyseAndFactor(this.analyse.getUid(), this.factor.getUid(), thumbnailWithDescriptor.getAdditionalFactor()) && thumbnailQuantificationDescriptor.getSmooth() == this.smoothKernel;
        }
        return false;
    }

    @Override
    protected BufferedImage parseImage(LimitConfiguration limitConfiguration) {
        try (ThumbnailPropertyImage thumbnailPropertyImage = this.createPropertyImage();){
            if (thumbnailPropertyImage.minMax != null) {
                this.storedMinMax = thumbnailPropertyImage.minMax;
            }
            BufferedImage bufferedImage = thumbnailPropertyImage.render(limitConfiguration);
            return bufferedImage;
        }
    }

    public MinMax getOrCalculateMinMax() {
        if (this.storedMinMax == null) {
            try (ThumbnailPropertyImage thumbnailPropertyImage = this.createPropertyImage();){
                this.storedMinMax = thumbnailPropertyImage.calcMinMax(0.025);
            }
        }
        return this.storedMinMax;
    }

    protected ThumbnailPropertyImage createPropertyImage() {
        FunctionTreeNodeWithId functionTreeNodeWithId = this.function.getNode();
        if (!this.useSampleBounds && PlsPredQuantificationDescriptor.ConnectedQuantificationFunctionResult.isHierarchical(functionTreeNodeWithId)) {
            return new ThumbnailPropertyImageHierarchy((DescriptorTreeNode)functionTreeNodeWithId, this.measurement, this.sample, this.analyse, this.factor, cachedColorIndex, this.smoothKernel, this.useSampleBounds, this.showBackground);
        }
        return new ThumbnailPropertyImage(this.measurement, this.sample, this.analyse, this.factor, cachedColorIndex, this.smoothKernel, this.useSampleBounds, this.showBackground, null);
    }

    public MinMax getMinMax(LimitConfiguration limitConfiguration) {
        return this.factor.getMinMax(limitConfiguration);
    }

    @Override
    public PropertyFactor getFactor() {
        return this.factor;
    }

    private static void updateGlobalColorScale(Factor factor, VisualisationNode.ColorScale colorScale) {
        if (colorScale.notEquals(cachedColorScale)) {
            cachedColorScale = colorScale;
            cachedColorIndex = colorScale.create().createColorIndex(true);
        }
    }

    public static class ThumbnailPropertyImage
    extends ThumbnailImage {
        private final int smoothKernel;
        protected final int[][] colorIndex;
        private final float missingValue;
        private final int[] missingColor = new int[]{0, 0, 0, 255};
        private MinMax minMax;

        public ThumbnailPropertyImage(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, PropertyFactor propertyFactor, int[][] nArray, int n, boolean bl, boolean bl2) {
            this(measurement, sample, basicAnalyse, propertyFactor, nArray, n, bl, bl2, null);
        }

        public ThumbnailPropertyImage(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, PropertyFactor propertyFactor, int[][] nArray, int n, boolean bl, boolean bl2, DescriptorTreeNode descriptorTreeNode) {
            super(measurement, sample, basicAnalyse, propertyFactor, bl, bl2, descriptorTreeNode);
            this.colorIndex = ThumbnailPropertyImage.getColorIndex(nArray, propertyFactor);
            this.smoothKernel = n;
            this.missingValue = basicAnalyse.getModelMethod().equals((Object)BasicAnalyse.ModelMethod.QuantificationPca) ? 0.0f : -2.1474836E9f;
            if (propertyFactor.isDynamicMinMax()) {
                this.minMax = this.calcMinMax(0.025);
                if (this.minMax != null) {
                    if (propertyFactor instanceof MwlDescriptor.PropertyFactorMwl) {
                        MwlDescriptor.PropertyFactorMwl propertyFactorMwl = (MwlDescriptor.PropertyFactorMwl)propertyFactor;
                        propertyFactor.setMinMax(new MinMax(propertyFactorMwl.getThreshold(), this.minMax.max().floatValue()));
                    } else {
                        propertyFactor.setMinMax(this.minMax);
                    }
                }
                if (propertyFactor instanceof MwlDescriptor.PropertyFactorMwl) {
                    propertyFactor.setDynamicMinMax(false);
                }
            }
        }

        private static int[][] getColorIndex(int[][] nArray, PropertyFactor propertyFactor) {
            if (propertyFactor instanceof SaturationDescriptor.SaturationFactor) {
                SaturationDescriptor.SaturationFactor saturationFactor = (SaturationDescriptor.SaturationFactor)propertyFactor;
                nArray = (int[][])nArray.clone();
                if (saturationFactor.getName().equals("Saturated")) {
                    nArray[nArray.length - 1] = new int[]{255, 255, 255, 255};
                } else {
                    nArray[0] = new int[]{255, 255, 255, 255};
                }
            }
            return nArray;
        }

        @Override
        protected int[] computeAllLayers() {
            this.factorLayer = ThumbnailPropertyImage.getBandLayer(this.header.bandNames(), this.analyse, this.factor);
            if (this.factorLayer < 0) {
                throw new ThumbnailHelper.ApplyChangesNeededException("No such prediction layer with analyse=" + this.analyse.getUid() + " and factor=" + (this.factor != null ? this.factor.getUid() : "-1"));
            }
            return new int[]{this.factorLayer};
        }

        private MinMax calcMinMax(double d) {
            int n;
            float[] fArray = new float[this.bounds.height * this.bounds.width];
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this.bounds.height; ++n) {
                float[] fArray2 = this.predictionData.selectBand(this.factorLayer).getFrame(n + this.miny);
                int n4 = 0;
                while (n4 < this.bounds.width) {
                    float f;
                    if (this.maskData[n3] != 0 && (f = fArray2[n4 + this.minx]) != 0.0f && !Float.isNaN(f)) {
                        fArray[n2++] = f;
                    }
                    ++n4;
                    ++n3;
                }
            }
            if (n2 > 1) {
                Arrays.parallelSort(fArray, 0, n2);
                n = (int)((double)n2 * d);
                return new MinMax(fArray[n], fArray[n2 - n - 1]);
            }
            return null;
        }

        protected BufferedImage render(LimitConfiguration limitConfiguration) {
            PropertyLimit propertyLimit = null;
            if (limitConfiguration != null) {
                propertyLimit = limitConfiguration.getWrapper(this.factor);
            }
            int n = this.colorIndex.length - 1;
            if (this.smoothKernel > 0) {
                RtMatrixFloat rtMatrixFloat = this.createSmoothMatrix(propertyLimit, this.smoothKernel);
                int n2 = 0;
                for (int i = 0; i < this.bounds.height; ++i) {
                    for (int j = 0; j < this.bounds.width; ++j) {
                        if (!rtMatrixFloat.isMissing(j, i)) {
                            int[] nArray = this.colorIndex[BreezeColor.toIndex(rtMatrixFloat.getValue(j, i), n)];
                            if (this.byteArray != null) {
                                this.byteArray[n2 + this.b1] = (byte)nArray[0];
                                this.byteArray[n2 + this.b2] = (byte)nArray[1];
                                this.byteArray[n2 + this.b3] = (byte)nArray[2];
                            } else {
                                this.intArray[n2] = nArray[0] << 16 | nArray[1] << 8 | nArray[2] << 0 | nArray[3] << 24;
                            }
                        }
                        n2 += this.indexStepSize;
                    }
                }
            } else {
                MinMax minMax = this.factor.getMinMax();
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < this.bounds.height; ++i) {
                    int n5 = 0;
                    while (n5 < this.bounds.width) {
                        if (this.maskData[n4] != 0) {
                            int[] nArray;
                            float f = this.getFrameValue(this.predictionData, n5 + this.minx, i + this.miny);
                            if (f == this.missingValue) {
                                nArray = this.missingColor;
                            } else {
                                if (propertyLimit != null) {
                                    f = propertyLimit.normalize(f, 1.0f);
                                } else if (minMax != null) {
                                    f = minMax.normalise(f).floatValue();
                                }
                                nArray = this.colorIndex[BreezeColor.toIndex(f, n)];
                            }
                            if (this.byteArray != null) {
                                this.byteArray[n3 + this.b1] = (byte)nArray[0];
                                this.byteArray[n3 + this.b2] = (byte)nArray[1];
                                this.byteArray[n3 + this.b3] = (byte)nArray[2];
                            } else {
                                this.intArray[n3] = nArray[0] << 16 | nArray[1] << 8 | nArray[2] << 0 | nArray[3] << 24;
                            }
                        }
                        n3 += this.indexStepSize;
                        ++n5;
                        ++n4;
                    }
                }
            }
            return this.image;
        }

        protected RtMatrixFloat createSmoothMatrix(PropertyLimit propertyLimit, int n) {
            RtMatrixFloat rtMatrixFloat = new RtMatrixFloat(this.bounds.width, this.bounds.height);
            MinMax minMax = this.factor.getMinMax();
            int n2 = 0;
            for (int i = 0; i < this.bounds.height; ++i) {
                int n3 = 0;
                while (n3 < this.bounds.width) {
                    if (this.maskData[n2] != 0) {
                        float f = this.getFrameValue(this.predictionData, n3 + this.minx, i + this.miny);
                        f = propertyLimit != null ? propertyLimit.normalize(f, 1.0f) : minMax.normalise(f).floatValue();
                        rtMatrixFloat.setValue(n3, i, f, false);
                    } else {
                        rtMatrixFloat.setValue(n3, i, 0.0, true);
                    }
                    ++n3;
                    ++n2;
                }
            }
            return (RtMatrixFloat)RtImageProcessHelper.processImageMedianKernel(rtMatrixFloat, new RtMatrixFloat(rtMatrixFloat.getN(), rtMatrixFloat.getK(), rtMatrixFloat.getMask()), n);
        }

        protected float getFrameValue(PredictionData predictionData, int n, int n2) {
            return predictionData.selectBand(this.factorLayer).getFrame(n2)[n];
        }
    }

    public static class ThumbnailPropertyImageHierarchy
    extends ThumbnailPropertyImage {
        private int categoryLayer;
        private final HashMap<Integer, Integer> classToCategoryLayerMap = new HashMap();

        public ThumbnailPropertyImageHierarchy(DescriptorTreeNode descriptorTreeNode, Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, PropertyFactor propertyFactor, int[][] nArray, int n, boolean bl, boolean bl2) {
            super(measurement, sample, basicAnalyse, propertyFactor, nArray, n, bl, bl2, descriptorTreeNode);
        }

        @Override
        protected int[] computeAllLayers() {
            int[] nArray = super.computeAllLayers();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int n : nArray) {
                arrayList.add(n);
            }
            Object object = this.node.getParent();
            CategoryFactor categoryFactor = (CategoryFactor)((FunctionTreeNode)object).getFactor();
            this.categoryLayer = ThumbnailPropertyImageHierarchy.getBandLayer(this.header.bandNames(), ((FunctionTreeNode)object).getAnalyse(), categoryFactor);
            arrayList.add(this.categoryLayer);
            for (FunctionTreeNode functionTreeNode : ((FunctionTreeNode)object).getChildList()) {
                PlsPredQuantificationDescriptor plsPredQuantificationDescriptor;
                Object object2 = functionTreeNode.getFunction();
                if (!(object2 instanceof PlsPredQuantificationDescriptor) || (object2 = ConnectionDescriptor.getClass((plsPredQuantificationDescriptor = (PlsPredQuantificationDescriptor)object2).getConnectionClass(), functionTreeNode)) == null) continue;
                int n = ThumbnailPropertyImageHierarchy.getBandLayer(this.header.bandNames(), functionTreeNode.getAnalyse(), functionTreeNode.getFactor());
                this.classToCategoryLayerMap.put(categoryFactor.getClassIndex((CatClass)object2), n);
                arrayList.add(n);
            }
            return arrayList.stream().mapToInt(Integer::intValue).toArray();
        }

        @Override
        protected float getFrameValue(PredictionData predictionData, int n, int n2) {
            int n3 = (int)predictionData.selectBand(this.categoryLayer).getFrame(n2)[n];
            Integer n4 = this.classToCategoryLayerMap.get(n3);
            if (n4 != null) {
                return predictionData.selectBand(n4).getFrame(n2)[n];
            }
            return 0.0f;
        }
    }
}

