/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.thumbnail;

import java.awt.image.BufferedImage;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.realtime.descriptor.MwlDescriptor;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.image.RtMatrixFloat;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.entry.workflow.PropertyLimit;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailProperty;
import se.prediktera.breeze.frontend.main.play.realtime.LegendPanel;
import se.prediktera.map.common.color.ContinuousColorInterface;

public class ThumbnailPropertyMwl
extends ThumbnailProperty {
    public ThumbnailPropertyMwl(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, MwlDescriptor.PropertyFactorMwl propertyFactorMwl, int n, boolean bl, boolean bl2) {
        super(measurement, sample, basicAnalyse, null, propertyFactorMwl, n, bl, bl2);
    }

    @Override
    protected BufferedImage parseImage(LimitConfiguration limitConfiguration) {
        try (ThumbnailPropertyMwlImage thumbnailPropertyMwlImage = new ThumbnailPropertyMwlImage(this.measurement, this.sample, this.analyse, (MwlDescriptor.PropertyFactorMwl)this.factor, cachedColorIndex, this.smoothKernel, this.useSampleBounds, this.showBackground);){
            BufferedImage bufferedImage = thumbnailPropertyMwlImage.render(limitConfiguration);
            return bufferedImage;
        }
    }

    private class ThumbnailPropertyMwlImage
    extends ThumbnailProperty.ThumbnailPropertyImage {
        private int bandFactorLayer;
        private final double startWavelength;
        private final double oneDivAbsWavelength;
        private final double endWavelength;
        private final LegendPanel.MwlColors mwlColors;

        public ThumbnailPropertyMwlImage(Measurement measurement, Sample sample, BasicAnalyse basicAnalyse, MwlDescriptor.PropertyFactorMwl propertyFactorMwl, int[][] nArray, int n, boolean bl, boolean bl2) {
            super(measurement, sample, basicAnalyse, propertyFactorMwl, nArray, n, bl, bl2);
            float[] fArray = propertyFactorMwl.getRange().get(0);
            Pair<Float, Float> pair = measurement.getBandNames().getStartStopWavelength(fArray[0], fArray[1]);
            this.startWavelength = ((Float)pair.getLeft()).floatValue();
            this.endWavelength = ((Float)pair.getRight()).floatValue();
            this.oneDivAbsWavelength = 1.0 / (this.endWavelength - this.startWavelength);
            this.mwlColors = new LegendPanel.MwlColors((ContinuousColorInterface)ThumbnailPropertyMwl.this.currentColorScale.create());
        }

        @Override
        protected int[] computeAllLayers() {
            int[] nArray = super.computeAllLayers();
            PropertyFactor propertyFactor = ((MwlDescriptor.PropertyFactorMwl)this.factor).getBandFactor();
            this.bandFactorLayer = ThumbnailPropertyMwlImage.getBandLayer(this.header.bandNames(), this.analyse, propertyFactor);
            if (this.bandFactorLayer < 0) {
                throw new RuntimeException("No such mwl band layer with analyse=" + this.analyse.getUid() + " and factor=" + (propertyFactor != null ? propertyFactor.getUid() : "-1"));
            }
            return ArrayUtils.add((int[])nArray, (int)this.bandFactorLayer);
        }

        @Override
        protected BufferedImage render(LimitConfiguration limitConfiguration) {
            PropertyLimit propertyLimit = null;
            if (limitConfiguration != null) {
                propertyLimit = limitConfiguration.getWrapper(this.factor);
            }
            int n = ThumbnailProperty.cachedColorIndex.length - 1;
            int n2 = this.mwlColors.getBlendCount();
            int[] nArray = new int[]{0, 0, 0, 255};
            if (ThumbnailPropertyMwl.this.smoothKernel > 0) {
                int n3 = 0;
                RtMatrixFloat rtMatrixFloat = this.createSmoothMatrix(propertyLimit, ThumbnailPropertyMwl.this.smoothKernel);
                for (int i = 0; i < this.bounds.height; ++i) {
                    float[] fArray = this.predictionData.selectBand(this.bandFactorLayer).getFrame(i + this.miny);
                    for (int j = 0; j < this.bounds.width; ++j) {
                        float f = fArray[j + this.minx];
                        if (!rtMatrixFloat.isMissing(j, i)) {
                            if ((double)f >= this.startWavelength && (double)f <= this.endWavelength) {
                                int[] nArray2 = this.mwlColors.getArray(BreezeColor.toIndex(((double)f - this.startWavelength) * this.oneDivAbsWavelength, n), BreezeColor.toIndex(rtMatrixFloat.getValue(j, i), n2));
                                if (this.byteArray != null) {
                                    this.byteArray[n3 + this.b1] = (byte)nArray2[0];
                                    this.byteArray[n3 + this.b2] = (byte)nArray2[1];
                                    this.byteArray[n3 + this.b3] = (byte)nArray2[2];
                                } else {
                                    this.intArray[n3] = nArray2[0] << 16 | nArray2[1] << 8 | nArray2[2] | nArray2[3] << 24;
                                }
                            } else if (this.byteArray != null) {
                                this.byteArray[n3 + this.b1] = (byte)nArray[0];
                                this.byteArray[n3 + this.b2] = (byte)nArray[1];
                                this.byteArray[n3 + this.b3] = (byte)nArray[2];
                            } else {
                                this.intArray[n3] = nArray[0] << 16 | nArray[1] << 8 | nArray[2] | nArray[3] << 24;
                            }
                        }
                        n3 += this.indexStepSize;
                    }
                }
            } else {
                MinMax minMax = this.factor.getMinMax();
                int n4 = 0;
                int n5 = 0;
                for (int i = 0; i < this.bounds.height; ++i) {
                    float[] fArray = this.predictionData.selectBand(this.bandFactorLayer).getFrame(i + this.miny);
                    float[] fArray2 = this.predictionData.selectBand(this.factorLayer).getFrame(i + this.miny);
                    int n6 = 0;
                    while (n6 < this.bounds.width) {
                        float f = fArray[n6 + this.minx];
                        if (this.maskData[n5] != 0) {
                            if ((double)f >= this.startWavelength && (double)f <= this.endWavelength) {
                                float f2 = fArray2[n6 + this.minx];
                                f2 = propertyLimit != null ? propertyLimit.normalize(f2, 1.0f) : minMax.normalise(f2).floatValue();
                                int[] nArray3 = this.mwlColors.getArray(BreezeColor.toIndex(((double)f - this.startWavelength) * this.oneDivAbsWavelength, n), BreezeColor.toIndex(f2, n2));
                                if (this.byteArray != null) {
                                    this.byteArray[n4 + this.b1] = (byte)nArray3[0];
                                    this.byteArray[n4 + this.b2] = (byte)nArray3[1];
                                    this.byteArray[n4 + this.b3] = (byte)nArray3[2];
                                } else {
                                    this.intArray[n4] = nArray3[0] << 16 | nArray3[1] << 8 | nArray3[2] | nArray3[3] << 24;
                                }
                            } else if (this.byteArray != null) {
                                this.byteArray[n4 + this.b1] = (byte)nArray[0];
                                this.byteArray[n4 + this.b2] = (byte)nArray[1];
                                this.byteArray[n4 + this.b3] = (byte)nArray[2];
                            } else {
                                this.intArray[n4] = nArray[0] << 16 | nArray[1] << 8 | nArray[2] | nArray[3] << 24;
                            }
                        }
                        n4 += this.indexStepSize;
                        ++n6;
                        ++n5;
                    }
                }
            }
            return this.image;
        }
    }
}

