/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.table.thumbnail;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.util.List;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.LimitConfiguration;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailImage;
import se.prediktera.breeze.frontend.common.view.preview.ThumbnailComboBox;

public class ThumbnailSample
extends Thumbnail {
    private final File file;
    private final Sample sample;
    private final boolean useSampleBounds;
    private final Measurement measurement;
    private static final int MIN_DIM = 1;

    public ThumbnailSample(File file, Measurement measurement, Sample sample) {
        this(file, measurement, sample, true);
    }

    public ThumbnailSample(File file, Measurement measurement, Sample sample, boolean bl) {
        super(ThumbnailSample.getIndexWithinGroup(sample));
        this.file = file;
        this.measurement = measurement;
        this.sample = sample;
        this.useSampleBounds = bl;
    }

    private static int getIndexWithinGroup(Sample sample) {
        Measurement measurement;
        if (sample != null && (measurement = sample.measurement()) != null) {
            measurement.getIndexWithinGroup();
        }
        return 0;
    }

    @Override
    public boolean equalTo(ThumbnailComboBox.ThumbnailWithDescriptor thumbnailWithDescriptor) {
        return false;
    }

    @Override
    protected BufferedImage parseImage(LimitConfiguration limitConfiguration) {
        List<Sample> list;
        BufferedImage bufferedImage;
        Object object;
        BufferedImage bufferedImage2 = ThumbnailManager.getInstance(0).getImage(this.file);
        if (bufferedImage2 == null) {
            throw new NoMeasurementDataException();
        }
        Rectangle rectangle = new Rectangle(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        if (this.useSampleBounds) {
            if (this.sample == null || this.sample.getPath() == null || this.sample.getPath().getOrCreateGeneralPath() == null) {
                return bufferedImage2;
            }
            object = this.sample.getPath().getOrCreateGeneralPath();
            rectangle = object.getBounds();
            int n = Math.max(1, rectangle.width);
            int n2 = Math.max(1, rectangle.height);
            bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.translate(-rectangle.x - (rectangle.width - n) / 2, -rectangle.y - (rectangle.height - n2) / 2);
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            graphics2D.dispose();
            list = List.of(this.sample);
        } else {
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
            object = (Graphics2D)bufferedImage.getGraphics();
            ((Graphics)object).setColor(Color.black);
            ((Graphics)object).fillRect(0, 0, rectangle.width, rectangle.height);
            ((Graphics)object).drawImage(bufferedImage2, 0, 0, null);
            ((Graphics)object).dispose();
            list = this.measurement.getSamplesForCurrentLevel();
        }
        object = ThumbnailImage.createImageMask(this.measurement, list, rectangle, this.measurement.getSegmentationsForCurrentLevel(list.size() > 0 ? list.getFirst() : null));
        if (object == null) {
            return bufferedImage;
        }
        byte[] byArray = ((DataBufferByte)((BufferedImage)object).getRaster().getDataBuffer()).getData();
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n = 0;
        for (int i = 0; i < rectangle.height; ++i) {
            int n3 = 0;
            while (n3 < rectangle.width) {
                if (byArray[n] == 0) {
                    int n4 = n;
                    nArray[n4] = nArray[n4] & 0;
                }
                ++n3;
                ++n;
            }
        }
        return bufferedImage;
    }

    public static class NoMeasurementDataException
    extends RuntimeException {
    }
}

