/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.validator;

import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.frontend.common.swing.validator.AbstractValidator;
import se.prediktera.breeze.frontend.common.swing.validator.ValidatorResult;
import se.prediktera.map.common.NiceDataFormat;

public class NumericMinMaxValidator
extends AbstractValidator {
    private double min;
    private double max;
    private String maxDescription = "maximum";

    public NumericMinMaxValidator(double d, double d2, String string) {
        this(d, d2);
        this.setMaxDescription(string);
    }

    public NumericMinMaxValidator(MinMax minMax) {
        this(minMax.min().floatValue(), minMax.max().floatValue());
    }

    public NumericMinMaxValidator(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public void setMaxDescription(String string) {
        this.maxDescription = string;
    }

    @Override
    public ValidatorResult validate(String string) {
        double d = NiceDataFormat.toNumber((String)string);
        if (d < this.min) {
            return new ValidatorResult("Value is below minimum " + NiceDataFormat.toString((double)this.min), NiceDataFormat.toString((double)Math.max(0.0, this.min)));
        }
        if (d > this.max) {
            return new ValidatorResult("Value is above " + this.maxDescription + " " + NiceDataFormat.toString((double)this.max), NiceDataFormat.toString((double)this.max));
        }
        if (Double.isNaN(d)) {
            return new ValidatorResult("NaN", NiceDataFormat.toString((double)Math.max(0.0, this.min)));
        }
        return null;
    }
}

