/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.validator;

import java.util.regex.Pattern;
import se.prediktera.breeze.frontend.common.swing.validator.AbstractValidator;
import se.prediktera.breeze.frontend.common.swing.validator.ValidatorResult;

public class RegexValidator
extends AbstractValidator {
    protected final Pattern pattern;
    private final String patternExplanation;

    public RegexValidator(String string, String string2) {
        this.pattern = Pattern.compile(string);
        this.patternExplanation = string2;
    }

    public RegexValidator(String string, String string2, int n) {
        this.pattern = Pattern.compile(string, n);
        this.patternExplanation = string2;
    }

    @Override
    public ValidatorResult validate(String string) {
        if (!this.pattern.matcher(string).matches()) {
            return new ValidatorResult("Text does not match required pattern: " + this.patternExplanation);
        }
        return null;
    }

    public static EmailValidator email() {
        return new EmailValidator();
    }

    public static class EmailValidator
    extends RegexValidator {
        protected EmailValidator() {
            super("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,}$", "email address format", 2);
        }

        @Override
        public ValidatorResult validate(String string) {
            if (super.validate(string) != null) {
                return new ValidatorResult(this, "Invalid email address"){

                    @Override
                    public boolean highLightBorder() {
                        return true;
                    }
                };
            }
            return null;
        }
    }
}

