/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util;

import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.view.ViewClass;

public abstract class BreezeFilter {
    public abstract boolean matches(Object var1);

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected boolean contains(String string, String string2) {
        return string.matches(".*" + string2 + ".*");
    }

    public static class AnalyseTypeFilter
    extends BreezeFilter {
        private final BasicAnalyse.ModelType type;

        public AnalyseTypeFilter(BasicAnalyse.ModelType modelType) {
            this.type = modelType;
        }

        @Override
        public boolean matches(Object object) {
            if (object instanceof Analyse) {
                Analyse analyse = (Analyse)object;
                if (this.type != null) {
                    return this.type.equals((Object)analyse.getModelMethod().getType());
                }
            }
            return false;
        }
    }

    public static class AnalyseStudy
    extends BreezeFilter {
        private Workflow workflow;
        private boolean useOnlyStudyId;

        public AnalyseStudy(Workflow workflow) {
            this.setWorkflow(workflow, true);
        }

        public void setWorkflow(Workflow workflow) {
            this.setWorkflow(workflow, true);
        }

        public void setWorkflow(Workflow workflow, boolean bl) {
            this.workflow = workflow;
            this.useOnlyStudyId = bl;
        }

        @Override
        public boolean matches(Object object) {
            if (this.workflow != null) {
                if (object instanceof BasicAnalyse) {
                    boolean bl = ((BasicAnalyse)object).partOfStudy(this.workflow.getStudyId());
                    if (this.useOnlyStudyId) {
                        return bl;
                    }
                    return bl || this.workflow.getConnectedAnalysis().contains(object);
                }
                if (object instanceof Workflow) {
                    return ((Workflow)object).partOfStudy(this.workflow.getStudyId());
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return this.workflow.getName();
        }
    }

    public static class Warning
    extends BreezeFilter {
        @Override
        public boolean matches(Object object) {
            if (object instanceof Measurement) {
                Measurement measurement = (Measurement)object;
                return measurement.hasWarning();
            }
            return true;
        }
    }

    public static class UID
    extends BreezeFilter {
        private final String uid;

        public UID(String string) {
            this.uid = string.toLowerCase();
        }

        @Override
        public boolean matches(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                String string = entry.getUid().toLowerCase();
                return string.equals(this.uid);
            }
            return true;
        }
    }

    public static class Or
    extends BreezeFilter {
        private final BreezeFilter f1;
        private final BreezeFilter f2;

        public Or(BreezeFilter breezeFilter, BreezeFilter breezeFilter2) {
            this.f1 = breezeFilter;
            this.f2 = breezeFilter2;
        }

        @Override
        public boolean matches(Object object) {
            return this.f1.matches(object) || this.f2.matches(object);
        }
    }

    public static class Name
    extends BreezeFilter {
        private final String name;

        public Name(String string) {
            this.name = string.toLowerCase();
        }

        @Override
        public boolean matches(Object object) {
            if (object instanceof Measurement) {
                Measurement measurement = (Measurement)object;
                String string = measurement.getPrimarySampleIdentifier();
                string = string != null ? string.toLowerCase() : "";
                String string2 = measurement.getName().toLowerCase();
                return this.contains(string2, this.name) || string.matches(this.name) || string.startsWith(this.name);
            }
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return this.contains(entry.getName().toLowerCase(), this.name);
            }
            if (object instanceof RuntimeWorkflow) {
                RuntimeWorkflow runtimeWorkflow = (RuntimeWorkflow)object;
                return this.contains(runtimeWorkflow.getName().toLowerCase(), this.name);
            }
            if (object instanceof ViewClass) {
                ViewClass viewClass = (ViewClass)object;
                String string = viewClass.getName().toLowerCase();
                return string.matches(this.name) || string.startsWith(this.name);
            }
            return true;
        }
    }

    public static class Grayed
    extends BreezeFilter {
        @Override
        public boolean matches(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return entry.isGrayed();
            }
            return true;
        }
    }

    public static class ApplyChangesNeeded
    extends BreezeFilter {
        @Override
        public boolean matches(Object object) {
            if (object instanceof Measurement) {
                Measurement measurement = (Measurement)object;
                return measurement.applyChangesNeeded();
            }
            return true;
        }

        @Override
        public String toString() {
            return "Changed";
        }
    }

    public static class And
    extends BreezeFilter {
        private final BreezeFilter f1;
        private final BreezeFilter f2;

        public And(BreezeFilter breezeFilter, BreezeFilter breezeFilter2) {
            this.f1 = breezeFilter;
            this.f2 = breezeFilter2;
        }

        @Override
        public boolean matches(Object object) {
            return this.f1.matches(object) && this.f2.matches(object);
        }
    }

    public static class All
    extends BreezeFilter {
        @Override
        public boolean matches(Object object) {
            return true;
        }
    }
}

