/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Node;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.settings.ReferenceSettings;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.EntryWithSave;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.util.BreezeUser;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertiesHelper;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.Output;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.CameraMode;
import se.prediktera.breeze.hardware.camera.CameraType;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeProcess;
import se.prediktera.breeze.hardware.samplemover.tray.MoverMode;
import se.prediktera.breeze.util.ScreenResolution;
import se.prediktera.breeze.util.performance.DiagnosticHelper;

public class BreezeProperties
implements EntryWithSave {
    private static BreezeProperties instance;
    private static final Object lock;
    private long lastChanged = 0L;
    protected final XmlProperties properties;
    private static final String REF_QUALITY_PARENT = "measurement/referenceQuality";

    public static BreezeProperties getInstance() {
        return BreezeProperties.getInstance(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BreezeProperties getInstance(boolean bl) {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new BreezeProperties();
            } else if (bl) {
                instance.reload();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInstance() {
        Object object = lock;
        synchronized (object) {
            instance = null;
        }
    }

    @Override
    public void save() {
        this.properties.saveProperties();
    }

    public synchronized void increaseSaveIndex() {
        this.properties.increaseSaveIndex();
    }

    public int getSaveIndex() {
        return this.properties.getSaveIndex();
    }

    private BreezeProperties() {
        this(new XmlProperties("root", "Properties updated"){

            @Override
            public File getPropertyFile() {
                WorkspaceManager.Workspace workspace = BreezeProperties.getWorkspace();
                if (workspace != null) {
                    return workspace.getBreezeProperties();
                }
                return null;
            }
        });
        this.reload();
    }

    public BreezeProperties(XmlProperties xmlProperties) {
        this.properties = xmlProperties;
    }

    public static WorkspaceManager.Workspace getWorkspace() {
        return WorkspaceManager.getInstance().getWorkspace();
    }

    public BreezeUser getLoginUser() {
        return BreezeUserManager.getBreezeUser();
    }

    public void reload() {
        File file = this.properties.getPropertyFile();
        if (file != null && this.lastChanged < file.lastModified()) {
            this.properties.accessFileAndReadCreateOrSave(true);
            this.lastChanged = file.lastModified();
        }
    }

    private String getProperty(String string, String string2, String string3) {
        return this.properties.getPropertyLocal(XmlPropertiesHelper.merge(string, string2), string3);
    }

    private int getPropertyInt(String string, String string2, int n) {
        return this.properties.getPropertyIntLocal(XmlPropertiesHelper.merge(string, string2), n);
    }

    private void setProperty(String string, String string2, String string3) {
        this.properties.setPropertyLocal(XmlPropertiesHelper.merge(string, string2), string3);
    }

    private void setProperty(String string, String string2, String string3, Map<String, String> map) {
        this.properties.setPropertyLocal(XmlPropertiesHelper.merge(string, string2), string3, map);
    }

    private void setPropertyInt(String string, String string2, int n) {
        this.properties.setPropertyLocal(XmlPropertiesHelper.merge(string, string2), RtDataFormat.toString(n));
    }

    private void setPropertyFloat(String string, String string2, float f) {
        this.properties.setPropertyLocal(XmlPropertiesHelper.merge(string, string2), RtDataFormat.toString(f));
    }

    private void setPropertyDouble(String string, String string2, double d) {
        this.properties.setPropertyLocal(XmlPropertiesHelper.merge(string, string2), RtDataFormat.toString(d));
    }

    private boolean getPropertyBool(String string, String string2, boolean bl) {
        return this.properties.getPropertyBoolLocal(XmlPropertiesHelper.merge(string, string2), bl);
    }

    private double getPropertyDouble(String string, String string2, double d) {
        return this.properties.getPropertyDoubleLocal(XmlPropertiesHelper.merge(string, string2), d);
    }

    private void setPropertyBool(String string, String string2, boolean bl) {
        this.properties.setPropertyLocal(XmlPropertiesHelper.merge(string, string2), String.valueOf(bl));
    }

    public Node getPropertyNode(String string) {
        return this.properties.getPropertyNodeLocal(string);
    }

    public Node getPropertyNode(String string, String string2) {
        return this.properties.getPropertyNodeLocal(XmlPropertiesHelper.merge(string, string2));
    }

    public boolean hasProperty(String string, String string2) {
        return this.properties.hasPropertyNodeLocal(XmlPropertiesHelper.merge(string, string2));
    }

    public boolean hasProperty(String string) {
        return this.properties.hasPropertyNodeLocal(string);
    }

    public void withoutToaster(Runnable runnable) {
        this.properties.withoutToaster(runnable);
    }

    public File getBreezeRuntimeExeFile() {
        String string = BreezeRuntimeProcess.getDefaultBreezeRuntimePath().getAbsolutePath();
        if (this.hasProperty("server", "path")) {
            String string2 = this.getProperty("server", "path", "");
            if (string2.equals(string)) {
                this.properties.removeProperty(XmlPropertiesHelper.merge("server", "path"));
            } else {
                return new File(string2);
            }
        }
        return new File(string);
    }

    public void setBreezeRuntimeExeFile(File file) {
        this.withoutToaster(() -> this.setProperty("server", "path", file.getAbsolutePath()));
    }

    public boolean isBreezeRuntimeLocal() {
        return this.getPropertyBool("server", "local", true);
    }

    public void setBreezeRuntimeLocal(boolean bl) {
        this.setPropertyBool("server", "local", bl);
    }

    public String getBreezeRuntimeHost() {
        return this.getProperty("server", "host", "localhost");
    }

    public void setBreezeRuntimeHost(String string) {
        this.setProperty("server", "host", string);
    }

    public boolean useMemoryMappedFile() {
        return this.getPropertyBool("server", "useMemoryMappedFile", false);
    }

    public void setShowTerminalWindow(boolean bl) {
        this.withoutToaster(() -> this.setPropertyBool("server", "showTerminalWindow", bl));
    }

    public boolean showTerminalWindow() {
        return this.getPropertyBool("server", "showTerminalWindow", false);
    }

    public int getCommandPort() {
        return this.getPropertyInt("server", "commandPort", 2000);
    }

    public int getChunks() {
        return this.getPropertyInt("server", "chunks", 1);
    }

    public void setCommandPort(int n) {
        this.setPropertyInt("server", "commandPort", n);
    }

    public int getEventPort() {
        return this.getPropertyInt("server", "eventPort", 2500);
    }

    public void setEventPort(int n) {
        this.setPropertyInt("server", "eventPort", n);
    }

    public int getDataStreamPort() {
        return this.getPropertyInt("server", "streamPort", 3000);
    }

    public void setStreamPort(int n) {
        this.setPropertyInt("server", "streamPort", n);
    }

    public boolean useHardwareAcceleration() {
        return this.getPropertyBool("server", "useHardwareAcceleration", false);
    }

    public void setUseHardwareAcceleration(boolean bl) {
        this.setPropertyBool("server", "useHardwareAcceleration", bl);
    }

    public boolean saveOnnxInputImages() {
        return this.getPropertyBool("server", "saveOnnxInputImages", false);
    }

    public void setSaveOnnxInputImages(boolean bl) {
        this.setPropertyBool("server", "saveOnnxInputImages", bl);
    }

    public String getBreezeRuntimeConnectHost() {
        if (this.isBreezeRuntimeLocalHost()) {
            return "localhost";
        }
        return this.getBreezeRuntimeHost();
    }

    public boolean isBreezeRuntimeLocalHost() {
        return this.isBreezeRuntimeLocal();
    }

    public int getPingTimeout() {
        return 5000;
    }

    public int getStartTimeoutSeconds() {
        return this.getPropertyInt("server", "startTimeout", 10);
    }

    public String getSelectedSampleMover() {
        return XmlParserHelper.getAttribute(this.getPropertyNode("sampleMovers"), "selected", "");
    }

    public void setSelectedSampleMover(SampleMover sampleMover) {
        XmlParserHelper.setAttribute(this.getPropertyNode("sampleMovers"), "selected", sampleMover != null ? sampleMover.getXmlNodeName() : "");
        this.properties.saveProperties();
    }

    public boolean getSampleMoverTransmittanceModeEnabled(SampleMover sampleMover) {
        return this.getSampleMoverPropertyBool(sampleMover, "transmittanceModeEnabled", false);
    }

    public String getSampleMoverProperty(SampleMover sampleMover, String string, String string2) {
        return this.getProperty("sampleMovers/" + sampleMover.getXmlNodeName(), string, string2);
    }

    public void setSampleMoverProperty(SampleMover sampleMover, String string, String string2) {
        this.setProperty("sampleMovers/" + sampleMover.getXmlNodeName(), string, string2);
    }

    public void setSampleMoverPropertyInt(SampleMover sampleMover, SampleMover.Property property, int n) {
        this.setSampleMoverProperty(sampleMover, property.name(), RtDataFormat.toString(n));
    }

    public void setSampleMoverPropertyInt(SampleMover sampleMover, String string, int n) {
        this.setSampleMoverProperty(sampleMover, string, RtDataFormat.toString(n));
    }

    public void setSampleMoverPropertyFloat(SampleMover sampleMover, String string, float f) {
        this.setSampleMoverProperty(sampleMover, string, RtDataFormat.toString(f));
    }

    public void setSampleMoverPropertyDouble(SampleMover sampleMover, String string, double d) {
        this.setSampleMoverProperty(sampleMover, string, RtDataFormat.toString(d));
    }

    public double getSampleMoverPropertyDouble(SampleMover sampleMover, String string, double d) {
        return RtDataFormat.toNumber(this.getSampleMoverProperty(sampleMover, string, String.valueOf(d)));
    }

    public float getSampleMoverPropertyFloat(SampleMover sampleMover, String string, float f) {
        return RtDataFormat.toNumberFloat(this.getSampleMoverProperty(sampleMover, string, String.valueOf(f)));
    }

    public int getSampleMoverPropertyInt(SampleMover sampleMover, SampleMover.Property property, int n) {
        return (int)this.getSampleMoverPropertyDouble(sampleMover, property.name(), n);
    }

    public int getSampleMoverPropertyInt(SampleMover sampleMover, String string, int n) {
        return (int)this.getSampleMoverPropertyDouble(sampleMover, string, n);
    }

    public boolean getSampleMoverPropertyBool(SampleMover sampleMover, String string, boolean bl) {
        return Boolean.parseBoolean(this.getSampleMoverProperty(sampleMover, string, String.valueOf(bl)));
    }

    public void setSampleMoverPropertyBool(SampleMover sampleMover, String string, boolean bl) {
        this.setSampleMoverProperty(sampleMover, string, String.valueOf(bl));
    }

    public double getUmbioInspectorMaximumHeight() {
        return this.properties.getPropertyDoubleLocal(XmlPropertiesHelper.merge("machine", "extendedheight"), 2400.0);
    }

    public double getMoverModePropertyDouble(SampleMover sampleMover, MoverMode moverMode, String string, double d) {
        return Double.parseDouble(this.getMoverModeProperty(sampleMover, moverMode, string, RtDataFormat.toString(d)));
    }

    public int getMoverModePropertyInt(SampleMover sampleMover, MoverMode moverMode, String string, int n) {
        return (int)this.getMoverModePropertyDouble(sampleMover, moverMode, string, n);
    }

    public String getMoverModeProperty(SampleMover sampleMover, MoverMode moverMode, String string, String string2) {
        return this.getProperty("sampleMovers/" + sampleMover.getXmlNodeName() + "/" + moverMode.getXmlNodeName(), string, string2);
    }

    public void setMoverModeProperty(SampleMover sampleMover, MoverMode moverMode, String string, String string2) {
        this.setProperty("sampleMovers/" + sampleMover.getXmlNodeName() + "/" + moverMode.getXmlNodeName(), string, string2);
    }

    public String getSelectedCamera(int n, String string) {
        return XmlParserHelper.getAttribute(this.getSelectedCameraNode(n), "selected", string);
    }

    public void setSelectedCamera(int n, Camera camera) {
        this.setNodeValue(this.getSelectedCameraNode(n), "selected", camera != null ? camera.getXmlNodeName() : "none");
    }

    public Camera.MultiCameraSetting getMultiCameraSetting() {
        Node node = this.getSelectedCameraNode(1);
        return Camera.MultiCameraSetting.parse(XmlParserHelper.getAttribute(node, "mode", Camera.MultiCameraMode.defaultValue().name()), XmlParserHelper.getIntAttribute(node, "index", 0));
    }

    public void setMultiCameraSetting(Camera.MultiCameraSetting multiCameraSetting) {
        this.setNodeValue(this.getSelectedCameraNode(1), "mode", multiCameraSetting.mode().name());
        this.setNodeValue(this.getSelectedCameraNode(1), "index", String.valueOf(multiCameraSetting.index()));
    }

    public Camera.TransformAlgorithm getMultiCameraRealignAlgorithm() {
        Camera.TransformAlgorithm transformAlgorithm = Camera.TransformAlgorithm.parse(XmlParserHelper.getAttribute(this.getSelectedCameraNode(1), "algorithm", Camera.TransformAlgorithm.defaultValue().name()));
        if (!Arrays.asList(Camera.TransformAlgorithm.getMergeRealignmentAlgorithms()).contains((Object)transformAlgorithm)) {
            BreezeProperties.getInstance().setMultiCameraRealignAlgorithm(Camera.TransformAlgorithm.defaultValue());
            return Camera.TransformAlgorithm.defaultValue();
        }
        return transformAlgorithm;
    }

    public void setMultiCameraRealignAlgorithm(Camera.TransformAlgorithm transformAlgorithm) {
        this.setNodeValue(this.getSelectedCameraNode(1), "algorithm", transformAlgorithm.name());
    }

    public void setMultiCameraSurfRealignmentOptions(String string) {
        this.setNodeValue(this.getSelectedCameraNode(1), "surfOptions", string);
    }

    public String getMultiCameraSurfRealignmentOptions() {
        return XmlParserHelper.getAttribute(this.getSelectedCameraNode(1), "surfOptions", "500;4;2");
    }

    public void setMultiCameraSiftRealignmentOptions(String string) {
        this.setNodeValue(this.getSelectedCameraNode(1), "siftOptions", string);
    }

    public String getMultiCameraSiftRealignmentOptions() {
        return XmlParserHelper.getAttribute(this.getSelectedCameraNode(1), "siftOptions", "0;3;0.04;10;1.6");
    }

    public void setMultiCameraOrbRealignmentOptions(String string) {
        this.setNodeValue(this.getSelectedCameraNode(1), "orbOptions", string);
    }

    public String getMultiCameraOrbRealignmentOptions() {
        return XmlParserHelper.getAttribute(this.getSelectedCameraNode(1), "orbOptions", "500;1.2;8;31;0;2;31;20");
    }

    public void setMultiCameraContourRealignmentOptions(String string) {
        this.setNodeValue(this.getSelectedCameraNode(1), "contourOptions", string);
    }

    public String getMultiCameraContourRealignmentOptions() {
        return XmlParserHelper.getAttribute(this.getSelectedCameraNode(1), "contourOptions", "Dilate");
    }

    public boolean isMultiCameraBackup() {
        return XmlParserHelper.getBooleanAttribute(this.getSelectedCameraNode(1), "backup", true);
    }

    public void setMultiCameraBackup(boolean bl) {
        this.setNodeValue(this.getSelectedCameraNode(1), "backup", String.valueOf(bl));
    }

    public String getMultiCameraRotate() {
        return XmlParserHelper.getAttribute(this.getSelectedCameraNode(1), "rotate", "");
    }

    public void setMultiCameraRotate(String string) {
        this.setNodeValue(this.getSelectedCameraNode(1), "rotate", string);
    }

    private Node getSelectedCameraNode(int n) {
        return this.getPropertyNode(this.getCameraRootPath(n));
    }

    private void setNodeValue(Node node, String string, String string2) {
        String string3 = XmlParserHelper.getAttribute(node, string);
        if (!StringHelper.equals((String)string3, (String)string2)) {
            XmlParserHelper.setAttribute(node, string, string2);
            this.properties.saveProperties();
        }
    }

    public FieldOfView getCameraFieldOfView(Camera camera) {
        return new FieldOfView((float)this.getCameraPropertyDouble(camera, "fieldOfView", 320));
    }

    public void setCameraFieldOfView(Camera camera, FieldOfView fieldOfView) {
        this.setCameraProperty(camera, "fieldOfView", Float.toString(fieldOfView.value));
    }

    public MeasurementLength getMeasurementLength() {
        Node node;
        Node node2 = this.getPropertyNode("measurement", "measureLength");
        if (node2 != null && !node2.getTextContent().isEmpty()) {
            String string = XmlParserHelper.getAttribute(node2, "unit");
            return new MeasurementLength(RtDataFormat.toNumberFloat(node2.getTextContent()), MeasurementLength.LengthUnit.parseUnit(string));
        }
        Camera camera = HardwareRegistry.getInstance().getActiveCamera();
        if (camera != null && (node = this.getPropertyNode(this.getCameraPath(camera), "measureLength")) != null && !node.getTextContent().isEmpty()) {
            String string = XmlParserHelper.getAttribute(node, "unit");
            return new MeasurementLength(RtDataFormat.toNumberFloat(node.getTextContent()), MeasurementLength.LengthUnit.parseUnit(string));
        }
        return new MeasurementLength(100.0f);
    }

    public void setMeasureLength(MeasurementLength measurementLength) {
        Node node = this.getPropertyNode("measurement", "measureLength");
        if (node != null) {
            node.setTextContent(String.valueOf(measurementLength.value));
            XmlParserHelper.setAttribute(node, "unit", measurementLength.getUnit().name());
            this.updateRecentMeasurementLengths(node, measurementLength);
            this.properties.saveProperties();
        }
    }

    private void updateRecentMeasurementLengths(Node node, MeasurementLength measurementLength) {
        if (node == null) {
            return;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(this.getRecentMeasurementLengths());
        if (!arrayList.contains(Float.valueOf(measurementLength.value))) {
            arrayList.add(Float.valueOf(measurementLength.value));
        }
        if (arrayList.size() > 10) {
            arrayList.removeFirst();
        }
        XmlParserHelper.setAttribute(node, "recent", arrayList.stream().map(String::valueOf).collect(Collectors.joining(";")));
    }

    public List<Float> getRecentMeasurementLengths() {
        Node node = XmlParserHelper.getNode(this.getPropertyNode("measurement"), "measureLength");
        if (node == null) {
            return new ArrayList<Float>();
        }
        String string = XmlParserHelper.getAttribute(node, "recent");
        if (string == null || string.isBlank()) {
            return new ArrayList<Float>();
        }
        return Arrays.stream(string.split(";")).map(RtDataFormat::toNumberFloat).sorted().toList();
    }

    public RtFramePredictor.ReferenceConvertTo getReferenceConvertTo() {
        return RtFramePredictor.ReferenceConvertTo.parse(this.getProperty("measurement", "referenceConvertTo", RtFramePredictor.ReferenceConvertTo.getDefault().toString()));
    }

    public void setReferenceConvertTo(RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
        this.setProperty("measurement", "referenceConvertTo", referenceConvertTo.toString());
    }

    public boolean useCompressedReferences() {
        return this.getPropertyBool("measurement", "compressReferences", false);
    }

    public void setUseCompressedReferences(boolean bl) {
        this.setPropertyBool("measurement", "compressReferences", bl);
    }

    public boolean verifyReferenceQuality() {
        return this.getPropertyBool("measurement", "verifyReferenceQuality", true);
    }

    public void setVerifyReferenceQuality(boolean bl) {
        this.setPropertyBool("measurement", "verifyReferenceQuality", bl);
    }

    public double getReferenceQualityEdgePercent() {
        return this.getPropertyDouble(REF_QUALITY_PARENT, "edgePercent", 0.1);
    }

    public void setReferenceQualityEdgePercent(double d) {
        this.setProperty(REF_QUALITY_PARENT, "edgePercent", RtDataFormat.toString(d));
    }

    public double getReferenceQualityDarkMaxSignal() {
        return this.getPropertyDouble(REF_QUALITY_PARENT, "darkMaxSignal", 0.7);
    }

    public void setReferenceQualityDarkMaxSignal(double d) {
        this.setProperty(REF_QUALITY_PARENT, "darkMaxSignal", RtDataFormat.toString(d));
    }

    public double getReferenceQualityWhiteMinSignal() {
        return this.getPropertyDouble(REF_QUALITY_PARENT, "whiteMinSignal", 0.5);
    }

    public void setReferenceQualityWhiteMinSignal(double d) {
        this.setProperty(REF_QUALITY_PARENT, "whiteMinSignal", RtDataFormat.toString(d));
    }

    public double getReferenceQualityWhiteMaxSignal() {
        return this.getPropertyDouble(REF_QUALITY_PARENT, "whiteMaxSignal", 0.99);
    }

    public void setReferenceQualityWhiteMaxSignal(double d) {
        this.setProperty(REF_QUALITY_PARENT, "whiteMaxSignal", RtDataFormat.toString(d));
    }

    public double getReferenceQualityWhitePixelVariation() {
        return this.getPropertyDouble(REF_QUALITY_PARENT, "whitePixelVariation", 0.05);
    }

    public void setReferenceQualityWhitePixelVariation(double d) {
        this.setProperty(REF_QUALITY_PARENT, "whitePixelVariation", RtDataFormat.toString(d));
    }

    public double getReferenceQualityMaxLineVariation() {
        return this.getPropertyDouble(REF_QUALITY_PARENT, "maxLineVariation", 0.05);
    }

    public void setReferenceQualityMaxLineVariation(double d) {
        this.setProperty(REF_QUALITY_PARENT, "maxLineVariation", RtDataFormat.toString(d));
    }

    public boolean enableRuntimeQualityChecks() {
        return XmlParserHelper.getBooleanAttribute(this.getPropertyNode(REF_QUALITY_PARENT), "enabled", false);
    }

    public void setEnableRuntimeQualityChecks(boolean bl) {
        XmlParserHelper.setAttribute(this.getPropertyNode(REF_QUALITY_PARENT), "enabled", bl);
    }

    public void setRuntimeDefaults() {
        this.getWavelengthMatchingTolerance();
        this.getReferenceQualityEdgePercent();
        this.getReferenceQualityDarkMaxSignal();
        this.getReferenceQualityWhiteMinSignal();
        this.getReferenceQualityWhiteMaxSignal();
        this.getReferenceQualityWhitePixelVariation();
        this.getReferenceQualityMaxLineVariation();
        this.setEnableRuntimeQualityChecks(this.enableRuntimeQualityChecks());
        this.withoutToaster(this::save);
    }

    public SpatialDescriptor.SiUnit getDefaultUnit() {
        return SpatialDescriptor.SiUnit.parse(this.getProperty("measurement", "defaultUnit", SpatialDescriptor.SiUnit.mm.name()));
    }

    public void setDefaultUnit(SpatialDescriptor.SiUnit siUnit) {
        this.setProperty("measurement", "defaultUnit", siUnit.name());
    }

    public boolean isReferenceCacheIntegrationTimeCheck() {
        return this.getPropertyBool("measurement", "referenceCacheIntegrationTimeCheck", true);
    }

    public void setReferenceCacheIntegrationTimeCheck(boolean bl) {
        this.setPropertyBool("measurement", "referenceCacheIntegrationTimeCheck", bl);
    }

    public File getCameraFile(Camera camera, String string, File file) {
        String string2 = this.getCameraProperty(camera, string, null);
        return string2 == null || string2.isEmpty() ? file : new File(string2);
    }

    public void setCameraFile(Camera camera, String string, File file) {
        this.setCameraProperty(camera, string, file != null ? file.getAbsolutePath() : null);
    }

    public String getCameraProperty(Camera camera, String string, String string2) {
        return this.getProperty(this.getCameraPath(camera), string, string2);
    }

    public void setCameraProperty(Camera camera, String string, String string2) {
        this.setProperty(this.getCameraPath(camera), string, string2);
    }

    public void setCameraProperty(Camera camera, String string, String string2, Map<String, String> map) {
        this.setProperty(this.getCameraPath(camera), string, string2, map);
    }

    public double getCameraPropertyDouble(Camera camera, String string, int n) {
        return Double.parseDouble(this.getCameraProperty(camera, string, String.valueOf(n)));
    }

    public float getCameraPropertyFloat(Camera camera, String string, int n) {
        return (float)this.getCameraPropertyDouble(camera, string, n);
    }

    public int getCameraPropertyInt(Camera camera, String string, int n) {
        return (int)this.getCameraPropertyDouble(camera, string, n);
    }

    public boolean getCameraPropertyBool(Camera camera, String string, boolean bl) {
        return Boolean.parseBoolean(this.getCameraProperty(camera, string, String.valueOf(bl)));
    }

    public String getCameraTypeProperty(Camera camera, CameraType cameraType, String string, String string2) {
        return this.getProperty(this.getCameraTypePath(camera, cameraType), string, string2);
    }

    public Pair<String, String> getCameraTypePropertyWithAttribute(Camera camera, CameraType cameraType, String string, String string2) {
        String string3 = this.getCameraTypePath(camera, cameraType) + "/" + string;
        Node node = this.getPropertyNode(string3);
        return Pair.of((Object)node.getTextContent(), (Object)XmlParserHelper.getAttribute(node, string2));
    }

    public SimulatorDirectorySettings getSimulatorDirectoryData(Camera camera, CameraType cameraType) {
        String string = this.getCameraTypePath(camera, cameraType) + "/directory";
        Node node = this.getPropertyNode(string);
        String string2 = XmlParserHelper.getAttribute(node, "usingDirectoryData");
        String string3 = XmlParserHelper.getAttribute(node, "isAutomatic");
        SimulatorDirectorySettings simulatorDirectorySettings = new SimulatorDirectorySettings();
        simulatorDirectorySettings.setPath(node.getTextContent());
        simulatorDirectorySettings.setUsingDirectoryData(string2 == null || Boolean.parseBoolean(string2));
        simulatorDirectorySettings.setAutomatic(string3 == null || Boolean.parseBoolean(string3));
        return simulatorDirectorySettings;
    }

    public double getCameraTypePropertyDouble(Camera camera, CameraType cameraType, String string, double d) {
        return RtDataFormat.toNumber(this.getCameraTypeProperty(camera, cameraType, string, RtDataFormat.toString(d)));
    }

    public float getCameraTypePropertyFloat(Camera camera, CameraType cameraType, String string, float f) {
        return RtDataFormat.toNumberFloat(this.getCameraTypeProperty(camera, cameraType, string, RtDataFormat.toString(f)));
    }

    public int getCameraTypePropertyInt(Camera camera, CameraType cameraType, String string, int n) {
        return (int)this.getCameraTypePropertyDouble(camera, cameraType, string, n);
    }

    public boolean getCameraTypePropertyBool(Camera camera, CameraType cameraType, String string, boolean bl) {
        return Boolean.parseBoolean(this.getCameraTypeProperty(camera, cameraType, string, String.valueOf(bl)));
    }

    public void setCameraTypeProperty(Camera camera, CameraType cameraType, String string, String string2) {
        this.setProperty(this.getCameraTypePath(camera, cameraType), string, string2);
    }

    public void setCameraTypePropertyFloat(Camera camera, CameraType cameraType, String string, float f) {
        this.setPropertyFloat(this.getCameraTypePath(camera, cameraType), string, f);
    }

    public void setCameraTypeProperty(Camera camera, CameraType cameraType, String string, String string2, Map<String, String> map) {
        this.setProperty(this.getCameraTypePath(camera, cameraType), string, string2, map);
    }

    public File getCameraTypeFile(Camera camera, CameraType cameraType, String string) {
        String string2 = this.getCameraTypeProperty(camera, cameraType, string, null);
        return StringUtils.isEmpty((CharSequence)string2) ? null : new File(string2);
    }

    public void setCameraTypeFile(Camera camera, CameraType cameraType, String string, File file) {
        this.setCameraTypeProperty(camera, cameraType, string, file != null ? file.getAbsolutePath() : null);
    }

    public void setCameraMode(Camera camera, CameraType cameraType, CameraMode cameraMode) {
        String string = this.getCameraTypePath(camera, cameraType) + "/Mode";
        this.properties.setPropertyLocal(string, cameraMode.getName(), Collections.singletonMap("id", cameraMode.getId()));
    }

    public CameraMode getCameraMode(Camera camera, CameraType cameraType, CameraMode cameraMode) {
        String string = this.getCameraTypePath(camera, cameraType) + "/Mode";
        if (!this.hasProperty(string)) {
            this.setCameraMode(camera, cameraType, cameraMode);
            return cameraMode;
        }
        Node node = this.getPropertyNode(string);
        return new CameraMode(XmlParserHelper.getAttribute(node, "id", "0"), node.getTextContent());
    }

    private String getCameraTypePath(Camera camera, CameraType cameraType) {
        return this.getCameraPath(camera) + "/" + cameraType.getXmlNodeName();
    }

    private String getCameraPath(Camera camera) {
        return this.getCameraRootPath(camera.getId()) + "/" + camera.getXmlNodeName();
    }

    private String getCameraRootPath(int n) {
        return n == 0 ? "cameras" : "cameras" + (n + 1);
    }

    public double getOutputPropertyDouble(Output output, String string, double d) {
        return Double.parseDouble(this.getOutputProperty(output, string, String.valueOf(d)));
    }

    public int getOutputPropertyInt(Output output, String string, int n) {
        return (int)this.getOutputPropertyDouble(output, string, n);
    }

    public String getOutputProperty(Output output, String string, String string2) {
        return this.getProperty("outputs/" + output.getXmlNodeName(), string, string2);
    }

    public void setOutputProperty(Output output, String string, String string2) {
        this.setProperty("outputs/" + output.getXmlNodeName(), string, string2);
    }

    public void setWhiteReferenceDelay(Time time) {
        this.setPropertyInt("measurement", "whiteRefValid", (int)time.toSeconds());
    }

    public Time getWhiteReferenceDelay() {
        return this.getReferenceDelay("whiteRefValid", "whiteRefDelay");
    }

    public void setDarkReferenceDelay(Time time) {
        this.setPropertyInt("measurement", "darkRefValid", (int)time.toSeconds());
    }

    public Time getDarkReferenceDelay() {
        return this.getReferenceDelay("darkRefValid", "darkRefDelay");
    }

    private Time getReferenceDelay(String string, String string2) {
        int n = this.hasProperty("measurement", string2) ? this.getPropertyInt("measurement", string2, 0) / 1000 : 0;
        return new Time.Seconds((double)this.getPropertyInt("measurement", string, n));
    }

    public void setWhiteReferenceFrames(FrameCount frameCount) {
        this.setPropertyInt("measurement", "referenceFrames", frameCount.value);
    }

    public FrameCount getWhiteReferenceFrames() {
        return new FrameCount(this.getPropertyInt("measurement", "referenceFrames", WorkspaceManager.GUITEST ? 25 : 200));
    }

    public FrameCount getDarkReferenceFrames() {
        return new FrameCount(this.getPropertyInt("measurement", "darkReferenceFrames", this.getWhiteReferenceFrames().value));
    }

    public void setDarkReferenceFrames(FrameCount frameCount) {
        this.setPropertyInt("measurement", "darkReferenceFrames", frameCount.value);
    }

    public void setUseWhiteIntensity(boolean bl) {
        this.setProperty("measurement", "whiteReferenceData", bl ? "intensity" : "raw");
    }

    public boolean useWhiteIntensity() {
        return Objects.equals(this.getProperty("measurement", "whiteReferenceData", "intensity"), "intensity");
    }

    public void setWhiteReferenceCaptureMode(ReferenceSettings.ReferenceAction referenceAction) {
        this.setProperty("measurement", "whiteReferenceCaptureMode", referenceAction.name());
    }

    public ReferenceSettings.ReferenceAction getWhiteReferenceCaptureMode() {
        return ReferenceSettings.ReferenceAction.valueOf(this.getProperty("measurement", "whiteReferenceCaptureMode", ReferenceSettings.ReferenceAction.CaptureNew.name()));
    }

    public void setDarkReferenceCaptureMode(ReferenceSettings.ReferenceAction referenceAction) {
        this.setProperty("measurement", "darkReferenceCaptureMode", referenceAction.name());
    }

    public ReferenceSettings.ReferenceAction getDarkReferenceCaptureMode() {
        return ReferenceSettings.ReferenceAction.valueOf(this.getProperty("measurement", "darkReferenceCaptureMode", ReferenceSettings.ReferenceAction.CaptureNew.name()));
    }

    public void setShowDarkReferenceWizardStep(boolean bl) {
        this.setPropertyBool("measurement", "showTakeDarkReferenceWizardStep", bl);
    }

    public boolean showDarkReferenceWizardStep() {
        return this.getPropertyBool("measurement", "showTakeDarkReferenceWizardStep", false);
    }

    public void setExpertMode(boolean bl) {
        this.setPropertyBool("measurement", "expertMode", bl);
    }

    public boolean isExpertMode() {
        return this.getPropertyBool("measurement", "expertMode", false);
    }

    public void setNameTemplate(String string) {
        this.setProperty("measurement", "nameTemplate", string);
    }

    public String getNameTemplate() {
        return this.getProperty("measurement", "nameTemplate", "");
    }

    public void setMaxFrameCount(FrameCount frameCount) {
        this.setPropertyInt("measurement", "maxFrameCount", frameCount.value);
    }

    public FrameCount getMaxFrameCount() {
        return new FrameCount(this.getPropertyInt("measurement", "maxFrameCount", 1000));
    }

    public List<PPExportBreezeRuntime.MandatoryRuntimeParameter> getParameters(Workflow workflow) {
        Object object;
        ArrayList<PPExportBreezeRuntime.MandatoryRuntimeParameter> arrayList = new ArrayList<PPExportBreezeRuntime.MandatoryRuntimeParameter>();
        Node node = this.getPropertyNode("measurement", "mandatoryFields");
        if (node != null) {
            object = XmlParserHelper.getNodeList(node, "field").iterator();
            while (object.hasNext()) {
                Node node2 = (Node)object.next();
                String string = XmlParserHelper.getAttribute(node2, "name");
                String string2 = XmlParserHelper.getAttribute(node2, "unit");
                float f = XmlParserHelper.getFloatAttribute(node2, "min", 0.0f);
                float f2 = XmlParserHelper.getFloatAttribute(node2, "max", 2.1474836E9f);
                float f3 = XmlParserHelper.getFloatAttribute(node2, "step", 1.0E-4f);
                arrayList.add(new PPExportBreezeRuntime.MandatoryRuntimeParameter(string, f, f2, f3, 0.0f, string2));
            }
        }
        if (arrayList.isEmpty() && (object = workflow.getFirstMeasurementWithDataCheckStudyContext()) != null && ((Measurement)object).isDeeTeeCamera()) {
            arrayList.add(new PPExportBreezeRuntime.MandatoryRuntimeParameter("GeneratorVoltage", 0.0f, 160.0f, 1.0f, 0.0f, "kV"));
            arrayList.add(new PPExportBreezeRuntime.MandatoryRuntimeParameter("GeneratorCurrent", 0.0f, 10.0f, 0.1f, 0.0f, "mA"));
        }
        return arrayList;
    }

    public void setShowNotificationOnMeasurements(boolean bl) {
        this.setPropertyBool("measurement", "measurementNotifications", bl);
    }

    public boolean isShowNotificationOnMeasurements() {
        return this.getPropertyBool("measurement", "measurementNotifications", true);
    }

    public void setFrameRateDisplayMode(Camera.FpsUnit fpsUnit) {
        this.setProperty("measurement", "frameRateDisplayMode", fpsUnit.name());
    }

    public Camera.FpsUnit getFrameRateDisplayUnit() {
        return Camera.FpsUnit.parse(this.getProperty("measurement", "frameRateDisplayMode", "framePeriod"));
    }

    public int getModellingDefaultNumberOfSamplesToInclude() {
        return this.getPropertyInt("modelling", "defaultNumberOfSamplesToInclude", 9);
    }

    public double getModellingDefaultExcludeWavelengthsBeginningPercent() {
        return this.getPropertyDouble("modelling", "excludeWavelengthsBeginningPercent", 0.0);
    }

    public double getModellingDefaultExcludeWavelengthsEndPercent() {
        return this.getPropertyDouble("modelling", "excludeWavelengthsEndPercent", 0.0);
    }

    public void setDefaultNonClassifiedValue(String string) {
        this.setProperty("modelling", "nonClassifiedValue", string);
    }

    public String getDefaultNonClassifiedValue() {
        return this.getProperty("modelling", "nonClassifiedValue", "-");
    }

    public String getTheme() {
        return this.getProperty("gui", "theme", "classic");
    }

    public void setTheme(String string) {
        this.withoutToaster(() -> this.setProperty("gui", "theme", string));
    }

    public int getEntryWidth() {
        return Math.max(340, this.getEntryWidthByResolution());
    }

    private int getEntryWidthByResolution() {
        if (ScreenResolution.getInstance().getMode().equals((Object)ScreenResolution.ResolutionMode.Low)) {
            return this.getPropertyInt("gui", "entryWidthLowRes", 380);
        }
        return this.getPropertyInt("gui", "entryWidth", 420);
    }

    public void setTableCellHeight(int n) {
        this.setPropertyInt("gui", "tableCellHeight", n);
    }

    public int getTableCellHeight() {
        return this.getPropertyInt("gui", "tableCellHeight", 40);
    }

    public void setTableCellWidth(int n) {
        this.setPropertyInt("gui", "tableCellWidth", n);
    }

    public int getTableCellWidth() {
        return this.getPropertyInt("gui", "tableCellWidth", 200);
    }

    public String getExportOption(String string, String string2) {
        return this.getProperty("gui", string, string2);
    }

    public void setExportOption(String string, String string2) {
        this.setProperty("gui", string, string2);
    }

    public void setExportOption(String string, boolean bl) {
        this.setPropertyBool("gui", string, bl);
    }

    public boolean isExportOption(String string, boolean bl) {
        return this.getPropertyBool("gui", string, bl);
    }

    public String getFavorites() {
        return this.getProperty("gui", "favorites", "");
    }

    public VisualisationNode.ColorScale getColorScale() {
        if (BreezeProperties.getWorkspace() != null) {
            try {
                Node node = this.getPropertyNode("gui", "colorScale");
                if (StringUtils.isEmpty((CharSequence)node.getTextContent())) {
                    node.setTextContent("jet");
                    XmlParserHelper.setAttribute(node, "reverse", false);
                }
                return new VisualisationNode.ColorScale(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new VisualisationNode.ColorScale("jet");
    }

    public boolean isShowUpdateDialog() {
        return this.getPropertyBool("gui", "showUpdateDialog", true);
    }

    public void setShowUpdateDialog(boolean bl) {
        this.setPropertyBool("gui", "showUpdateDialog", bl);
    }

    public boolean isShowWelcomeMessage() {
        Node node = this.getPropertyNode("gui", "showWelcomeMessage");
        String string = XmlParserHelper.getAttribute(node, "version", "");
        String string2 = InitClass.getBreezeVersion().formatMajorMinor();
        return Boolean.parseBoolean(node.getTextContent()) || !string.equals(string2);
    }

    public void setShowWelcomeMessage(boolean bl) {
        this.withoutToaster(() -> {
            Node node = this.getPropertyNode("gui", "showWelcomeMessage");
            node.setTextContent(Boolean.toString(bl));
            XmlParserHelper.setAttribute(node, "version", InitClass.getBreezeVersion().formatMajorMinor());
            this.properties.saveProperties();
        });
    }

    public int getAndIncrementShowSupportExpiredCount() {
        IntHolder intHolder = new IntHolder(0);
        this.withoutToaster(() -> {
            int n = this.getPropertyInt("gui", "supportExpiredShowCount", 0);
            this.setPropertyInt("gui", "supportExpiredShowCount", n + 1);
            intHolder.setValue(n);
        });
        return intHolder.getValue();
    }

    public String getVisualisationDirection() {
        return this.getProperty("gui/visualisation", "direction", "vertical");
    }

    public void setVisualisationDirection(String string) {
        this.setProperty("gui/visualisation", "direction", string);
    }

    public String getVisualisationHorizontalDirection() {
        return this.getProperty("gui/visualisation", "horizontalDirection", "right");
    }

    public void setVisualisationHorizontalDirection(String string) {
        this.setProperty("gui/visualisation", "horizontalDirection", string);
    }

    public String getVisualisationVerticalDirection() {
        return this.getProperty("gui/visualisation", "verticalDirection", "up");
    }

    public void setVisualisationVerticalDirection(String string) {
        this.setProperty("gui/visualisation", "verticalDirection", string);
    }

    public void setDiagnosticPath(File file) {
        this.setProperty("gui", "diagnosticPath", file.getAbsolutePath());
    }

    public File getDiagnosticPath() {
        String string = DiagnosticHelper.getDefaultFolder().getAbsolutePath();
        String string2 = this.getProperty("gui", "diagnosticPath", string);
        return string2 == null || string2.isEmpty() ? new File(string) : new File(string2);
    }

    public boolean isBlend() {
        return this.getPropertyBool("gui", "blend", true);
    }

    public void setBlend(boolean bl) {
        this.withoutToaster(() -> this.setProperty("gui", "blend", String.valueOf(bl)));
    }

    public boolean isSortByName() {
        return this.getPropertyBool("gui/visualisation", "sortByname", true);
    }

    public void setSortByName(boolean bl) {
        this.withoutToaster(() -> this.setProperty("gui/visualisation", "sortByname", String.valueOf(bl)));
    }

    public boolean isShowIncluded() {
        return this.getPropertyBool("gui/visualisation", "onlyInluded", false);
    }

    public void setShowInlcuded(boolean bl) {
        this.withoutToaster(() -> this.setProperty("gui/visualisation", "onlyInluded", String.valueOf(bl)));
    }

    public boolean isShowHardwareSettings() {
        return this.getPropertyBool("gui/settings", "showHardware", true);
    }

    public void setShowHardwareSettings(boolean bl) {
        this.withoutToaster(() -> this.setProperty("gui/settings", "showHardware", String.valueOf(bl)));
    }

    public double getMaxMemoryRatio() {
        return this.getPropertyDouble("gui", "maxMemoryRatio", 0.25);
    }

    public void setNumberOfCameras(int n) {
        this.withoutToaster(() -> this.setPropertyInt("gui", "numberOfCameras", n));
    }

    public int getNumberOfCameras() {
        return this.getPropertyInt("gui", "numberOfCameras", WorkspaceManager.GUITEST ? 2 : 1);
    }

    public void setSort(String string, ListHelper.SortType sortType, boolean bl) {
        Node node = this.getPropertyNode("gui", string);
        node.setTextContent(sortType.name().toLowerCase());
        XmlParserHelper.setAttribute(node, "ascending", bl);
        this.properties.saveProperties();
    }

    public ListHelper.SortType getSortType(String string) {
        return ListHelper.SortType.parse(this.getProperty("gui", string, ""));
    }

    public boolean isSortAscending(String string) {
        return XmlParserHelper.getBooleanAttribute(this.getPropertyNode("gui", string), "ascending", string.equalsIgnoreCase("sortMeasurement"));
    }

    public int getMinBandsCountForHistogram() {
        return this.getPropertyInt("measurement", "minBandCountHistogram", 10);
    }

    public void setMinBandsCountForHistogram(int n) {
        this.setPropertyInt("measurement", "minBandCountHistogram", n);
    }

    public double getWavelengthMatchingTolerance() {
        return this.getPropertyDouble("measurement", "wavelengthMatchingTolerance", 50.0);
    }

    public void setWavelengthMatchingTolerance(double d) {
        this.setPropertyDouble("measurement", "wavelengthMatchingTolerance", d);
    }

    public void setTestingInstance(BreezeProperties breezeProperties) {
        instance = breezeProperties;
    }

    public void withBreezeProperties(BreezeProperties breezeProperties, Runnable runnable) {
        instance = breezeProperties;
        try {
            runnable.run();
        }
        finally {
            instance = null;
        }
    }

    static {
        lock = new Object();
    }

    public static class SimulatorDirectorySettings {
        private String path;
        private boolean usingDirectoryData;
        private boolean isAutomatic;

        @Generated
        public SimulatorDirectorySettings() {
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public boolean isUsingDirectoryData() {
            return this.usingDirectoryData;
        }

        @Generated
        public boolean isAutomatic() {
            return this.isAutomatic;
        }

        @Generated
        public void setPath(String string) {
            this.path = string;
        }

        @Generated
        public void setUsingDirectoryData(boolean bl) {
            this.usingDirectoryData = bl;
        }

        @Generated
        public void setAutomatic(boolean bl) {
            this.isAutomatic = bl;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SimulatorDirectorySettings)) {
                return false;
            }
            SimulatorDirectorySettings simulatorDirectorySettings = (SimulatorDirectorySettings)object;
            if (!simulatorDirectorySettings.canEqual(this)) {
                return false;
            }
            if (this.isUsingDirectoryData() != simulatorDirectorySettings.isUsingDirectoryData()) {
                return false;
            }
            if (this.isAutomatic() != simulatorDirectorySettings.isAutomatic()) {
                return false;
            }
            String string = this.getPath();
            String string2 = simulatorDirectorySettings.getPath();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        @Generated
        protected boolean canEqual(Object object) {
            return object instanceof SimulatorDirectorySettings;
        }

        @Generated
        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isUsingDirectoryData() ? 79 : 97);
            n = n * 59 + (this.isAutomatic() ? 79 : 97);
            String string = this.getPath();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            return n;
        }

        @Generated
        public String toString() {
            return "BreezeProperties.SimulatorDirectorySettings(path=" + this.getPath() + ", usingDirectoryData=" + this.isUsingDirectoryData() + ", isAutomatic=" + this.isAutomatic() + ")";
        }
    }

    public static class MockBreezeProperties
    extends BreezeProperties {
        public MockBreezeProperties() {
            super(new XmlProperties(){
                private final HashMap<String, String> properties = new HashMap();

                @Override
                public File getPropertyFile() {
                    return null;
                }

                @Override
                public void saveProperties() {
                }

                @Override
                protected synchronized String changeProperty(String string, String string2, boolean bl) {
                    if (bl || !this.properties.containsKey(string)) {
                        this.properties.put(string, string2);
                        return string2;
                    }
                    return this.properties.get(string);
                }
            });
        }

        @Override
        public void reload() {
        }
    }
}

