/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util;

import java.io.File;
import java.nio.file.Paths;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.common.util.StringFromFile;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.test.SlowTestCategory;

@Category(value={SlowTestCategory.class})
public class BreezePropertiesTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void writesAndReadsMeasureLength() {
        DummyBreezeProperties dummyBreezeProperties = new DummyBreezeProperties(this);
        BreezeProperties.getInstance().withBreezeProperties(dummyBreezeProperties, () -> {
            dummyBreezeProperties.setMeasureLength(new MeasurementLength(554.0f));
            MatcherAssert.assertThat((Object)dummyBreezeProperties.getMeasurementLength(), (Matcher)CoreMatchers.is((Object)new MeasurementLength(554.0f)));
        });
    }

    @Test
    public void writesAndReadsCameraFile() {
        DummyBreezeProperties dummyBreezeProperties = new DummyBreezeProperties(this);
        BreezeProperties.getInstance().withBreezeProperties(dummyBreezeProperties, () -> {
            FakeCamera fakeCamera = new FakeCamera();
            File file = Paths.get("/foo", "bar", "mp.txt").toFile();
            dummyBreezeProperties.setCameraFile(fakeCamera, "file", file);
            dummyBreezeProperties.assertContainsString("foo");
            dummyBreezeProperties.assertContainsString("bar");
            dummyBreezeProperties.assertContainsString("mp.txt");
            MatcherAssert.assertThat((Object)dummyBreezeProperties.getCameraFile(fakeCamera, "file", null), (Matcher)CoreMatchers.is((Object)file.getAbsoluteFile()));
        });
    }

    @Test
    public void cameraFileReturnsNullOnUnset() {
        DummyBreezeProperties dummyBreezeProperties = new DummyBreezeProperties(this);
        BreezeProperties.getInstance().withBreezeProperties(dummyBreezeProperties, () -> MatcherAssert.assertThat((Object)dummyBreezeProperties.getCameraFile(new FakeCamera(), "file", null), (Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void storesCameraFileNullCorrectly() {
        DummyBreezeProperties dummyBreezeProperties = new DummyBreezeProperties(this);
        BreezeProperties.getInstance().withBreezeProperties(dummyBreezeProperties, () -> {
            FakeCamera fakeCamera = new FakeCamera();
            dummyBreezeProperties.setCameraFile(fakeCamera, "file", null);
            MatcherAssert.assertThat((Object)dummyBreezeProperties.getCameraFile(new FakeCamera(), "file", null), (Matcher)CoreMatchers.nullValue());
        });
    }

    private class DummyBreezeProperties
    extends BreezeProperties {
        public DummyBreezeProperties(BreezePropertiesTest breezePropertiesTest) {
            super(new XmlProperties(){

                @Override
                public File getPropertyFile() {
                    return new File(BreezePropertiesTest.this.tempFolder.getRoot(), "dummy.xml");
                }
            });
        }

        public void assertContainsString(String string) {
            MatcherAssert.assertThat((Object)new StringFromFile(this.properties.getPropertyFile()).toString(), (Matcher)CoreMatchers.containsString((String)string));
        }
    }
}

