/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import lombok.Generated;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeSliderUI
extends BasicSliderUI {
    public static final int TRACK_HEIGHT = 4;
    public static final int TRACK_WIDTH = 8;
    public static final int TRACK_ARC = 5;
    public static final Dimension THUMB_SIZE = new Dimension(12, 12);
    private final RoundRectangle2D.Float trackShape = new RoundRectangle2D.Float();
    private boolean pressed = false;
    private boolean hover = false;
    private final boolean isDirectionalThumb;
    private boolean noPaintFilledTrack;

    public BreezeSliderUI(JSlider jSlider) {
        this(jSlider, false);
    }

    public BreezeSliderUI(JSlider jSlider, boolean bl) {
        super(jSlider);
        this.isDirectionalThumb = bl;
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(final JSlider jSlider) {
        return new BasicSliderUI.TrackListener(this){
            final /* synthetic */ BreezeSliderUI this$0;
            {
                this.this$0 = breezeSliderUI;
                super(breezeSliderUI);
            }

            private boolean isOverThumb(MouseEvent mouseEvent) {
                return mouseEvent != null && jSlider.isEnabled() && this.this$0.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                this.setThumbHover(this.isOverThumb(mouseEvent));
                super.mouseEntered(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                this.setThumbHover(false);
                super.mouseExited(mouseEvent);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                this.setThumbHover(this.isOverThumb(mouseEvent));
                super.mouseMoved(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.setThumbPressed(this.isOverThumb(mouseEvent));
                if (!jSlider.isEnabled()) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                this.this$0.calculateGeometry();
                if (this.this$0.thumbRect.contains(n, n2)) {
                    super.mousePressed(mouseEvent);
                    return;
                }
                int n3 = ((BreezeSliderUI)this.this$0).thumbRect.x + ((BreezeSliderUI)this.this$0).thumbRect.width / 2 - n;
                int n4 = ((BreezeSliderUI)this.this$0).thumbRect.y + ((BreezeSliderUI)this.this$0).thumbRect.height / 2 - n2;
                mouseEvent.translatePoint(n3, n4);
                super.mousePressed(mouseEvent);
                mouseEvent.translatePoint(-n3, -n4);
                this.mouseDragged(mouseEvent);
                this.setThumbPressed(true);
            }

            private void setThumbHover(boolean bl) {
                if (bl != this.this$0.hover) {
                    this.this$0.hover = bl;
                    jSlider.repaint(this.this$0.thumbRect);
                }
            }

            private void setThumbPressed(boolean bl) {
                if (this.this$0.pressed != bl) {
                    this.this$0.pressed = bl;
                    jSlider.repaint(this.this$0.thumbRect);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.this$0.pressed = false;
                super.mouseReleased(mouseEvent);
            }
        };
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.isHorizontal()) {
            this.trackRect.y += (this.trackRect.height - 4) / 2;
            this.trackRect.height = 4;
        } else {
            this.trackRect.x += (this.trackRect.width - 8) / 2;
            this.trackRect.width = 8;
        }
        this.trackShape.setRoundRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height, 5.0f, 5.0f);
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.isHorizontal()) {
            this.thumbRect.y = this.trackRect.y + (this.trackRect.height - this.thumbRect.height) / 2;
        } else {
            this.thumbRect.x = this.trackRect.x + (this.trackRect.width - this.thumbRect.width) / 2;
        }
    }

    @Override
    protected Dimension getThumbSize() {
        return THUMB_SIZE;
    }

    private boolean isHorizontal() {
        return this.slider.getOrientation() == 0;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(graphics, jComponent);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        boolean bl = this.slider.getInverted();
        graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
        graphics2D.fill(this.trackShape);
        graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
        graphics2D.setClip(this.trackShape);
        this.trackShape.y += 1.0f;
        graphics2D.fill(this.trackShape);
        this.trackShape.y = this.trackRect.y;
        graphics2D.setClip(shape);
        if (this.noPaintFilledTrack) {
            return;
        }
        if (this.isHorizontal()) {
            boolean bl2 = this.slider.getComponentOrientation().isLeftToRight();
            if (bl2) {
                bl = !bl;
            }
            int n = this.thumbRect.x + this.thumbRect.width / 2;
            if (bl) {
                graphics2D.clipRect(0, 0, n, this.slider.getHeight());
            } else {
                graphics2D.clipRect(n, 0, this.slider.getWidth() - n, this.slider.getHeight());
            }
        } else {
            int n = this.thumbRect.y + this.thumbRect.height / 2;
            if (bl) {
                graphics2D.clipRect(0, 0, this.slider.getHeight(), n);
            } else {
                graphics2D.clipRect(0, n, this.slider.getWidth(), this.slider.getHeight() - n);
            }
        }
        if (this.slider.isEnabled()) {
            graphics2D.setColor(BreezeTheme.getInstance().getProgressBarColor());
        } else {
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundDifuse());
        }
        graphics2D.fill(this.trackShape);
        graphics2D.setClip(shape);
    }

    @Override
    public void paintThumb(Graphics graphics) {
        if (this.slider.isEnabled() && this.slider.getMinimum() != this.slider.getMaximum()) {
            if (this.pressed) {
                graphics.setColor(BreezeTheme.getInstance().getSliderThumbColor().brighter());
            } else if (this.hover) {
                graphics.setColor(BreezeTheme.getInstance().getSliderThumbFocusColor());
            } else {
                graphics.setColor(BreezeTheme.getInstance().getSliderThumbColor());
            }
        } else {
            graphics.setColor(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse());
        }
        if (this.isDirectionalThumb) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.translate(this.thumbRect.x, this.thumbRect.y);
            graphics2D.fill(BreezeSliderUI.createDirectionalThumbShape(0.0f, 0.0f, 12.0f, 15.0f));
            graphics2D.dispose();
        } else {
            graphics.fillOval(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        }
    }

    public static Shape createDirectionalThumbShape(float f, float f2, float f3, float f4) {
        float f5 = f3 / 2.0f;
        Path2D.Float float_ = new Path2D.Float(1, 9);
        ((Path2D)float_).moveTo(f + f5, f2 + f4);
        ((Path2D)float_).lineTo(f, f2 + (f4 - f5));
        ((Path2D)float_).lineTo(f, f2);
        ((Path2D)float_).quadTo(f, f2, f, f2);
        ((Path2D)float_).lineTo(f + f3, f2);
        ((Path2D)float_).quadTo(f + f3, f2, f + f3, f2);
        ((Path2D)float_).lineTo(f + f3, f2 + (f4 - f5));
        float_.closePath();
        return float_;
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    @Generated
    public void setNoPaintFilledTrack(boolean bl) {
        this.noPaintFilledTrack = bl;
    }
}

