/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class BreezeUser {
    private String username;
    private String firstName;
    private String lastName;
    private String password;
    private Role role;

    public BreezeUser(String string, String string2, String string3, String string4, Role role) {
        this.username = string;
        this.password = string2;
        this.firstName = string3;
        this.lastName = string4;
        this.role = role;
    }

    public BreezeUser(Node node) {
        this.username = XmlParserHelper.getAttribute(node, "username");
        if (this.username == null) {
            throw new RuntimeException("Username is not valid: " + this.username);
        }
        this.firstName = XmlParserHelper.getAttribute(node, "firstname");
        this.lastName = XmlParserHelper.getAttribute(node, "lastname");
        this.role = Role.parse(XmlParserHelper.getAttribute(node, "role"));
        this.password = node.getTextContent();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getPassword() {
        return this.password;
    }

    public Role getRole() {
        return this.role;
    }

    public String getUsername() {
        return this.username;
    }

    public void setFirstName(String string) {
        this.firstName = string;
    }

    public void setLastName(String string) {
        this.lastName = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.firstName != null) {
            stringBuilder.append(this.firstName);
        }
        if (this.lastName != null && this.lastName.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.lastName);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(this.username);
        }
        return stringBuilder.toString();
    }

    public void save(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "user");
        element2.setAttribute("username", this.username);
        element2.setAttribute("firstname", this.firstName);
        element2.setAttribute("lastname", this.lastName);
        element2.setAttribute("role", this.role.name());
        XmlParserHelper.addCDATA(element2, this.password);
    }

    public boolean isAdmin() {
        return this.role.equals((Object)Role.Administrator);
    }

    public boolean canModel() {
        return true;
    }

    public static enum Role {
        Administrator,
        Expert,
        Recorder,
        Viewer;


        public static Role parse(String string) {
            for (Role role : Role.values()) {
                if (!role.name().equalsIgnoreCase(string)) continue;
                return role;
            }
            return Administrator;
        }
    }
}

