/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.IntHolder;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.DeleteEntryCustomPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezePasswordField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.BreezeUser;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class BreezeUserManager {
    private static BreezeUserManager manager;
    private final List<BreezeUser> userList = new ArrayList<BreezeUser>();
    private boolean enabled;
    private static BreezeUser breezeUser;

    public static BreezeUserManager getInstance() {
        if (manager == null) {
            manager = new BreezeUserManager();
        }
        return manager;
    }

    public static void clearInstance() {
        manager = null;
    }

    public static boolean hasAccess(AccessRight accessRight) {
        BreezeUser breezeUser = BreezeUserManager.getBreezeUser();
        if (breezeUser != null) {
            return BreezeUserManager.hasAccess(accessRight, breezeUser.getRole());
        }
        return true;
    }

    private static boolean hasAccess(AccessRight accessRight, BreezeUser.Role role) {
        switch (accessRight.ordinal()) {
            case 0: {
                if (!role.equals((Object)BreezeUser.Role.Viewer)) break;
                return false;
            }
            case 1: {
                if (!role.equals((Object)BreezeUser.Role.Viewer)) break;
                return false;
            }
            case 2: {
                if (!role.equals((Object)BreezeUser.Role.Viewer) && !role.equals((Object)BreezeUser.Role.Recorder)) break;
                return false;
            }
        }
        return true;
    }

    public BreezeUserManager() {
        Node node = BreezeProperties.getInstance().getPropertyNode("users");
        if (node != null) {
            this.enabled = XmlParserHelper.getBooleanAttribute(node, "enabled", false);
            String string = XmlParserHelper.getAttribute(node, "default");
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals("user")) continue;
                try {
                    BreezeUser breezeUser = new BreezeUser(node2);
                    if (BreezeUserManager.breezeUser == null || string != null && string.equalsIgnoreCase(breezeUser.getUsername())) {
                        BreezeUserManager.breezeUser = breezeUser;
                    }
                    this.userList.add(breezeUser);
                    continue;
                }
                catch (Exception exception) {
                    Logg.error((String)"Cannot parse user", (Throwable)exception);
                }
            }
        }
        if (this.userList.isEmpty()) {
            this.userList.add(new BreezeUser("admin", "", "Administrator", "", BreezeUser.Role.Administrator));
            this.saveChanges();
        }
    }

    public void saveChanges() {
        Element element = (Element)BreezeProperties.getInstance().getPropertyNode("users");
        if (element != null) {
            element.setAttribute("enabled", Boolean.toString(this.enabled));
            if (breezeUser != null) {
                element.setAttribute("default", breezeUser.getUsername());
            }
            NodeList nodeList = element.getChildNodes();
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                element.removeChild(nodeList.item(i));
            }
            for (BreezeUser breezeUser : this.userList) {
                breezeUser.save(element);
            }
        }
        BreezeProperties.getInstance(false).save();
    }

    public List<BreezeUser> getUserList() {
        return this.userList;
    }

    public static BreezeUser getBreezeUser() {
        return breezeUser;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void showLoginDialog(final BreezeFrame breezeFrame, final LoginCallback loginCallback, LoginException loginException) {
        BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Login", "", (AbstractBreezeCustomPanel)new BreezeLoginPanel(breezeFrame.getProduct(), loginException), null, new BreezeActionListener(){
            final /* synthetic */ BreezeUserManager this$0;
            {
                this.this$0 = breezeUserManager;
            }

            @Override
            public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                BreezeLoginPanel breezeLoginPanel = (BreezeLoginPanel)breezeActionEvent.getBreezeCustomPanel();
                try {
                    loginCallback.login(BreezeUserManager.getInstance().login(breezeLoginPanel.getUser(), breezeLoginPanel.getPassword()));
                }
                catch (LoginException loginException) {
                    this.this$0.showLoginDialog(breezeFrame, loginCallback, loginException);
                }
            }

            @Override
            public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                loginCallback.cancelled();
            }
        });
    }

    public BreezeUser login(String string, String string2) {
        breezeUser = this.findUser(string, string2);
        if (breezeUser != null) {
            return this.login(breezeUser);
        }
        throw new LoginException("You have entered incorrect username or password");
    }

    public BreezeUser login(BreezeUser breezeUser, String string) {
        if (breezeUser.getPassword().equals(string)) {
            return this.login(breezeUser);
        }
        throw new LoginException("You have entered incorrect password");
    }

    private BreezeUser login(BreezeUser breezeUser) {
        BreezeUserManager.breezeUser = breezeUser;
        this.saveChanges();
        return BreezeUserManager.breezeUser;
    }

    private BreezeUser findUser(String string, String string2) {
        BreezeUser breezeUser = this.findUser(string);
        if (breezeUser != null && breezeUser.getPassword().equals(string2)) {
            return breezeUser;
        }
        return null;
    }

    public BreezeUser findUser(String string) {
        for (BreezeUser breezeUser : this.userList) {
            if (!breezeUser.getUsername().equals(string)) continue;
            return breezeUser;
        }
        return null;
    }

    public static String md5(String string) {
        return BreezeUserManager.toHex(MessageDigest.getInstance("MD5").digest(string.getBytes(StandardCharsets.UTF_8)));
    }

    public static String toHex(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        return String.format("%0" + (byArray.length << 1) + "X", bigInteger);
    }

    static {
        breezeUser = new BreezeUser("Administrator", "", "Administrator", "", BreezeUser.Role.Administrator);
    }

    public static enum AccessRight {
        CanDelete,
        Settings,
        AnalyseTree;

    }

    public static class BreezeLoginPanel
    extends AbstractBreezeCustomPanel {
        private final BreezeComboBox usernameComboBox = new BreezeComboBox();
        private final BreezePasswordField passwordField = new BreezePasswordField();
        private InformationPanel informationPanel;

        public BreezeLoginPanel(UpdateHelper.Product product, LoginException loginException) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            this.add((Component)new DeleteEntryCustomPanel.TextArea("Welcome to " + StringHelper.formatLabel(product.toString()) + ". Please login"), GridBagHelper.create(this.getComponentCount(), new Insets(24, 12, 12, 12)));
            for (BreezeUser breezeUser : BreezeUserManager.getInstance().getUserList()) {
                this.usernameComboBox.addItem(breezeUser);
            }
            this.usernameComboBox.setSelectedItem(BreezeUserManager.getBreezeUser());
            this.usernameComboBox.setFocusable(false);
            this.add((Component)this.usernameComboBox, GridBagHelper.create(this.getComponentCount(), new Insets(12, 24, 0, 24)));
            this.add((Component)new BreezeLabel("Password:"), GridBagHelper.create(this.getComponentCount(), new Insets(12, 24, 0, 24)));
            this.add((Component)this.passwordField, GridBagHelper.create(this.getComponentCount(), new Insets(12, 24, 12, 24)));
            this.add((Component)new JLabel(""), GridBagHelper.create(0, this.getComponentCount(), 1.0, 1.0, 1, new Insets(0, 0, 0, 0)));
            if (loginException != null) {
                this.informationPanel = new InformationPanel(loginException.getMessage());
                this.add((Component)this.informationPanel, GridBagHelper.create(this.getComponentCount(), new Insets(0, 24, 0, 24)));
            }
        }

        @Override
        public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
            breezeButton2.setText("Login");
        }

        @Override
        public void onShow() {
            SwingUtilities.invokeLater(this.passwordField::requestFocus);
            if (this.informationPanel != null) {
                this.informationPanel.blink();
            }
        }

        @Override
        public Object getResult() {
            return null;
        }

        public BreezeUser getUser() {
            return (BreezeUser)this.usernameComboBox.getSelectedItem();
        }

        public String getPassword() {
            if (this.passwordField.isEmpty()) {
                return "";
            }
            return this.passwordField.getValue();
        }
    }

    private static class LoginException
    extends ErrorHandler.InformationMessageException {
        public LoginException(String string) {
            super(string);
        }
    }

    public static interface LoginCallback {
        public void login(BreezeUser var1);

        public void cancelled();
    }

    private static class InformationPanel
    extends JPanel {
        private final BreezeLabel label;

        public InformationPanel(String string) {
            super(new GridBagLayout());
            this.setBackground(new Color(249, 175, 178));
            this.label = new BreezeLabel(string);
            this.label.setIcon(new ImageIcon(this.getClass().getResource("/images/informationRedSmall.png")));
            this.label.setFontSize(BreezeLabel.FontSize.H3);
            this.add((Component)this.label, GridBagHelper.create(0, 0, 1.0, 1.0, 1, new Insets(8, 12, 8, 12)));
        }

        public void blink() {
            IntHolder intHolder = new IntHolder(0);
            Timer timer = new Timer(300, null);
            timer.addActionListener(actionEvent -> {
                intHolder.add(1);
                int n = intHolder.getValue();
                if (n % 2 == 0) {
                    this.label.setForeground(Color.black);
                } else {
                    this.label.setForeground(this.getBackground());
                }
                if (n > 1) {
                    timer.stop();
                }
            });
            timer.start();
        }
    }
}

