/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Base64;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.commons.io.FilenameUtils;
import org.imgscalr.Scalr;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class ImageHelper {
    private static final int entryPanelFolderWidth = 80;
    private static final int entryPanelFolderHeight = 80;
    private static final int entryPanelFolderDesiredWidth = 62;
    private static final BufferedImage folderBack;
    private static final BufferedImage folderFront;

    public static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static ImageIcon rescaleIcon(ImageIcon imageIcon, float f) {
        Image image = imageIcon.getImage();
        BufferedImage bufferedImage = ImageHelper.imageToBufferedImage(image);
        RescaleOp rescaleOp = new RescaleOp(f, 15.0f, null);
        rescaleOp.filter(bufferedImage, bufferedImage);
        return new ImageIcon(bufferedImage);
    }

    public static BufferedImage getImageInFolderImageIcon(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(80, 80, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        float f = 80.0f / (float)folderBack.getWidth();
        int n = (int)((float)folderBack.getWidth() * f) - 2;
        int n2 = (int)((float)folderBack.getHeight() * f);
        int n3 = (80 - n2) / 2;
        graphics2D.drawImage(folderBack, 2, n3, n, n2, null);
        double d = 62.0 / (double)bufferedImage.getWidth();
        int n4 = (int)((double)bufferedImage.getHeight() * d);
        BufferedImage bufferedImage3 = ImageHelper.getScaledImage(bufferedImage, 62, n4, null, Scalr.Method.SPEED);
        if (n4 > 55) {
            int n5 = Math.min(n4, 60);
            graphics2D.drawImage(bufferedImage3, 15, (80 - n5) / 2, 62, n5, 0, 0, 62, n5, null);
        } else {
            int n6 = (80 - n4) / 2;
            graphics2D.drawImage(bufferedImage3, 15, n6, 62, n4, null);
        }
        graphics2D.drawImage(folderFront, 2, n3, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static Image makeColorTransparent(BufferedImage bufferedImage, final Color color) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            public final int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int n, int n2, int n3) {
                if ((n3 | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & n3;
                }
                return n3;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static BufferedImage rotate(Image image, double d) {
        double d2 = Math.abs(Math.sin(Math.toRadians(d)));
        double d3 = Math.abs(Math.cos(Math.toRadians(d)));
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = (int)Math.floor((double)n * d3 + (double)n2 * d2);
        int n4 = (int)Math.floor((double)n2 * d3 + (double)n * d2);
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate((n3 - n) / 2, (n4 - n2) / 2);
        graphics2D.rotate(Math.toRadians(d), n / 2, n2 / 2);
        graphics2D.drawRenderedImage(ImageHelper.imageToBufferedImage(image), null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static Image scaleImageKeepRatio(Image image, int n, int n2) {
        double d;
        double d2 = (double)n / (double)image.getWidth(null);
        if (d2 > (d = (double)n2 / (double)image.getHeight(null))) {
            n = (int)((double)n / d2 * d);
            d2 = d;
        } else {
            n2 = (int)((double)n2 / d * d2);
            d = d2;
        }
        return image.getScaledInstance(n, n2, 4);
    }

    public static BufferedImage scaleImage(Image image, int n, int n2, boolean bl) {
        Image image2 = image.getScaledInstance(n, n2, 4);
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            int n5 = image.getWidth(null);
            int n6 = image.getHeight(null);
            n3 = (n5 - n) / 2;
            n4 = (n6 - n2) / 2;
            n = n5;
            n2 = n6;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image2, n3, n4, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage scaleImagePercent(Image image, double d, double d2, boolean bl) {
        return ImageHelper.scaleImage(image, (int)((double)image.getWidth(null) * d), (int)((double)image.getHeight(null) * d2), bl);
    }

    public static BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2, Color color) {
        return ImageHelper.getScaledImage(bufferedImage, n, n2, color, Scalr.Method.ULTRA_QUALITY);
    }

    public static BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2, Color color, Scalr.Method method) {
        if (bufferedImage != null && n > 0 && n2 > 0) {
            int n3;
            int n4;
            double d = (double)bufferedImage.getWidth() / (double)bufferedImage.getHeight();
            if ((double)n / d <= (double)n2) {
                n4 = n;
                n3 = (int)((double)n / d);
            } else {
                n4 = (int)((double)n2 * d);
                n3 = n2;
            }
            int n5 = color == null ? 2 : 1;
            BufferedImage bufferedImage2 = new BufferedImage(n, n2, n5);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            if (color != null) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, 0, n, n2);
            }
            int n6 = (n - n4) / 2;
            int n7 = (n2 - n3) / 2;
            if (method.equals((Object)Scalr.Method.ULTRA_QUALITY)) {
                graphics2D.drawImage((Image)Scalr.resize((BufferedImage)bufferedImage, (Scalr.Method)method, (int)n4, (int)n3, (BufferedImageOp[])new BufferedImageOp[0]), n6, n7, null);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawImage(bufferedImage, n6, n7, n4, n3, null);
            }
            graphics2D.dispose();
            return bufferedImage2;
        }
        return null;
    }

    public static boolean isGrayscaleIcon(ImageIcon imageIcon) {
        return ImageHelper.isGrayscaleIcon(imageIcon, true);
    }

    public static boolean isGrayscaleIcon(ImageIcon imageIcon, boolean bl) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        if (!bl || n == n2) {
            BufferedImage bufferedImage = ImageHelper.imageToBufferedImage(imageIcon.getImage());
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[4];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    writableRaster.getPixel(i, j, nArray);
                    if (nArray[3] < 100 || Math.abs(nArray[0] - nArray[1]) <= 10 && Math.abs(nArray[1] - nArray[2]) <= 10 && nArray[0] != 255) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static ImageIcon changeGrayBrightnessDarkTheme(ImageIcon imageIcon) {
        return ImageHelper.changeGrayBrightness(imageIcon, 75);
    }

    public static ImageIcon changeGrayBrightness(ImageIcon imageIcon, int n) {
        if (imageIcon != null) {
            return new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(imageIcon.getImage().getSource(), new GrayFilter(true, n))));
        }
        return null;
    }

    public static BufferedImage read(URL uRL) {
        try {
            return ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static BufferedImage read(File file) {
        try {
            return ImageIO.read(file);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot read file: " + file.getAbsolutePath(), iOException);
        }
    }

    public static BufferedImage rotateImage(BufferedImage bufferedImage, int n) {
        double d = Math.PI / 180 * (double)n;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = n == 90 || n == 270 ? new BufferedImage(bufferedImage.getHeight(), bufferedImage.getWidth(), bufferedImage.getType()) : new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (n == 90) {
            graphics2D.translate((n3 - n2) / 2, (n3 - n2) / 2);
            graphics2D.rotate(d, n3 / 2, n2 / 2);
        } else if (n == 270) {
            graphics2D.translate((n2 - n3) / 2, (n2 - n3) / 2);
            graphics2D.rotate(d, n3 / 2, n2 / 2);
        } else {
            graphics2D.translate(0, 0);
            graphics2D.rotate(d, n2 / 2, n3 / 2);
        }
        graphics2D.drawRenderedImage(bufferedImage, null);
        return bufferedImage2;
    }

    public static String imgToBase64String(RenderedImage renderedImage) {
        String string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write(renderedImage, "jpg", byteArrayOutputStream);
            string = Base64.getUrlEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        byteArrayOutputStream.close();
        return string;
    }

    public static BufferedImage base64StringToImg(String string) {
        BufferedImage bufferedImage;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.getUrlDecoder().decode(string));
        try {
            bufferedImage = ImageIO.read(byteArrayInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        byteArrayInputStream.close();
        return bufferedImage;
    }

    public static ImageIcon shapeToImageIcon(Shape shape, int n, int n2, Color color, Color color2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(color2);
        graphics2D.fill(shape);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static BufferedImage combineImagesVerticallyWithScaling(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = Math.max(bufferedImage.getWidth(), bufferedImage2.getWidth());
        BufferedImage bufferedImage3 = ImageHelper.scaleImage(bufferedImage, n);
        BufferedImage bufferedImage4 = ImageHelper.scaleImage(bufferedImage2, n);
        int n2 = bufferedImage3.getHeight() + bufferedImage4.getHeight();
        BufferedImage bufferedImage5 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage5.createGraphics();
        graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
        graphics2D.drawImage((Image)bufferedImage4, 0, bufferedImage3.getHeight(), null);
        graphics2D.dispose();
        return bufferedImage5;
    }

    public static ImageIcon tintIconWithColor(ImageIcon imageIcon, Color color) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    private static BufferedImage scaleImage(BufferedImage bufferedImage, int n) {
        int n2 = (int)((double)bufferedImage.getHeight() * ((double)n / (double)bufferedImage.getWidth()));
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static ImageIcon replaceTransparentBackgroundWithColor(ImageIcon imageIcon, Color color) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        graphics2D.fillRoundRect(0, 0, n, n2, 10, 10);
        graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon createHoverIcon(ImageIcon imageIcon) {
        int n = BreezeTheme.getInstance().isDarkMode() ? 110 : 150;
        return ImageHelper.replaceTransparentBackgroundWithColor(imageIcon, new Color(n, n, n, 150));
    }

    public static ImageIcon getResourceIconRecord() {
        return ImageHelper.getResourceIcon(BreezeType.Recorder);
    }

    public static ImageIcon getResourceIconPlay() {
        return ImageHelper.getResourceIcon(BreezeType.Workflow);
    }

    public static ImageIcon getResourceIcon(BreezeType breezeType) {
        return ImageHelper.getResourceIcon(breezeType.getIcon());
    }

    public static ImageIcon getResourceIcon(String string) {
        return ImageHelper.getResourceIcon(string, true);
    }

    public static ImageIcon getResourceIcon(String string, boolean bl) {
        return ImageHelper.getResourceIcon(string, bl, false);
    }

    public static ImageIcon getResourceIcon(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        URL uRL = ImageHelper.class.getResource("/images/" + FilenameUtils.removeExtension((String)string) + ".png");
        if (uRL == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(uRL);
        if (bl2 || bl && BreezeTheme.getInstance().isDarkMode() && ImageHelper.isGrayscaleIcon(imageIcon)) {
            return ImageHelper.changeGrayBrightnessDarkTheme(imageIcon);
        }
        return imageIcon;
    }

    public static void main(String[] stringArray) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new File("C:\\Users\\thoma\\BreezeWorkspaces\\Release2411\\Record\\Nuts_Classification\\Test\\Mix\\measurement_raw.png"));
        BufferedImage bufferedImage2 = ImageHelper.getImageInFolderImageIcon(bufferedImage);
        JFrame jFrame = new JFrame("Image Test");
        jFrame.setDefaultCloseOperation(3);
        JLabel jLabel = new JLabel(new ImageIcon(bufferedImage2));
        jFrame.getContentPane().add((Component)jLabel, "Center");
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    static {
        try {
            folderBack = ImageIO.read(Objects.requireNonNull(ImageHelper.class.getResourceAsStream("/images/folder_back.png")));
            folderFront = ImageIO.read(Objects.requireNonNull(ImageHelper.class.getResourceAsStream("/images/folder_front.png")));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

