/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.backend.entry.RtWorkflow;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.ArrayTreeModel;
import se.prediktera.breeze.frontend.common.swing.BreezeListInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;

public class ListHelper {
    public static void addItem(BreezeTree breezeTree, Object object) {
        ArrayTreeModel arrayTreeModel = (ArrayTreeModel)breezeTree.getModel();
        arrayTreeModel.getList().add(object);
        breezeTree.setSelectedValue(object);
    }

    public static void addItem(JList jList, Object object) {
        ArrayListModel arrayListModel = (ArrayListModel)jList.getModel();
        arrayListModel.addElement(object);
        try {
            jList.setSelectedValue(object, true);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static SwapIndex movedown(JList jList, SwapIndexCallback swapIndexCallback) {
        int n = jList.getSelectedIndex();
        ArrayListModel arrayListModel = (ArrayListModel)jList.getModel();
        if (n >= 0 && n < arrayListModel.getSize() - 1) {
            return ListHelper.swapIndex(jList, n, n + 1, swapIndexCallback);
        }
        return null;
    }

    public static SwapIndex moveup(JList jList, SwapIndexCallback swapIndexCallback) {
        int n = jList.getSelectedIndex();
        if (n > 0) {
            return ListHelper.swapIndex(jList, n, n - 1, swapIndexCallback);
        }
        return null;
    }

    public static SwapIndex swapIndex(JList jList, int n, int n2, SwapIndexCallback swapIndexCallback) {
        ArrayListModel arrayListModel = (ArrayListModel)jList.getModel();
        if (swapIndexCallback.canSwap(n) && swapIndexCallback.canSwap(n2)) {
            arrayListModel.swapElement(n, n2);
            jList.setSelectedIndex(n2);
            return new SwapIndex(n, n2);
        }
        return null;
    }

    public static Object removeItem(JList jList, Object object) {
        if (object != null) {
            int n;
            ArrayListModel arrayListModel = (ArrayListModel)jList.getModel();
            int n2 = arrayListModel.removeElement(object);
            if (n2 < (n = arrayListModel.getSize())) {
                jList.setSelectedIndex(n2);
            } else if (n > 0) {
                jList.setSelectedIndex(n - 1);
            }
            return object;
        }
        return null;
    }

    public static void sort(List list, SortType sortType, boolean bl) {
        Collections.sort(list, ListHelper.comparator(sortType, bl));
    }

    public static Comparator<? super Object> comparator(SortType sortType, boolean bl) {
        return (object, object2) -> {
            int n = object instanceof Entry && object2 instanceof Entry ? ((Entry)object).getEntryData().compareTo(sortType, ((Entry)object2).getEntryData()) : (object instanceof RtWorkflow && object2 instanceof RtWorkflow ? ((RtWorkflow)object).compareTo(sortType, (RtWorkflow)object2) : object.toString().compareToIgnoreCase(object2.toString()));
            return (bl ? 1 : -1) * n;
        };
    }

    public static void sortEntriesByDate(List<? extends BasicEntry> list) {
        list.sort((basicEntry, basicEntry2) -> {
            Date date = basicEntry.getEntryData().getModifiedOrCreatedDate();
            Date date2 = basicEntry2.getEntryData().getModifiedOrCreatedDate();
            if (date != null && date2 != null) {
                return date2.compareTo(date);
            }
            return 0;
        });
    }

    public static interface SwapIndexCallback {
        public boolean canSwap(int var1);
    }

    public static class SwapIndex {
        public final int from;
        public final int to;

        public SwapIndex(int n, int n2) {
            this.from = n;
            this.to = n2;
        }
    }

    public static enum SortType {
        Name,
        Created,
        Modified;


        public static SortType parse(String string) {
            for (SortType sortType : SortType.values()) {
                if (!sortType.name().equalsIgnoreCase(string)) continue;
                return sortType;
            }
            return Created;
        }
    }

    public static class DoubleClickedClass
    extends MouseAdapter {
        private static final long DOUBLEPRESSTIME = 500L;
        private long whenLastPressed = 0L;
        private Object entryLastPressed = null;
        private final BreezeListInterface list;
        private final ActionListener listener;

        public DoubleClickedClass(BreezeListInterface breezeListInterface, ActionListener actionListener) {
            this.list = breezeListInterface;
            this.listener = actionListener;
            breezeListInterface.addMouseListener(this);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.list.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                long l = mouseEvent.getWhen();
                long l2 = l - this.whenLastPressed;
                Object object = this.list.getObjectAt(mouseEvent.getPoint());
                if (l2 <= 500L && object == this.entryLastPressed && object != null) {
                    this.listener.actionPerformed(new ActionEvent(object, 0, ""));
                }
                this.whenLastPressed = l;
                this.entryLastPressed = object;
            }
        }
    }
}

