/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util.xmlproperties;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import se.prediktera.breeze.common.util.StringFromFile;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.map.common.error.Logg;

@Category(value={SlowTestCategory.class})
public class XmlParserHelperTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void shouldEncodeXmlOnDiskInUTF8() throws Exception {
        if (Charset.defaultCharset().displayName().equals("UTF-8")) {
            Logg.warn((String)"Default charset is set to UTF-8 - this test will be worthless. It should be run with some old encoding like 'windows-1252'", (Object[])new Object[0]);
        }
        File file = new File(this.tempFolder.getRoot(), "test.xml");
        Document document = this.createEmptyDoc();
        Element element = document.createElement("test");
        element.setTextContent("\u00f6\u00f6\u00f6");
        document.appendChild(element);
        XmlProperties.outputXML(file, document);
        MatcherAssert.assertThat((String)"string parsed with utf-8 actually contains \u00f6\u00f6\u00f6", (Object)new StringFromFile(file, StandardCharsets.UTF_8).toString(), (Matcher)CoreMatchers.containsString((String)"\u00f6\u00f6\u00f6"));
    }

    private Document createEmptyDoc() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.newDocument();
    }
}

