/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util.xmlproperties;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertiesHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;

public abstract class XmlProperties
implements Serializable {
    public static final String DEFAULT_ROOT_NAME = "root";
    private Node rootProperty = null;
    private String rootName = "root";
    private boolean showToasterMessage = true;
    private String toasterMessage = null;
    private int saveIndex;

    public XmlProperties() {
        this(DEFAULT_ROOT_NAME, null);
    }

    public XmlProperties(String string, String string2) {
        this.rootName = string;
        this.toasterMessage = string2;
        this.createRoot();
    }

    public boolean getPropertyBoolLocal(String string, boolean bl) {
        try {
            return Boolean.parseBoolean(this.changeProperty(string, String.valueOf(bl), false));
        }
        catch (NumberFormatException numberFormatException) {
            return bl;
        }
    }

    public double getPropertyDoubleLocal(String string, double d) {
        try {
            return Double.parseDouble(this.changeProperty(string, String.valueOf(d), false));
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public int getPropertyIntLocal(String string, int n) {
        try {
            return Integer.parseInt(this.changeProperty(string, String.valueOf(n), false));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public int[][] getPropertyIntMatrixLocal(String string, int[][] nArray) {
        return XmlPropertiesHelper.parseIntArray(this.changeProperty(string, XmlPropertiesHelper.createArrayString(nArray), false));
    }

    public float[][] getPropertyFloatMatrixLocal(String string, float[][] fArray) {
        return XmlPropertiesHelper.parseFloatArray(this.changeProperty(string, XmlPropertiesHelper.createArrayString(fArray), false));
    }

    public String getPropertyLocal(String string, String string2) {
        return this.changeProperty(string, string2, false);
    }

    public boolean hasPropertyNodeLocal(String string) {
        return XmlProperties.getOrCreatePath(this.rootProperty, string, false) != null;
    }

    public Node getPropertyNodeLocal(String string) {
        Pair<Node, Boolean> pair = XmlProperties.getOrCreatePath(this.rootProperty, string);
        if (((Boolean)pair.getRight()).booleanValue() && this.getPropertyFile() != null) {
            this.saveProperties();
        }
        return (Node)pair.getLeft();
    }

    public Node getRootProperty() {
        return this.rootProperty;
    }

    public void withoutToaster(Runnable runnable) {
        try {
            this.showToasterMessage = false;
            runnable.run();
        }
        finally {
            this.showToasterMessage = true;
        }
    }

    public void saveProperties() {
        this.accessFileAndReadCreateOrSave(false);
        if (this.showToasterMessage && this.toasterMessage != null) {
            ToastHandler.getInstance().showToast(BreezeFrame.getInstance(), this.toasterMessage);
        }
    }

    public void removeProperty(String string) {
        if (this.rootProperty == null) {
            return;
        }
        Node node = (Node)XmlProperties.getOrCreatePath(this.rootProperty, string).getLeft();
        Node node2 = node.getParentNode();
        if (node2 != null) {
            node2.removeChild(node);
            this.saveProperties();
        }
    }

    public String setPropertyBoolLocal(String string, boolean bl) {
        return this.setPropertyLocal(string, Boolean.toString(bl));
    }

    public String setPropertyLocal(String string, String string2) {
        return this.changeProperty(string, string2, true);
    }

    public String setPropertyLocal(String string, String string2, Map<String, String> map) {
        return this.changeProperty(string, string2, true, map);
    }

    public void setPropertyMatrixFloatLocal(String string, float[][] fArray) {
        this.changeProperty(string, XmlPropertiesHelper.createArrayString(fArray), true);
    }

    public void setPropertyMatrixLocal(String string, int[][] nArray) {
        this.changeProperty(string, XmlPropertiesHelper.createArrayString(nArray), true);
    }

    public void setRootProperty(Node node) {
        this.rootProperty = node;
    }

    public abstract File getPropertyFile();

    protected String getRootName() {
        return this.rootName;
    }

    public synchronized void accessFileAndReadCreateOrSave(boolean bl) {
        File file = this.getPropertyFile();
        if (bl) {
            if (file.exists() && file.length() > 0L) {
                NodeList nodeList = XmlParserHelper.parseXML(file);
                this.rootProperty = XmlParserHelper.getNodeRecursive(nodeList, this.getRootName());
            } else {
                if (file.exists()) {
                    ErrorHandler.logAndReportException((String)"BreezeProperties is empty", (Throwable)new RuntimeException());
                }
                this.createRoot();
                this.saveProperties();
            }
        } else if (this.rootProperty != null && file != null) {
            XmlProperties.removeEmptyText(this.rootProperty);
            XmlProperties.outputXML(file, this.rootProperty.getOwnerDocument());
            this.increaseSaveIndex();
        }
    }

    public void increaseSaveIndex() {
        ++this.saveIndex;
    }

    public int getSaveIndex() {
        return this.saveIndex;
    }

    private static void removeEmptyText(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2.getNodeType() == 3) {
                String string = node2.getTextContent();
                if (string == null || string.trim().isEmpty()) {
                    node.removeChild(node2);
                }
            } else {
                XmlProperties.removeEmptyText(node2);
            }
            node2 = node3;
        }
    }

    protected synchronized String changeProperty(String string, String string2, boolean bl) {
        return this.changeProperty(string, string2, bl, null);
    }

    protected synchronized String changeProperty(String string, String string2, boolean bl, Map<String, String> map) {
        boolean bl2;
        boolean bl3 = bl2 = this.getPropertyFile() != null;
        if (this.rootProperty != null) {
            Pair<Node, Boolean> pair = XmlProperties.getOrCreatePath(this.rootProperty, string);
            Node node = (Node)pair.getLeft();
            if (((Boolean)pair.getRight()).booleanValue() || bl && this.hasChanged(string2, map, node)) {
                node.setTextContent(string2);
                if (map != null) {
                    for (String string3 : map.keySet()) {
                        ((Element)node).setAttribute(string3, map.get(string3));
                    }
                }
                if (bl2) {
                    this.saveProperties();
                }
            } else {
                return node.getTextContent();
            }
        }
        return string2;
    }

    private boolean hasChanged(String string, Map<String, String> map, Node node) {
        String string2 = node.getTextContent();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if ((map == null || map.size() == 0) && namedNodeMap.getLength() == 0) {
            return !StringHelper.equals((String)string2, (String)string);
        }
        if (map == null || map.size() != namedNodeMap.getLength()) {
            return true;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Node node2 = namedNodeMap.getNamedItem(entry.getKey());
            if (node2 != null && StringHelper.equals((String)node2.getTextContent(), (String)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private void createRoot() {
        Document document = XmlParserHelper.createXMLdoc();
        this.rootProperty = document.createElement(this.getRootName());
        document.appendChild(this.rootProperty);
    }

    public static void addProperties(XmlProperties xmlProperties, Document document, Element element) {
        Node node;
        Node node2;
        if (xmlProperties != null && (node2 = XmlProperties.deepCloneElement(document, node = xmlProperties.getRootProperty())) != null) {
            element.appendChild(node2);
            XmlProperties.deepCloneAppend(document, node, node2);
        }
    }

    private static Node deepCloneElement(Document document, Node node) {
        String string;
        if (node.getNodeType() == 1) {
            Element element = document.createElement(node.getNodeName());
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                element.setAttribute(node2.getNodeName(), node2.getNodeValue());
            }
            return element;
        }
        if (node.getNodeType() == 3 && !(string = node.getTextContent()).trim().isEmpty()) {
            return document.createTextNode(string);
        }
        return null;
    }

    private static void deepCloneAppend(Document document, Node node, Node node2) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            Node node4 = XmlProperties.deepCloneElement(document, node3);
            if (node4 == null) continue;
            node2.appendChild(node4);
            if (node4.getNodeType() != 1) continue;
            XmlProperties.deepCloneAppend(document, node3, node4);
        }
    }

    public static void ensureThatSettingsExists(XmlProperties xmlProperties, Node node, boolean bl) {
        if (!bl) {
            Element element = XmlParserHelper.addElement(node, "settings");
            xmlProperties.setRootProperty(element);
        }
    }

    public static Pair<Node, Boolean> getOrCreatePath(Node node, String string) {
        return XmlProperties.getOrCreatePath(node, string, true);
    }

    public static Pair<Node, Boolean> getOrCreatePath(Node node, String string, boolean bl) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        String[] stringArray = string.split("/");
        Node node2 = null;
        boolean bl2 = false;
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3;
            String string2;
            String string3 = string2 = stringArray2[i];
            String string4 = null;
            String string5 = "name";
            String string6 = null;
            int n2 = string3.indexOf("[");
            if (n2 >= 0) {
                string4 = string3.substring(n2 + 1, string3.length() - 1);
                stringArray3 = string4.split("=");
                string5 = stringArray3.length == 0 ? "name" : stringArray3[0];
                string6 = stringArray3[stringArray3.length - 1];
                string3 = string3.substring(0, n2);
            }
            if (node != null) {
                node2 = XmlParserHelper.getNode(node, string3, string4);
            }
            if (node2 == null) {
                if (bl) {
                    stringArray3 = node.getOwnerDocument();
                    Element element = XmlParserHelper.addElement(node, string3, null, (Document)stringArray3);
                    if (string4 != null) {
                        element.setAttribute(string5, string6);
                    }
                    node2 = element;
                    bl2 = true;
                } else {
                    return null;
                }
            }
            node = node2;
        }
        return Pair.of(node2, (Object)bl2);
    }

    public static void createDirectoriesAndOutputXML(File file, Document document) {
        file.getParentFile().mkdirs();
        XmlProperties.outputXML(file, document);
    }

    public static void outputXML(File file, Document document) {
        if (document == null) {
            return;
        }
        file.getParentFile().mkdirs();
        File file2 = null;
        try {
            file2 = FileHelper.createTempFileInWorkspace("xml");
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8);){
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.setOutputProperty("encoding", "UTF-8");
                StreamResult streamResult = new StreamResult(outputStreamWriter);
                DOMSource dOMSource = new DOMSource(document);
                transformer.transform(dOMSource, streamResult);
            }
            Files.move(file2.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            if (file2 != null && file2.exists()) {
                file2.delete();
            }
            Logg.error((String)"Error saving properties", (Throwable)exception);
        }
    }
}

