/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util.xmlproperties;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlPropertiesHelper;

public class XmlPropertiesHelperTest {
    @Test
    public void testParseInt() {
        int[][] nArray = XmlPropertiesHelper.parseIntArray("[2,2]1,-3,2,4");
        MatcherAssert.assertThat((Object)nArray.length, (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)nArray[0].length, (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)nArray[0][0], (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)nArray[1][0], (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)nArray[0][1], (Matcher)Matchers.is((Object)-3));
        MatcherAssert.assertThat((Object)nArray[1][1], (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testParseFloat() {
        float[][] fArray = XmlPropertiesHelper.parseFloatArray("[2,2]1.1,-3.2,2.3,4.4");
        MatcherAssert.assertThat((Object)fArray.length, (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)fArray[0].length, (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)Float.valueOf(fArray[0][0]), (Matcher)Matchers.is((Object)Float.valueOf(1.1f)));
        MatcherAssert.assertThat((Object)Float.valueOf(fArray[1][0]), (Matcher)Matchers.is((Object)Float.valueOf(2.3f)));
        MatcherAssert.assertThat((Object)Float.valueOf(fArray[0][1]), (Matcher)Matchers.is((Object)Float.valueOf(-3.2f)));
        MatcherAssert.assertThat((Object)Float.valueOf(fArray[1][1]), (Matcher)Matchers.is((Object)Float.valueOf(4.4f)));
    }

    @Test
    public void testParseFloat2() {
        float[][] fArray = XmlPropertiesHelper.parseFloatArray("[1,2]8.6035405E-4,8.6035405E4");
        MatcherAssert.assertThat((Object)Float.valueOf(fArray[0][0]), (Matcher)Matchers.is((Object)Float.valueOf(8.6035405E-4f)));
        MatcherAssert.assertThat((Object)Float.valueOf(fArray[0][1]), (Matcher)Matchers.is((Object)Float.valueOf(86035.41f)));
    }

    @Test
    public void testParseFloat3() {
        float[][] fArray = XmlPropertiesHelper.parseFloatArray("[1,2]8,-9");
        MatcherAssert.assertThat((Object)Float.valueOf(fArray[0][0]), (Matcher)Matchers.is((Object)Float.valueOf(8.0f)));
        MatcherAssert.assertThat((Object)Float.valueOf(fArray[0][1]), (Matcher)Matchers.is((Object)Float.valueOf(-9.0f)));
    }
}

