/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.util.xmlproperties;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.EntryWithSave;
import se.prediktera.breeze.common.entry.util.BasicTreeParentInterface;
import se.prediktera.breeze.common.realtime.descriptor.spatial.SpatialDescriptor;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.application.RuntimePredictionMode;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinner;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.settings.measurement.GeneralSettingsPanel;
import se.prediktera.map.main.ColorScalesHelper;
import se.prediktera.map.main.Main_GUI;
import se.prediktera.map.plot.axisplot.settings.Color.PlotContinuousColor;

public class XmlPropertyViewPanel
extends AbstractViewPanel {
    private final String path = "";
    private EntryWithSave pholder;
    private final JPanel centerPanel = new JPanel();

    public XmlPropertyViewPanel(EntryMainPanel entryMainPanel, EntryWithSave entryWithSave) {
        super(entryMainPanel);
        this.pholder = entryWithSave;
        this.setLayout(new BorderLayout());
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane();
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        this.add(breezeScrollPane, "Center");
        this.centerPanel.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.centerPanel.setLayout(new GridBagLayout());
        breezeScrollPane.setViewportView(this.centerPanel);
    }

    @Override
    public String getType() {
        return "PropertyPanel";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        Object object3;
        Node node2 = null;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (object instanceof ViewClass) {
            object3 = (ViewClass)object;
            Object object4 = ((ViewClass)object3).getValue();
            XmlProperties xmlProperties = null;
            if (object4 instanceof Entry) {
                Entry entry = (Entry)object4;
                xmlProperties = entry.getProperties();
                this.pholder = entry;
            }
            if (xmlProperties != null) {
                node2 = xmlProperties.getPropertyNodeLocal("");
            }
        } else if (object instanceof Node) {
            Node node3;
            node2 = node3 = (Node)object;
        } else if (object instanceof BasicTreeParentInterface) {
            BasicTreeParentInterface basicTreeParentInterface = (BasicTreeParentInterface)object;
            arrayList.addAll(basicTreeParentInterface.getChildren());
        }
        if (node2 != null) {
            object3 = node2.getChildNodes();
            for (int i = 0; i < object3.getLength(); ++i) {
                arrayList.add(object3.item(i));
            }
        }
        arrayList.sort(Comparator.comparing(node -> node.getNodeName().toLowerCase()));
        this.updatePanel(object, arrayList);
    }

    public void updatePanel(Object object, List list) {
        this.centerPanel.removeAll();
        int n = 0;
        this.add(new BreezeLabel("Name", true, 14), 0, n);
        this.add(new BreezeLabel("Value", true, 14), 1, n);
        ++n;
        for (Object e : list) {
            Object object2;
            Object object3;
            Node node = (Node)e;
            NodeList nodeList = node.getChildNodes();
            boolean bl2 = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() == 3) continue;
                bl2 = true;
            }
            if (bl2 || node.getNodeType() == 3) continue;
            String string2 = StringHelper.formatLabel(node.getNodeName());
            String string3 = node.getNodeName();
            String string4 = node.getTextContent();
            boolean bl3 = true;
            if (string3.equals("colorScale")) {
                this.add(new ColorScaleComboBoxPanel(new VisualisationNode.ColorScale(node), plotContinuousColor -> {
                    node.setTextContent(plotContinuousColor.getName());
                    XmlParserHelper.setAttribute(node, "reverse", plotContinuousColor.isReversed());
                    this.pholder.save();
                    DataSetCache.clearRecursive(this.pholder);
                    Main_GUI.updateColorScales((String)plotContinuousColor.getName(), (boolean)plotContinuousColor.isReversed());
                }), 1, n);
                bl3 = false;
            } else if (string3.equals("reduce")) {
                this.add(new ReduceComboBox(string4, reduceItem -> this.setTextContentAndSaveClearDataSetCache(node, String.valueOf(reduceItem.getIndex()))), 1, n);
            } else if (string3.equals("predictionMode")) {
                object3 = new RuntimePredictionMode(node);
                object2 = ((RtPredictionMode)object3).getMode();
                BreezeComboBox breezeComboBox = new BreezeComboBox();
                breezeComboBox.setRenderer(new RtPredictionMode.PredictionMode.PredictionModeCellRenderer());
                for (RtPredictionMode.PredictionMode predictionMode : RtPredictionMode.PredictionMode.values()) {
                    breezeComboBox.addItem((Object)predictionMode);
                }
                breezeComboBox.setSelectedItem(object2);
                breezeComboBox.setCallback(arg_0 -> this.lambda$updatePanel$2((RtPredictionMode.PredictionMode)((Object)object2), node, object, arg_0));
                RuntimePredictionMode.updatePredictionNode(node, (RtPredictionMode.PredictionMode)((Object)object2), ((RtPredictionMode)object3).getPredictionSetup());
                this.add(breezeComboBox, 1, n);
            } else if (string3.equals("referenceConvertTo")) {
                this.add(new ReferenceConvertToComboBox(this.mainpanel.getFrame(), this.mainpanel.getPageColor(), string4, string -> this.setTextContentAndSaveClearDataSetCache(node, string.toLowerCase())), 1, n);
            } else if (string3.equals("cvType")) {
                this.add(new CvTypeComboBox(string4, string -> this.setTextConentAndSave(node, string.toLowerCase())), 1, n);
            } else if (string3.equals("direction")) {
                this.add(new DirectionComboBox(string4, string -> this.setTextConentAndSave(node, string.toLowerCase())), 1, n);
            } else if (string3.equals("horizontalDirection")) {
                this.add(new HorizontalDirectionComboBox(string4, string -> this.setTextConentAndSave(node, string.toLowerCase())), 1, n);
            } else if (string3.equals("verticalDirection")) {
                this.add(new VerticalDirectionComboBox(string4, string -> this.setTextConentAndSave(node, string.toLowerCase())), 1, n);
            } else if (string3.equals("strayLightFile")) {
                this.add(new FileInputField((Component)this.mainpanel, "", string4, textActionEvent -> this.setTextContentAndSaveClearDataSetCache(node, textActionEvent.getFile() != null ? textActionEvent.getFile().getAbsolutePath() : "")), 1, n);
            } else if (BooleanCheckBox.isBoolean(string4)) {
                if (string3.equals("includeChildObjects")) {
                    string2 = "Flatten Child Objects";
                } else if (string3.equals("compressReferences")) {
                    string2 = "Store references as average value";
                } else if (string3.equals("showBackground")) {
                    string2 = "Show background layer";
                } else if (string3.equals("toggleCommens")) {
                    string2 = "Expand Comments field";
                }
                this.add(new BooleanCheckBox(string4, bl -> this.setTextConentAndSave(node, Boolean.toString(bl).toLowerCase())), 1, n);
            } else if (string3.equals("imageHistogramPercentage")) {
                this.add(new BreezeSpinner.PercentSpinner(RtDataFormat.toNumber(string4), d -> this.setTextConentAndSave(node, (double)d)), 1, n);
            } else if (string3.equals("maxSaturatedBand") || string3.equals("excludeWavelengthsBeginningPercent") || string3.equals("excludeWavelengthsEndPercent")) {
                this.add(new NumberTextField(string4, textActionEvent -> this.setTextContentAndSaveClearDataSetCache(node, textActionEvent.getText())), 1, n);
            } else if (string3.equals("imageHistogramRange")) {
                this.add(new BreezeTextField(string4, textActionEvent -> this.setTextConentAndSave(node, textActionEvent.getText())), 1, n);
            } else if (string3.equals("defaultUnit")) {
                this.add(new UnitComboBox(this.mainpanel.getFrame(), this.mainpanel.getPageColor(), SpatialDescriptor.SiUnit.parse(string4), siUnit -> this.setTextConentAndSave(node, siUnit.name())), 1, n);
            } else {
                this.add(new BreezeTextField(string4, textActionEvent -> this.setTextConentAndSave(node, textActionEvent.getText())), 1, n);
            }
            this.add(new BreezeLabel(string2, false, 14), 0, n);
            if (bl3 && (object3 = node.getAttributes()) != null && object3.getLength() > 0) {
                object2 = new JPanel(new GridBagLayout());
                ((JComponent)object2).setOpaque(false);
                int n2 = 0;
                XmlPropertyViewPanel.add((JPanel)object2, new BreezeLabel("Name", true), 0, n2, false);
                XmlPropertyViewPanel.add((JPanel)object2, new BreezeLabel("Value", true), 1, n2, false);
                ++n2;
                int n3 = 0;
                while (n3 < object3.getLength()) {
                    Node node2 = object3.item(n3);
                    String string5 = node2.getTextContent();
                    String string6 = node2.getNodeName();
                    String string7 = string6.equals("chunks") ? "Processing chunk size" : string6;
                    XmlPropertyViewPanel.add((JPanel)object2, new BreezeLabel(StringHelper.formatLabel(string7), false, 14), 0, n2, false);
                    JComponent jComponent = null;
                    jComponent = BooleanCheckBox.isBoolean(string5) ? new BooleanCheckBox(string5, bl -> this.setTextConentAndSave(node, Boolean.toString(bl).toLowerCase())) : new BreezeTextField(string5, textActionEvent -> this.setTextConentAndSave(node, textActionEvent.getText()));
                    XmlPropertyViewPanel.add((JPanel)object2, jComponent, 1, n2, false);
                    if (string6.equals("blendBackground")) {
                        n2 = XmlPropertyViewPanel.addUsage((JPanel)object2, n2, "The default behavior for if the RGB background should be blended into identified objects in the Data stream.");
                    } else if (string6.equals("bufferSize")) {
                        n2 = XmlPropertyViewPanel.addUsage((JPanel)object2, n2, "How many frames to buffer before processing. Must be an even number");
                    } else if (string6.equals("chunks")) {
                        n2 = XmlPropertyViewPanel.addUsage((JPanel)object2, n2, "The number of frames to predict at once");
                    } else if (string6.equals("lineBinning")) {
                        n2 = XmlPropertyViewPanel.addUsage((JPanel)object2, n2, "The number of result lines to merge into one to reduce the output size");
                    }
                    ++n3;
                    ++n2;
                }
                XmlPropertyViewPanel.add((JPanel)object2, new JLabel(""), 1, n2, true);
                XmlPropertyViewPanel.add(this.centerPanel, (JComponent)object2, 1, ++n, false);
            }
            ++n;
        }
        XmlPropertyViewPanel.add(this.centerPanel, new JLabel(""), 1, n, true);
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    private static int addUsage(JPanel jPanel, int n, String string) {
        BreezeLabel breezeLabel = new BreezeLabel(string);
        breezeLabel.setFont(new Font(breezeLabel.getFont().getFontName(), 2, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 0, 20);
        jPanel.add((Component)breezeLabel, gridBagConstraints);
        return n;
    }

    private void setTextContentAndSaveClearDataSetCache(Node node, String string) {
        this.setTextConentAndSave(node, string);
        DataSetCache.clearRecursive(this.pholder);
    }

    private void setTextConentAndSave(Node node, double d) {
        this.setTextConentAndSave(node, RtDataFormat.toString(d));
    }

    private void setTextConentAndSave(Node node, String string) {
        node.setTextContent(string);
        this.pholder.save();
    }

    private void add(JComponent jComponent, int n, int n2) {
        XmlPropertyViewPanel.add(this.centerPanel, jComponent, n, n2, false);
    }

    public static void add(JPanel jPanel, JComponent jComponent, int n, int n2, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 20, 0, 20);
        if (bl) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
        }
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    private /* synthetic */ void lambda$updatePanel$2(RtPredictionMode.PredictionMode predictionMode, Node node, Object object, Object object2) {
        if (object2 != predictionMode) {
            RuntimePredictionMode.updatePredictionNode(node, (RtPredictionMode.PredictionMode)((Object)object2), null);
            this.pholder.save();
            SwingUtilities.invokeLater(() -> this.showEntry(object, null));
        }
    }

    public static class ColorScaleComboBoxPanel
    extends JPanel {
        private final BreezeComboBox comboBox = new BreezeComboBox();
        private final BreezeCheckBox checkBox = new BreezeCheckBox("Reverse", false);
        private PlotContinuousColor selectedScale = null;

        public ColorScaleComboBoxPanel(VisualisationNode.ColorScale colorScale, BreezeComboBox.ItemCallback<PlotContinuousColor> itemCallback) {
            super(new GridBagLayout());
            this.setOpaque(false);
            this.comboBox.setRenderer(new ColorScaleCellRenderer(60));
            for (PlotContinuousColor plotContinuousColor : ColorScalesHelper.getInstance().getColorScales()) {
                PlotContinuousColor plotContinuousColor2 = (PlotContinuousColor)plotContinuousColor.cloneColors();
                this.comboBox.addItem(plotContinuousColor2);
                if (colorScale.reverse) {
                    plotContinuousColor2.reverseColors();
                }
                if (this.selectedScale != null && !plotContinuousColor2.getName().equalsIgnoreCase(colorScale.name)) continue;
                this.selectedScale = plotContinuousColor2;
            }
            this.comboBox.setSelectedItem(this.selectedScale);
            this.comboBox.setCallback(itemCallback);
            this.add((Component)this.comboBox, GridBagHelper.createWithWeigthX1(0, new Insets(0, 0, 0, 0)));
            this.checkBox.setSelected(this.selectedScale.isReversed());
            this.add((Component)this.checkBox, GridBagHelper.create(1, new Insets(2, 0, 0, 0)));
            this.checkBox.addActionListener(actionEvent -> {
                for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                    ((PlotContinuousColor)this.comboBox.getItemAt(i)).reverseColors();
                }
                this.comboBox.repaint();
                itemCallback.onItem((PlotContinuousColor)this.comboBox.getSelectedItem());
            });
        }

        public class ColorScaleCellRenderer
        extends JPanel
        implements ListCellRenderer {
            private final BreezeLabel label;
            private final ScalePanel colorPanel;

            public ColorScaleCellRenderer(int n) {
                super(new GridBagLayout());
                this.label = new BreezeLabel("", false, 14);
                this.colorPanel = new ScalePanel();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(0, 10, 0, 0);
                this.add((Component)this.label, gridBagConstraints);
                this.label.setMinimumSize(new Dimension(n, 30));
                this.label.setPreferredSize(new Dimension(n, 30));
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.fill = 1;
                gridBagConstraints2.gridx = 1;
                gridBagConstraints2.weightx = 1.0;
                gridBagConstraints2.weighty = 1.0;
                gridBagConstraints2.insets = new Insets(8, 20, 8, 10);
                this.add((Component)this.colorPanel, gridBagConstraints2);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                PlotContinuousColor plotContinuousColor = (PlotContinuousColor)object;
                if (plotContinuousColor != null) {
                    this.label.setText(plotContinuousColor.getName());
                    this.colorPanel.setScale(plotContinuousColor);
                }
                BreezeTheme breezeTheme = BreezeTheme.getInstance();
                if (bl) {
                    this.label.setForeground(Color.white);
                    this.setBackground(BreezeComboBox.selectionBackground);
                } else {
                    this.label.setForeground(breezeTheme.getLabelForeground());
                    this.setBackground(breezeTheme.getPanelBackground());
                }
                return this;
            }

            private class ScalePanel
            extends JPanel {
                private PlotContinuousColor scale;

                private ScalePanel() {
                }

                public void setScale(PlotContinuousColor plotContinuousColor) {
                    this.scale = plotContinuousColor;
                }

                @Override
                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    if (this.scale != null) {
                        int n = this.getWidth();
                        int n2 = this.getHeight();
                        int n3 = this.scale.getNrColors();
                        float f = (float)n / (float)n3;
                        float f2 = 0.0f;
                        for (int i = 0; i < n3; ++i) {
                            graphics.setColor(this.scale.getColor(i));
                            graphics.fillRect((int)f2, 0, (int)Math.ceil(f), n2);
                            f2 += f;
                        }
                    }
                }
            }
        }
    }

    public static class ReduceComboBox
    extends BreezeComboBox {
        public ReduceComboBox(String string, BreezeComboBox.ItemCallback<ReduceItem> itemCallback) {
            this(RtDataFormat.toNumberInt(string), itemCallback);
        }

        public ReduceComboBox(int n, BreezeComboBox.ItemCallback<ReduceItem> itemCallback) {
            this.addItem(new ReduceItem(0, "Automatic"));
            this.addItem(new ReduceItem(1, "Original"));
            for (int i = 2; i <= 10; ++i) {
                this.addItem(new ReduceItem(i, "Reduced by factor " + i));
            }
            this.setSelectedIndex(n);
            this.setCallback(itemCallback);
        }

        public static class ReduceItem {
            private final int index;
            private final String description;

            public ReduceItem(int n, String string) {
                this.index = n;
                this.description = string;
            }

            public int getIndex() {
                return this.index;
            }

            public String toString() {
                return this.description;
            }
        }
    }

    public static class ReferenceConvertToComboBox
    extends BreezeComboBox {
        private String currentItem;

        public ReferenceConvertToComboBox(BreezeFrame breezeFrame, Color color, String string, final BreezeComboBox.ItemCallback<String> itemCallback) {
            for (RtFramePredictor.ReferenceConvertTo referenceConvertTo : RtFramePredictor.ReferenceConvertTo.supported()) {
                this.addItem(referenceConvertTo.name());
            }
            this.currentItem = string;
            this.setSelectedString(this.currentItem);
            this.setCallback(object -> {
                final String string = object.toString().toLowerCase();
                if (string.equals(this.currentItem)) {
                    return;
                }
                BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Warning", "Changing the \"Convert to\" setting will change the data passed through the workflow analysis tree.\n\nThis can lead to segmentations disappearing, and sample information getting lost the next time you do Apply changes.\n\nDo you want to continue?", null, new BreezeActionListener(){
                    final /* synthetic */ ReferenceConvertToComboBox this$0;
                    {
                        this.this$0 = referenceConvertToComboBox;
                    }

                    @Override
                    public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                        this.this$0.currentItem = string;
                        itemCallback.onItem(this.this$0.currentItem);
                    }

                    @Override
                    public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                        this.this$0.setSelectedString(this.this$0.currentItem);
                    }
                });
            });
        }
    }

    public static class CvTypeComboBox
    extends BreezeComboBox {
        public CvTypeComboBox(String string, BreezeComboBox.ItemCallback<String> itemCallback) {
            this.addItem("EvenlySpread");
            this.addItem("Random");
            this.addItem("Leave-One-Out");
            this.addItem("Stratified");
            this.setSelectedString(string);
            this.setCallback(itemCallback);
        }
    }

    public static class DirectionComboBox
    extends BreezeComboBox {
        public DirectionComboBox(String string, BreezeComboBox.ItemCallback<String> itemCallback) {
            this.addItem("Vertical");
            this.addItem("Horizontal");
            this.setSelectedString(string);
            this.setCallback(itemCallback);
        }
    }

    public static class HorizontalDirectionComboBox
    extends BreezeComboBox {
        public HorizontalDirectionComboBox(String string, BreezeComboBox.ItemCallback<String> itemCallback) {
            this.addItem("Right");
            this.addItem("Left");
            this.setSelectedString(string);
            this.setCallback(itemCallback);
        }
    }

    public static class VerticalDirectionComboBox
    extends BreezeComboBox {
        public VerticalDirectionComboBox(String string, BreezeComboBox.ItemCallback<String> itemCallback) {
            this.addItem("Up");
            this.addItem("Down");
            this.setSelectedString(string);
            this.setCallback(itemCallback);
        }
    }

    public static class BooleanCheckBox
    extends BreezeCheckBox {
        public BooleanCheckBox(String string, BreezeCheckBox.CheckBoxCallback checkBoxCallback) {
            super("", string.equalsIgnoreCase("true"), checkBoxCallback);
        }

        public static boolean isBoolean(String string) {
            String string2 = string.trim().toLowerCase();
            return string2.equals("true") || string2.equals("false");
        }
    }

    public static class NumberTextField
    extends BreezeTextField {
        public NumberTextField(String string, TextActionEvent.TextActionListener textActionListener) {
            super(string, textActionListener);
            this.setNumberField(true);
        }
    }

    public static class UnitComboBox
    extends BreezeComboBox {
        public UnitComboBox(BreezeFrame breezeFrame, Color color, SpatialDescriptor.SiUnit siUnit, BreezeComboBox.ItemCallback<SpatialDescriptor.SiUnit> itemCallback) {
            this.addItems(Arrays.asList(SpatialDescriptor.SiUnit.values()));
            this.setSelectedItem((Object)siUnit);
            this.setRenderer(new GeneralSettingsPanel.UnitCellRenderer());
            this.setCallback(itemCallback);
        }
    }

    public static class StringFormatCellRenderer
    extends BreezeComboBox.ComboBoxListCellRenderer {
        public StringFormatCellRenderer() {
            super(0);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent(jList, (Object)StringHelper.formatLabel(object.toString()), n, bl, bl2);
        }
    }
}

