/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import lombok.Generated;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.entry.MainViewPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.TabViewContainer;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.AbstractVisualizationPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.common.cleanup.CleanUpPanel;
import se.prediktera.map.main.Project_GUI;

public abstract class AbstractViewPanel
extends CleanUpPanel
implements BreezeFrame.IFrameColor {
    private static int globalViewId = 0;
    protected BreezeMainPanel mainpanel = null;
    private final int viewId = globalViewId++;
    private final List<ActionListener> listenerList = new ArrayList<ActionListener>();
    private EntrySettingsPanel.SettingsComponent leftSettingsPanel;
    private EntrySettingsPanel.SettingsComponent rightSettingsPanel;
    protected FunctionTreeNode segmentationNode = null;

    public AbstractViewPanel() {
        this(null);
    }

    public AbstractViewPanel(BreezeMainPanel breezeMainPanel) {
        this.mainpanel = breezeMainPanel;
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.listenerList.contains(actionListener)) {
            this.listenerList.add(actionListener);
        }
    }

    public void addComponent(BreezeMainPanel breezeMainPanel) {
    }

    public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public BreezeFrame getFrame() {
        if (this.mainpanel != null) {
            return this.mainpanel.getFrame();
        }
        return null;
    }

    public Project_GUI getOrCreateEvinceProject() {
        return this.mainpanel.getOrCreateEvinceProject();
    }

    public boolean showLeftSettingsPanel() {
        return true;
    }

    public BreezeMainPanel getMainPanel() {
        return this.mainpanel;
    }

    @Override
    public Color getPageColor() {
        return this.mainpanel.getPageColor();
    }

    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
        return this.rightSettingsPanel;
    }

    public boolean showRightSettingsPanel() {
        return false;
    }

    public abstract String getType();

    public String getTypeId() {
        return this.getType() + this.viewId;
    }

    public boolean hasActionListener() {
        return !this.listenerList.isEmpty();
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(actionListener);
    }

    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        return WizardStep.LeaveResult.Ok;
    }

    public void beginUpdate() {
    }

    public void endUpdate() {
    }

    public void setBgColor(Color color) {
        this.setBackground(color);
        this.setComponentChild((JComponent)((Object)this), color, false);
    }

    public void setData(boolean bl) {
    }

    public abstract void showEntry(Object var1, Object var2);

    public void settingsToggled(boolean bl, boolean bl2) {
    }

    public boolean showNextButton() {
        return true;
    }

    protected void cleanUpChild() {
    }

    protected void setComponentChild(JComponent jComponent, Color color, boolean bl) {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            JComponent jComponent2 = (JComponent)jComponent.getComponent(i);
            if (jComponent2 instanceof JLabel) {
                JLabel jLabel = (JLabel)jComponent2;
                jLabel.setForeground(breezeTheme.getLabelForegroundDifuse());
                continue;
            }
            if (jComponent2 instanceof JTextArea) {
                JTextArea jTextArea = (JTextArea)jComponent2;
                jTextArea.setBackground(color);
                jTextArea.setForeground(breezeTheme.getLabelForegroundDifuse());
                continue;
            }
            if (jComponent2 instanceof BreezeInputField) {
                BreezeInputField breezeInputField = (BreezeInputField)jComponent2;
                breezeInputField.setLabelForeground(breezeTheme.getLabelForeground());
                continue;
            }
            if (jComponent2 instanceof JPanel) {
                if (!bl && !(jComponent2 instanceof BreezePanel)) continue;
                jComponent2.setBackground(color);
                this.setComponentChild(jComponent2, color, bl);
                continue;
            }
            if (!(jComponent2 instanceof JScrollPane)) continue;
            JScrollPane jScrollPane = (JScrollPane)jComponent2;
            this.setComponentChild((JComponent)jScrollPane.getViewport().getView().getParent(), color, bl);
        }
    }

    public boolean contentReady() {
        return true;
    }

    public void onContentReady(final OnContentReadyCallback onContentReadyCallback) {
        ThreadUtil.runAfterConditionIsMet(new ThreadUtil.RunAfterConditionIsMetCallback(){
            final /* synthetic */ AbstractViewPanel this$0;
            {
                this.this$0 = abstractViewPanel;
            }

            @Override
            public boolean conditionIsMet() {
                return this.this$0.contentReady();
            }

            @Override
            public void actionToRun() {
                onContentReadyCallback.contentReady();
            }
        });
    }

    public MainViewPanel getMainViewPanel() {
        return (MainViewPanel)SwingUtilities.getAncestorOfClass(MainViewPanel.class, (Component)((Object)this));
    }

    public void showEntrySettings(Object object, ViewClass viewClass) {
        MainViewPanel mainViewPanel = (MainViewPanel)SwingUtilities.getAncestorOfClass(MainViewPanel.class, (Component)((Object)this));
        if (mainViewPanel != null) {
            mainViewPanel.showEntrySettings(object, viewClass);
        }
    }

    public void disableProgressBar() {
        block5: {
            AbstractViewPanel abstractViewPanel;
            block4: {
                if (this instanceof AbstractVisualizationPanel) {
                    ((AbstractVisualizationPanel)this).setShowProgressBar(false);
                }
                if (!((abstractViewPanel = this) instanceof ViewContainer)) break block4;
                ViewContainer viewContainer = (ViewContainer)abstractViewPanel;
                for (int i = 0; i < viewContainer.getViewPanelCount(); ++i) {
                    AbstractViewPanel abstractViewPanel2 = viewContainer.getViewPanelAt(i);
                    abstractViewPanel2.disableProgressBar();
                }
                break block5;
            }
            abstractViewPanel = this;
            if (!(abstractViewPanel instanceof TabViewContainer)) break block5;
            TabViewContainer tabViewContainer = (TabViewContainer)abstractViewPanel;
            for (int i = 0; i < tabViewContainer.getGroups(); ++i) {
                for (int j = 0; j < tabViewContainer.getTabs(i); ++j) {
                    tabViewContainer.getTabAt(i, j).getPanel().disableProgressBar();
                }
            }
        }
    }

    public String getTitle() {
        return null;
    }

    public void applyChangesOnPanel(BreezeProgressManager breezeProgressManager) {
    }

    public int getSegmentationLevel() {
        return 0;
    }

    public String getSegmentationHashId() {
        return null;
    }

    @Generated
    public void setMainpanel(BreezeMainPanel breezeMainPanel) {
        this.mainpanel = breezeMainPanel;
    }

    @Generated
    public void setLeftSettingsPanel(EntrySettingsPanel.SettingsComponent settingsComponent) {
        this.leftSettingsPanel = settingsComponent;
    }

    @Generated
    public void setRightSettingsPanel(EntrySettingsPanel.SettingsComponent settingsComponent) {
        this.rightSettingsPanel = settingsComponent;
    }

    @Generated
    public EntrySettingsPanel.SettingsComponent getLeftSettingsPanel() {
        return this.leftSettingsPanel;
    }

    @Generated
    public EntrySettingsPanel.SettingsComponent getRightSettingsPanel() {
        return this.rightSettingsPanel;
    }

    @Generated
    public void setSegmentationNode(FunctionTreeNode functionTreeNode) {
        this.segmentationNode = functionTreeNode;
    }

    @Generated
    public FunctionTreeNode getSegmentationNode() {
        return this.segmentationNode;
    }

    public static interface OnContentReadyCallback {
        public void contentReady();
    }
}

