/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.client.RecordingsPanel;
import se.prediktera.breeze.frontend.common.BreezeTextComponentAncestor;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.common.view.preview.PreviewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MeasurementTableModel;
import se.prediktera.breeze.frontend.main.record.panel.EditMeasurementTableInteraction;
import se.prediktera.breeze.frontend.main.record.panel.MeasurementTableInteraction;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.register.RegInfo;

public class MeasurementViewPanel
extends AbstractViewPanel
implements BreezeTextComponentAncestor {
    private Measurement measurement;
    private final BreezeButton applyChangesButton;
    private final TableHelper tableHelper;
    private final BreezeButton evinceButton;
    private final PreviewPanel previewPanel;
    private final EditMeasurementTableInteraction.TableSettingsPanel tableSettingsPanel;
    private final BreezeInputField nameTextField = new BreezeInputField("Name", "", "", BreezeInputFieldHelper.Format.OneRow);
    private final BreezeTablePanel sampleTablePanel = new BreezeTablePanel();
    private BreezeButton addSampleButton;
    private BreezeButton addColumnButton;
    private int changeIndex;
    private int workflowIndex;

    public MeasurementViewPanel() {
        this(null, null);
    }

    public MeasurementViewPanel(EntryMainPanel entryMainPanel, Workflow workflow) {
        super(entryMainPanel);
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("Tahoma", 0, 14));
        jLabel.setForeground(new Color(150, 150, 150));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n/Language_ENG");
        jLabel.setText(resourceBundle.getString("Identifier"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add(jLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = jPanel.getComponentCount();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 10, 10);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.setName("measurementName");
        this.nameTextField.setMinlength(1);
        this.nameTextField.addChangeListener(textActionEvent -> {
            try {
                String string = this.nameTextField.getValue();
                FileHelper.checkValidNameOrThrow(string);
                this.measurement.rename(string);
                ToastHandler.getInstance().showToast(entryMainPanel.getFrame(), "Renamed");
                if (entryMainPanel != null) {
                    entryMainPanel.repaintEntryList();
                    entryMainPanel.setFormatedTitle(this.measurement);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        });
        this.nameTextField.setTriggerChangeOnCross(false);
        this.nameTextField.setEmptyText("Enter value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = jPanel.getComponentCount();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("Tahoma", 0, 14));
        jLabel2.setForeground(new Color(150, 150, 150));
        jLabel2.setText("Samples");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add(jLabel2, gridBagConstraints);
        this.sampleTablePanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)((Object)this.sampleTablePanel), gridBagConstraints);
        this.previewPanel = new PreviewPanel(workflow);
        this.previewPanel.setSettingsViewPanel(this);
        this.tableSettingsPanel = new EditMeasurementTableInteraction.TableSettingsPanel(entryMainPanel);
        this.sampleTablePanel.setSortable(true);
        this.sampleTablePanel.setAbstractViewPanel(this);
        this.tableHelper = new TableHelper(this);
        this.sampleTablePanel.initTable(this.tableHelper, null, false);
        this.sampleTablePanel.getTable().setSelectionMode(2);
        this.sampleTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
        this.sampleTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
        this.sampleTablePanel.setVisualisationNode(workflow, null);
        this.sampleTablePanel.addPreviewColumnListener(this.previewPanel);
        this.evinceButton = EntryMainHelper.createButton("Open in Evince", "Evince_24", () -> EvinceHelper.startEvince(((EntryMainPanel)this.getMainPanel()).getSelectedEntries()));
        this.applyChangesButton = entryMainPanel instanceof RecordingsPanel.RecordingsMeasurementPanel ? null : EntryMainHelper.createApplyButton(entryMainPanel, new ProgressAction(){

            @Override
            public void runAction() throws Exception {
                MeasurementViewPanel.this.applyChangesOnPanel(this.getProgressManager());
            }
        });
        this.sampleTablePanel.addToToolbar(EntryMainHelper.createButton("Table height", "material/height", () -> this.sampleTablePanel.showCellHeightDialog(entryMainPanel)));
        this.sampleTablePanel.addToToolbar(EntryMainHelper.createButton("Table width", "material/width", () -> this.sampleTablePanel.showCellWidthDialog(entryMainPanel)));
        this.sampleTablePanel.addToToolbar(EntryMainHelper.createButton("Table auto-fit", "material/fit_width", () -> {
            this.sampleTablePanel.setColumnWidth(0);
            BreezeProperties.getInstance().setTableCellWidth(0);
        }));
        if (entryMainPanel.getPageType().equals((Object)BreezeType.Project)) {
            if (RegInfo.isApplicationFeature()) {
                this.addSampleButton = EntryMainHelper.createButton("Add Sample model", "material/tab_new_right", () -> MeasurementTableInteraction.addNewSegmentation(entryMainPanel, Workflow.getWorkflow(this.measurement)));
            }
            this.addColumnButton = EntryMainHelper.createButton("Add Variable or Id", "material/variable_add", () -> MeasurementTableInteraction.addColumn(entryMainPanel, Workflow.getWorkflow(this.measurement)));
        }
        this.setLeftSettingsPanel(this.previewPanel);
        this.setRightSettingsPanel(this.tableSettingsPanel);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        jPanel.setBackground(breezeTheme.getSettingPanelBackground());
    }

    public BreezeTablePanel getSampleTablePanel() {
        return this.sampleTablePanel;
    }

    @Override
    public void applyChangesOnPanel(BreezeProgressManager breezeProgressManager) {
        EntryMeasurementPanel entryMeasurementPanel = (EntryMeasurementPanel)this.mainpanel;
        this.previewPanel.clearSelection("Applying changes");
        entryMeasurementPanel.applyChangesRealtime(breezeProgressManager);
    }

    @Override
    public int getSegmentationLevel() {
        Workflow workflow;
        if (this.measurement != null && (workflow = this.measurement.getWorkflow()) != null) {
            return workflow.getSegmentationLevel();
        }
        return 0;
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        if (this.addSampleButton != null || this.addColumnButton != null) {
            if (this.addSampleButton != null) {
                breezeMainPanel.addRightButton(this.addSampleButton);
            }
            breezeMainPanel.addRightButton(this.addColumnButton);
            breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        }
        if (this.applyChangesButton != null) {
            breezeMainPanel.addRightButton(this.applyChangesButton);
            breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
        }
        if (EvinceHelper.exists()) {
            breezeMainPanel.addRightButton(this.evinceButton);
        }
    }

    public Measurement getEntry() {
        return this.measurement;
    }

    public BasicPreviewPanel getPreviewPanel() {
        return this.previewPanel;
    }

    @Override
    public String getType() {
        return "Settings";
    }

    @Override
    public void setBgColor(Color color) {
        super.setBgColor(color);
    }

    @Override
    public void setData(boolean bl) {
        if (bl) {
            DataSetCache.clear(this.measurement);
        }
        this.showEntry(this.measurement, null);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (object instanceof Measurement) {
            Measurement measurement = (Measurement)object;
            boolean bl = this.measurement != measurement;
            this.measurement = measurement;
            Workflow workflow = measurement.getWorkflow();
            boolean bl2 = this.workflowIndex != workflow.getChangeIndex();
            this.workflowIndex = workflow.getChangeIndex();
            boolean bl3 = this.changeIndex != measurement.getChangeIndex();
            this.changeIndex = measurement.getChangeIndex();
            this.sampleTablePanel.setVisualisationNode(workflow, measurement);
            this.nameTextField.setText(measurement.getName());
            this.tableHelper.setRoot(workflow);
            if (bl || bl3 || bl2) {
                List<Sample> list = measurement.getSamplesForCurrentLevel();
                SwingUtilities.invokeLater(() -> {
                    this.sampleTablePanel.setTableList(list, list.isEmpty() ? null : list.get(0));
                    this.previewPanel.setData(measurement, this.sampleTablePanel.getSelectedValues(), bl2);
                });
            }
        } else {
            this.measurement = null;
        }
        this.tableSettingsPanel.update(this.sampleTablePanel, this.measurement);
    }

    @Override
    public void settingsToggled(boolean bl, boolean bl2) {
        SwingUtilities.invokeLater(this.sampleTablePanel::updateColumnWidth);
    }

    public boolean hasSubsamples(List<Sample> list, List<Sample> list2) {
        if (list.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == list2.get(i)) continue;
            return true;
        }
        return false;
    }

    public void selectSamples(List<Sample> list) {
        this.sampleTablePanel.selectSamples(list);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    private class TableHelper
    extends MeasurementTableModel {
        private final SwingTimer updateTimer = new SwingTimer(50, actionEvent -> {
            measurementViewPanel.previewPanel.setSelectedSamples(measurementViewPanel.sampleTablePanel.getSelectedValues());
            if (measurementViewPanel.mainpanel != null) {
                measurementViewPanel.mainpanel.repaintEntryList();
            }
        });

        public TableHelper(MeasurementViewPanel measurementViewPanel) {
            this.updateTimer.setRepeats(false);
        }

        @Override
        public void valueChanged() {
            this.updateTimer.restart();
        }
    }
}

